/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.property;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.state.AbstractStateHolder;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraftforge.common.property.IExtendedState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class ExtendedStateContainer<O, S extends IExtendedState<S>>
extends StateContainer<O, S> {
    private final ImmutableSet<IUnlistedProperty<?>> unlistedProperties;

    public <A extends AbstractStateHolder<O, S>> ExtendedStateContainer(O blockIn, StateContainer.IFactory<O, S, A> stateFactory, IProperty<?>[] properties, IUnlistedProperty<?>[] unlistedProperties) {
        super(blockIn, ExtendedStateContainer.getProxyFactory(unlistedProperties, stateFactory), ExtendedStateContainer.buildListedMap(properties));
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (IUnlistedProperty<?> property : unlistedProperties) {
            builder.add(property);
        }
        this.unlistedProperties = builder.build();
    }

    private static <O, S extends IExtendedState<S>, A extends AbstractStateHolder<O, S>> StateContainer.IFactory<O, S, AbstractStateHolder<O, S>> getProxyFactory(IUnlistedProperty<?>[] unlistedProperties, StateContainer.IFactory<O, S, A> proxy) {
        return (o, props) -> {
            if (unlistedProperties == null || unlistedProperties.length == 0) {
                return proxy.create(o, props);
            }
            return new ExtendedStateHolder<Object, Object>(o, props, ExtendedStateContainer.buildUnlistedMap(unlistedProperties), null);
        };
    }

    public Collection<IUnlistedProperty<?>> getUnlistedProperties() {
        return this.unlistedProperties;
    }

    private static Map<String, IProperty<?>> buildListedMap(IProperty<?>[] properties) {
        return Arrays.stream(properties).collect(Collectors.toMap(IProperty::func_177701_a, Function.identity()));
    }

    private static ImmutableMap<IUnlistedProperty<?>, Optional<?>> buildUnlistedMap(IUnlistedProperty<?>[] unlistedProperties) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (IUnlistedProperty<?> p : unlistedProperties) {
            builder.put(p, Optional.empty());
        }
        return builder.build();
    }

    protected static class ExtendedStateHolder<O, S extends IExtendedState<S>>
    extends AbstractStateHolder<O, S>
    implements IExtendedState<S> {
        private final ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties;
        private S cleanState;

        protected ExtendedStateHolder(O block, ImmutableMap<IProperty<?>, Comparable<?>> properties, ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties, S clean) {
            super(block, properties);
            this.unlistedProperties = unlistedProperties;
            this.cleanState = clean == null ? this : clean;
        }

        @Nonnull
        public <T extends Comparable<T>, V extends T> S with(@Nonnull IProperty<T> property, @Nonnull V value) {
            IExtendedState clean = (IExtendedState)super.func_206870_a(property, value);
            if (clean == this.cleanState) {
                return (S)this;
            }
            if (this == this.cleanState) {
                return (S)clean;
            }
            return (S)new ExtendedStateHolder<Object, S>(this.field_206876_a, clean.func_206871_b(), this.unlistedProperties, this.cleanState);
        }

        @Override
        public <V> S withProperty(IUnlistedProperty<V> property, @Nullable V value) {
            Optional oldValue = (Optional)this.unlistedProperties.get(property);
            if (oldValue == null) {
                throw new IllegalArgumentException("Cannot set unlisted property " + property + " as it does not exist in " + this);
            }
            if (Objects.equals(oldValue.orElse(null), value)) {
                return (S)this;
            }
            if (!property.isValid(value)) {
                throw new IllegalArgumentException("Cannot set unlisted property " + property + " to " + value + " on object " + this.field_206876_a + ", it is not an allowed value");
            }
            boolean clean = true;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry entry : this.unlistedProperties.entrySet()) {
                Optional newValue;
                IUnlistedProperty key = (IUnlistedProperty)entry.getKey();
                Optional optional = newValue = key.equals(property) ? Optional.ofNullable(value) : (Optional)entry.getValue();
                if (newValue.isPresent()) {
                    clean = false;
                }
                builder.put((Object)key, (Object)newValue);
            }
            if (clean) {
                return this.cleanState;
            }
            return (S)new ExtendedStateHolder<Object, S>(this.field_206876_a, this.func_206871_b(), builder.build(), this.cleanState);
        }

        @Override
        public Collection<IUnlistedProperty<?>> getUnlistedNames() {
            return this.unlistedProperties.keySet();
        }

        @Override
        @Nullable
        public <V> V getValue(IUnlistedProperty<V> property) {
            Optional value = (Optional)this.unlistedProperties.get(property);
            if (value == null) {
                throw new IllegalArgumentException("Cannot get unlisted property " + property + " as it does not exist in " + this);
            }
            return property.getType().cast(value.orElse(null));
        }

        @Override
        public ImmutableMap<IUnlistedProperty<?>, Optional<?>> getUnlistedProperties() {
            return this.unlistedProperties;
        }

        @Override
        public S getClean() {
            return this.cleanState;
        }
    }
}

