/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.world;

import com.google.common.base.Preconditions;
import net.minecraft.block.state.IBlockState;
import net.minecraft.state.properties.NoteBlockInstrument;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Cancelable;

public class NoteBlockEvent
extends BlockEvent {
    private int noteId;

    protected NoteBlockEvent(World world, BlockPos pos, IBlockState state, int note) {
        super((IWorld)world, pos, state);
        this.noteId = note;
    }

    public Note getNote() {
        return Note.fromId(this.noteId);
    }

    public Octave getOctave() {
        return Octave.fromId(this.noteId);
    }

    public int getVanillaNoteId() {
        return this.noteId;
    }

    public void setNote(Note note, Octave octave) {
        Preconditions.checkArgument((octave != Octave.HIGH || note == Note.F_SHARP ? 1 : 0) != 0, (Object)"Octave.HIGH is only valid for Note.F_SHARP!");
        this.noteId = note.ordinal() + octave.ordinal() * 12;
    }

    public static enum Octave {
        LOW,
        MID,
        HIGH;


        static Octave fromId(int id) {
            return id < 12 ? LOW : (id == 24 ? HIGH : MID);
        }
    }

    public static enum Note {
        F_SHARP,
        G,
        G_SHARP,
        A,
        A_SHARP,
        B,
        C,
        C_SHARP,
        D,
        D_SHARP,
        E,
        F;

        private static final Note[] values;

        static Note fromId(int id) {
            return values[id % 12];
        }

        static {
            values = Note.values();
        }
    }

    @Cancelable
    public static class Change
    extends NoteBlockEvent {
        private final Note oldNote;
        private final Octave oldOctave;

        public Change(World world, BlockPos pos, IBlockState state, int oldNote, int newNote) {
            super(world, pos, state, newNote);
            this.oldNote = Note.fromId(oldNote);
            this.oldOctave = Octave.fromId(oldNote);
        }

        public Note getOldNote() {
            return this.oldNote;
        }

        public Octave getOldOctave() {
            return this.oldOctave;
        }
    }

    @Cancelable
    public static class Play
    extends NoteBlockEvent {
        private NoteBlockInstrument instrument;

        public Play(World world, BlockPos pos, IBlockState state, int note, NoteBlockInstrument instrument) {
            super(world, pos, state, note);
            this.instrument = instrument;
        }

        public NoteBlockInstrument getInstrument() {
            return this.instrument;
        }

        public void setInstrument(NoteBlockInstrument instrument) {
            this.instrument = instrument;
        }
    }
}

