/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.server;

import java.nio.file.Path;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.network.EnumConnectionState;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.handshake.client.CPacketHandshake;
import net.minecraft.network.login.server.SPacketDisconnectLogin;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.loading.FileUtils;
import net.minecraftforge.fml.network.ConnectionType;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.packs.ResourcePackLoader;
import net.minecraftforge.fml.server.LanguageHook;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class ServerLifecycleHooks {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker SERVERHOOKS = MarkerManager.getMarker((String)"SERVERHOOKS");
    private static volatile CountDownLatch exitLatch = null;
    private static MinecraftServer currentServer;
    private static AtomicBoolean allowLogins;

    public static boolean handleServerAboutToStart(MinecraftServer server) {
        currentServer = server;
        LogicalSidedProvider.setServer(() -> server);
        Path serverConfig = server.func_71254_M().func_186352_b(server.func_71270_I(), "serverconfig").toPath();
        FileUtils.getOrCreateDirectory((Path)serverConfig, (String)"serverconfig");
        ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.SERVER, serverConfig);
        ResourcePackLoader.loadResourcePacks(currentServer.func_195561_aH());
        return !MinecraftForge.EVENT_BUS.post((Event)new FMLServerAboutToStartEvent(server));
    }

    public static boolean handleServerStarting(MinecraftServer server) {
        DistExecutor.runWhenOn(Dist.DEDICATED_SERVER, () -> () -> LanguageHook.loadLanguagesOnServer(server));
        return !MinecraftForge.EVENT_BUS.post((Event)new FMLServerStartingEvent(server));
    }

    public static void handleServerStarted(MinecraftServer server) {
        MinecraftForge.EVENT_BUS.post((Event)new FMLServerStartedEvent(server));
        allowLogins.set(true);
    }

    public static void handleServerStopping(MinecraftServer server) {
        allowLogins.set(false);
        MinecraftForge.EVENT_BUS.post((Event)new FMLServerStoppingEvent(server));
    }

    public static void expectServerStopped() {
        exitLatch = new CountDownLatch(1);
    }

    public static void handleServerStopped(MinecraftServer server) {
        MinecraftForge.EVENT_BUS.post((Event)new FMLServerStoppedEvent(server));
        currentServer = null;
        LogicalSidedProvider.setServer(null);
        CountDownLatch latch = exitLatch;
        if (latch != null) {
            latch.countDown();
            exitLatch = null;
        }
    }

    public static MinecraftServer getCurrentServer() {
        return currentServer;
    }

    public static boolean handleServerLogin(CPacketHandshake packet, NetworkManager manager) {
        if (!allowLogins.get()) {
            TextComponentString text = new TextComponentString("Server is still starting! Please wait before reconnecting.");
            LOGGER.info(SERVERHOOKS, "Disconnecting Player (server is still starting): {}", (Object)text.func_150261_e());
            manager.func_179290_a((Packet)new SPacketDisconnectLogin((ITextComponent)text));
            manager.func_150718_a((ITextComponent)text);
            return false;
        }
        if (packet.func_149594_c() == EnumConnectionState.LOGIN) {
            ConnectionType connectionType = ConnectionType.forVersionFlag(packet.getFMLVersion());
            int versionNumber = connectionType.getFMLVersionNumber(packet.getFMLVersion());
            if (connectionType == ConnectionType.MODDED && versionNumber != 2) {
                ServerLifecycleHooks.rejectConnection(manager, connectionType, "This modded server is not network compatible with your modded client. Please verify your Forge version closely matches the server. Got net version " + versionNumber + " this server is net version " + 2);
                return false;
            }
            if (connectionType == ConnectionType.VANILLA && !NetworkRegistry.acceptsVanillaClientConnections()) {
                ServerLifecycleHooks.rejectConnection(manager, connectionType, "This server has mods that require Forge to be installed on the client. Contact your server admin for more details.");
                return false;
            }
        }
        if (packet.func_149594_c() == EnumConnectionState.STATUS) {
            return true;
        }
        NetworkHooks.registerServerLoginChannel(manager, packet);
        return true;
    }

    private static void rejectConnection(NetworkManager manager, ConnectionType type, String message) {
        manager.func_150723_a(EnumConnectionState.LOGIN);
        LOGGER.info(SERVERHOOKS, "Disconnecting {} connection attempt: ", (Object)type, (Object)message);
        TextComponentString text = new TextComponentString(message);
        manager.func_179290_a((Packet)new SPacketDisconnectLogin((ITextComponent)text));
        manager.func_150718_a((ITextComponent)text);
    }

    public static void handleExit(int retVal) {
        System.exit(retVal);
    }

    static {
        allowLogins = new AtomicBoolean(false);
    }
}

