/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.logging;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.message.SimpleMessage;

public class ModelLoaderErrorMessage
extends SimpleMessage {
    private final ModelResourceLocation resourceLocation;
    private final Exception exception;
    private static Multimap<ModelResourceLocation, IBlockState> reverseBlockMap = HashMultimap.create();
    private static Multimap<ModelResourceLocation, String> reverseItemMap = HashMultimap.create();

    private static void buildLookups() {
        if (!reverseBlockMap.isEmpty()) {
            return;
        }
        ForgeRegistries.BLOCKS.getValues().stream().flatMap(block -> block.func_176194_O().func_177619_a().stream()).forEach(state -> reverseBlockMap.put((Object)BlockModelShapes.func_209554_c((IBlockState)state), state));
        ForgeRegistries.ITEMS.forEach(item -> {
            ModelResourceLocation memory = ModelLoader.getInventoryVariant(ForgeRegistries.ITEMS.getKey((Item)item).toString());
            reverseItemMap.put((Object)memory, (Object)item.getRegistryName().toString());
        });
    }

    public ModelLoaderErrorMessage(ModelResourceLocation resourceLocation, Exception exception) {
        ModelLoaderErrorMessage.buildLookups();
        this.resourceLocation = resourceLocation;
        this.exception = exception;
    }

    private void stuffs() {
        Collection items;
        String domain = this.resourceLocation.func_110624_b();
        String errorMsg = "Exception loading model for variant " + this.resourceLocation;
        Collection blocks = reverseBlockMap.get((Object)this.resourceLocation);
        if (!blocks.isEmpty()) {
            errorMsg = blocks.size() == 1 ? errorMsg + " for blockstate \"" + blocks.iterator().next() + "\"" : errorMsg + " for blockstates [\"" + Joiner.on((String)"\", \"").join((Iterable)blocks) + "\"]";
        }
        if (!(items = reverseItemMap.get((Object)this.resourceLocation)).isEmpty()) {
            if (!blocks.isEmpty()) {
                errorMsg = errorMsg + " and";
            }
            errorMsg = items.size() == 1 ? errorMsg + " for item \"" + (String)items.iterator().next() + "\"" : errorMsg + " for items [\"" + Joiner.on((String)"\", \"").join((Iterable)items) + "\"]";
        }
        if (this.exception instanceof ModelLoader.ItemLoadingException) {
            ModelLoader.ItemLoadingException itemLoadingException = (ModelLoader.ItemLoadingException)this.exception;
        }
    }

    public void formatTo(StringBuilder buffer) {
    }
}

