/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.console;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import net.minecraft.server.dedicated.DedicatedServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;

final class ConsoleCommandCompleter
implements Completer {
    private static final Logger logger = LogManager.getLogger();
    private final DedicatedServer server;

    public ConsoleCommandCompleter(DedicatedServer server) {
        this.server = (DedicatedServer)Preconditions.checkNotNull((Object)server, (Object)"server");
    }

    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        boolean prefix;
        String buffer = line.line();
        if (buffer.isEmpty() || buffer.charAt(0) != '/') {
            buffer = '/' + buffer;
            prefix = false;
        } else {
            prefix = true;
        }
        String input = buffer;
        FutureTask<List> tabComplete = new FutureTask<List>(() -> Collections.emptyList());
        try {
            for (String completion : (List)tabComplete.get()) {
                if (completion.isEmpty()) continue;
                boolean hasPrefix = prefix || completion.charAt(0) != '/';
                Candidate candidate = new Candidate(hasPrefix ? completion : completion.substring(1));
                candidates.add(candidate);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            logger.error("Failed to tab complete", (Throwable)e);
        }
    }
}

