/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public class GuiScreenEvent
extends Event {
    private final GuiScreen gui;

    public GuiScreenEvent(GuiScreen gui) {
        this.gui = gui;
    }

    public GuiScreen getGui() {
        return this.gui;
    }

    public static class KeyboardCharTypedEvent
    extends GuiScreenEvent {
        private final char codePoint;
        private final int modifiers;

        public KeyboardCharTypedEvent(GuiScreen gui, char codePoint, int modifiers) {
            super(gui);
            this.codePoint = codePoint;
            this.modifiers = modifiers;
        }

        public char getCodePoint() {
            return this.codePoint;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        @Cancelable
        public static class Post
        extends KeyboardCharTypedEvent {
            public Post(GuiScreen gui, char codePoint, int modifiers) {
                super(gui, codePoint, modifiers);
            }
        }

        @Cancelable
        public static class Pre
        extends KeyboardCharTypedEvent {
            public Pre(GuiScreen gui, char codePoint, int modifiers) {
                super(gui, codePoint, modifiers);
            }
        }
    }

    public static abstract class KeyboardKeyReleasedEvent
    extends KeyboardKeyEvent {
        public KeyboardKeyReleasedEvent(GuiScreen gui, int keyCode, int scanCode, int modifiers) {
            super(gui, keyCode, scanCode, modifiers);
        }

        @Cancelable
        public static class Post
        extends KeyboardKeyReleasedEvent {
            public Post(GuiScreen gui, int keyCode, int scanCode, int modifiers) {
                super(gui, keyCode, scanCode, modifiers);
            }
        }

        @Cancelable
        public static class Pre
        extends KeyboardKeyReleasedEvent {
            public Pre(GuiScreen gui, int keyCode, int scanCode, int modifiers) {
                super(gui, keyCode, scanCode, modifiers);
            }
        }
    }

    public static abstract class KeyboardKeyPressedEvent
    extends KeyboardKeyEvent {
        public KeyboardKeyPressedEvent(GuiScreen gui, int keyCode, int scanCode, int modifiers) {
            super(gui, keyCode, scanCode, modifiers);
        }

        @Cancelable
        public static class Post
        extends KeyboardKeyPressedEvent {
            public Post(GuiScreen gui, int keyCode, int scanCode, int modifiers) {
                super(gui, keyCode, scanCode, modifiers);
            }
        }

        @Cancelable
        public static class Pre
        extends KeyboardKeyPressedEvent {
            public Pre(GuiScreen gui, int keyCode, int scanCode, int modifiers) {
                super(gui, keyCode, scanCode, modifiers);
            }
        }
    }

    public static abstract class KeyboardKeyEvent
    extends GuiScreenEvent {
        private final int keyCode;
        private final int scanCode;
        private final int modifiers;

        public KeyboardKeyEvent(GuiScreen gui, int keyCode, int scanCode, int modifiers) {
            super(gui);
            this.keyCode = keyCode;
            this.scanCode = scanCode;
            this.modifiers = modifiers;
        }

        public int getKeyCode() {
            return this.keyCode;
        }

        public int getScanCode() {
            return this.scanCode;
        }

        public int getModifiers() {
            return this.modifiers;
        }
    }

    public static abstract class MouseScrollEvent
    extends MouseInputEvent {
        private final double scrollDelta;

        public MouseScrollEvent(GuiScreen gui, double mouseX, double mouseY, double scrollDelta) {
            super(gui, mouseX, mouseY);
            this.scrollDelta = scrollDelta;
        }

        public double getScrollDelta() {
            return this.scrollDelta;
        }

        @Cancelable
        public static class Post
        extends MouseScrollEvent {
            public Post(GuiScreen gui, double mouseX, double mouseY, double scrollDelta) {
                super(gui, mouseX, mouseY, scrollDelta);
            }
        }

        @Cancelable
        public static class Pre
        extends MouseScrollEvent {
            public Pre(GuiScreen gui, double mouseX, double mouseY, double scrollDelta) {
                super(gui, mouseX, mouseY, scrollDelta);
            }
        }
    }

    public static abstract class MouseDragEvent
    extends MouseInputEvent {
        private final int mouseButton;
        private final double dragX;
        private final double dragY;

        public MouseDragEvent(GuiScreen gui, double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
            super(gui, mouseX, mouseY);
            this.mouseButton = mouseButton;
            this.dragX = dragX;
            this.dragY = dragY;
        }

        public int getMouseButton() {
            return this.mouseButton;
        }

        public double getDragX() {
            return this.dragX;
        }

        public double getDragY() {
            return this.dragY;
        }

        @Cancelable
        public static class Post
        extends MouseDragEvent {
            public Post(GuiScreen gui, double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
                super(gui, mouseX, mouseY, mouseButton, dragX, dragY);
            }
        }

        @Cancelable
        public static class Pre
        extends MouseDragEvent {
            public Pre(GuiScreen gui, double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
                super(gui, mouseX, mouseY, mouseButton, dragX, dragY);
            }
        }
    }

    public static abstract class MouseReleasedEvent
    extends MouseInputEvent {
        private final int button;

        public MouseReleasedEvent(GuiScreen gui, double mouseX, double mouseY, int button) {
            super(gui, mouseX, mouseY);
            this.button = button;
        }

        public int getButton() {
            return this.button;
        }

        @Cancelable
        public static class Post
        extends MouseReleasedEvent {
            public Post(GuiScreen gui, double mouseX, double mouseY, int button) {
                super(gui, mouseX, mouseY, button);
            }
        }

        @Cancelable
        public static class Pre
        extends MouseReleasedEvent {
            public Pre(GuiScreen gui, double mouseX, double mouseY, int button) {
                super(gui, mouseX, mouseY, button);
            }
        }
    }

    public static abstract class MouseClickedEvent
    extends MouseInputEvent {
        private final int button;

        public MouseClickedEvent(GuiScreen gui, double mouseX, double mouseY, int button) {
            super(gui, mouseX, mouseY);
            this.button = button;
        }

        public int getButton() {
            return this.button;
        }

        @Cancelable
        public static class Post
        extends MouseClickedEvent {
            public Post(GuiScreen gui, double mouseX, double mouseY, int button) {
                super(gui, mouseX, mouseY, button);
            }
        }

        @Cancelable
        public static class Pre
        extends MouseClickedEvent {
            public Pre(GuiScreen gui, double mouseX, double mouseY, int button) {
                super(gui, mouseX, mouseY, button);
            }
        }
    }

    public static abstract class MouseInputEvent
    extends GuiScreenEvent {
        private final double mouseX;
        private final double mouseY;

        public MouseInputEvent(GuiScreen gui, double mouseX, double mouseY) {
            super(gui);
            this.mouseX = mouseX;
            this.mouseY = mouseY;
        }

        public double getMouseX() {
            return this.mouseX;
        }

        public double getMouseY() {
            return this.mouseY;
        }
    }

    public static class ActionPerformedEvent
    extends GuiScreenEvent {
        private GuiButton button;
        private List<GuiButton> buttonList;

        public ActionPerformedEvent(GuiScreen gui, GuiButton button, List<GuiButton> buttonList) {
            super(gui);
            this.setButton(button);
            this.setButtonList(new ArrayList<GuiButton>(buttonList));
        }

        public GuiButton getButton() {
            return this.button;
        }

        public void setButton(GuiButton button) {
            this.button = button;
        }

        public List<GuiButton> getButtonList() {
            return this.buttonList;
        }

        public void setButtonList(List<GuiButton> buttonList) {
            this.buttonList = buttonList;
        }

        public static class Post
        extends ActionPerformedEvent {
            public Post(GuiScreen gui, GuiButton button, List<GuiButton> buttonList) {
                super(gui, button, buttonList);
            }
        }

        @Cancelable
        public static class Pre
        extends ActionPerformedEvent {
            public Pre(GuiScreen gui, GuiButton button, List<GuiButton> buttonList) {
                super(gui, button, buttonList);
            }
        }
    }

    @Cancelable
    public static class PotionShiftEvent
    extends GuiScreenEvent {
        public PotionShiftEvent(GuiScreen gui) {
            super(gui);
        }
    }

    public static class BackgroundDrawnEvent
    extends GuiScreenEvent {
        public BackgroundDrawnEvent(GuiScreen gui) {
            super(gui);
        }
    }

    public static class DrawScreenEvent
    extends GuiScreenEvent {
        private final int mouseX;
        private final int mouseY;
        private final float renderPartialTicks;

        public DrawScreenEvent(GuiScreen gui, int mouseX, int mouseY, float renderPartialTicks) {
            super(gui);
            this.mouseX = mouseX;
            this.mouseY = mouseY;
            this.renderPartialTicks = renderPartialTicks;
        }

        public int getMouseX() {
            return this.mouseX;
        }

        public int getMouseY() {
            return this.mouseY;
        }

        public float getRenderPartialTicks() {
            return this.renderPartialTicks;
        }

        public static class Post
        extends DrawScreenEvent {
            public Post(GuiScreen gui, int mouseX, int mouseY, float renderPartialTicks) {
                super(gui, mouseX, mouseY, renderPartialTicks);
            }
        }

        @Cancelable
        public static class Pre
        extends DrawScreenEvent {
            public Pre(GuiScreen gui, int mouseX, int mouseY, float renderPartialTicks) {
                super(gui, mouseX, mouseY, renderPartialTicks);
            }
        }
    }

    public static class InitGuiEvent
    extends GuiScreenEvent {
        private Consumer<GuiButton> addButton;
        private Consumer<GuiButton> removeButton;
        private List<GuiButton> buttonList;

        public InitGuiEvent(GuiScreen gui, List<GuiButton> buttonList, Consumer<GuiButton> addButton, Consumer<GuiButton> removeButton) {
            super(gui);
            this.buttonList = Collections.unmodifiableList(buttonList);
            this.addButton = addButton;
            this.removeButton = removeButton;
        }

        public List<GuiButton> getButtonList() {
            return this.buttonList;
        }

        public void addButton(GuiButton button) {
            this.addButton.accept(button);
        }

        public void removeButton(GuiButton button) {
            this.removeButton.accept(button);
        }

        public static class Post
        extends InitGuiEvent {
            public Post(GuiScreen gui, List<GuiButton> buttonList, Consumer<GuiButton> addButton, Consumer<GuiButton> removeButton) {
                super(gui, buttonList, addButton, removeButton);
            }
        }

        @Cancelable
        public static class Pre
        extends InitGuiEvent {
            public Pre(GuiScreen gui, List<GuiButton> buttonList, Consumer<GuiButton> addButton, Consumer<GuiButton> removeButton) {
                super(gui, buttonList, addButton, removeButton);
            }
        }
    }
}

