/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.TRSRTransformation;

public final class ItemTextureQuadConverter {
    private ItemTextureQuadConverter() {
    }

    public static List<UnpackedBakedQuad> convertTexture(VertexFormat format, TRSRTransformation transform, TextureAtlasSprite template, TextureAtlasSprite sprite, float z, EnumFacing facing, int color, int tint) {
        List<UnpackedBakedQuad> horizontal = ItemTextureQuadConverter.convertTextureHorizontal(format, transform, template, sprite, z, facing, color, tint);
        List<UnpackedBakedQuad> vertical = ItemTextureQuadConverter.convertTextureVertical(format, transform, template, sprite, z, facing, color, tint);
        return horizontal.size() >= vertical.size() ? horizontal : vertical;
    }

    public static List<UnpackedBakedQuad> convertTextureHorizontal(VertexFormat format, TRSRTransformation transform, TextureAtlasSprite template, TextureAtlasSprite sprite, float z, EnumFacing facing, int color, int tint) {
        int w = template.func_94211_a();
        int h = template.func_94216_b();
        float wScale = 16.0f / (float)w;
        float hScale = 16.0f / (float)h;
        ArrayList quads = Lists.newArrayList();
        int start = -1;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                boolean isVisible;
                boolean bl = isVisible = !template.func_195662_a(0, x, y);
                if (start < 0 && isVisible) {
                    start = x;
                }
                if (start < 0 || isVisible) continue;
                int endY = y + 1;
                boolean sameRow = true;
                while (sameRow && endY < h) {
                    for (int i = 0; i < w; ++i) {
                        if (template.func_195662_a(0, i, y) == template.func_195662_a(0, i, endY)) continue;
                        sameRow = false;
                        break;
                    }
                    if (!sameRow) continue;
                    ++endY;
                }
                quads.add(ItemTextureQuadConverter.genQuad(format, transform, (float)start * wScale, (float)y * hScale, (float)x * wScale, (float)endY * hScale, z, sprite, facing, color, tint));
                if (endY - y > 1) {
                    y = endY - 1;
                }
                start = -1;
            }
        }
        return quads;
    }

    public static List<UnpackedBakedQuad> convertTextureVertical(VertexFormat format, TRSRTransformation transform, TextureAtlasSprite template, TextureAtlasSprite sprite, float z, EnumFacing facing, int color, int tint) {
        int w = template.func_94211_a();
        int h = template.func_94216_b();
        float wScale = 16.0f / (float)w;
        float hScale = 16.0f / (float)h;
        ArrayList quads = Lists.newArrayList();
        int start = -1;
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                boolean isVisible;
                boolean bl = isVisible = !sprite.func_195662_a(0, x, y);
                if (start < 0 && isVisible) {
                    start = y;
                }
                if (start < 0 || isVisible) continue;
                int endX = x + 1;
                boolean sameColumn = true;
                while (sameColumn && endX < w) {
                    for (int i = 0; i < h; ++i) {
                        if (sprite.func_195662_a(0, x, i) == sprite.func_195662_a(0, endX, i)) continue;
                        sameColumn = false;
                        break;
                    }
                    if (!sameColumn) continue;
                    ++endX;
                }
                quads.add(ItemTextureQuadConverter.genQuad(format, transform, (float)x * wScale, (float)start * hScale, (float)endX * wScale, (float)y * hScale, z, sprite, facing, color, tint));
                if (endX - x > 1) {
                    x = endX - 1;
                }
                start = -1;
            }
        }
        return quads;
    }

    private static boolean isVisible(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f > 0.1f;
    }

    public static UnpackedBakedQuad genQuad(VertexFormat format, TRSRTransformation transform, float x1, float y1, float x2, float y2, float z, TextureAtlasSprite sprite, EnumFacing facing, int color, int tint) {
        float u1 = sprite.func_94214_a((double)x1);
        float v1 = sprite.func_94207_b((double)y1);
        float u2 = sprite.func_94214_a((double)x2);
        float v2 = sprite.func_94207_b((double)y2);
        float tmp = y1 /= 16.0f;
        y1 = 1.0f - (y2 /= 16.0f);
        y2 = 1.0f - tmp;
        return ItemTextureQuadConverter.putQuad(format, transform, facing, sprite, color, tint, x1 /= 16.0f, y1, x2 /= 16.0f, y2, z, u1, v1, u2, v2);
    }

    private static UnpackedBakedQuad putQuad(VertexFormat format, TRSRTransformation transform, EnumFacing side, TextureAtlasSprite sprite, int color, int tint, float x1, float y1, float x2, float y2, float z, float u1, float v1, float u2, float v2) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        builder.setQuadTint(tint);
        builder.setQuadOrientation(side);
        builder.setTexture(sprite);
        if (side == EnumFacing.SOUTH) {
            ItemTextureQuadConverter.putVertex(builder, format, transform, side, x1, y1, z, u1, v2, color);
            ItemTextureQuadConverter.putVertex(builder, format, transform, side, x2, y1, z, u2, v2, color);
            ItemTextureQuadConverter.putVertex(builder, format, transform, side, x2, y2, z, u2, v1, color);
            ItemTextureQuadConverter.putVertex(builder, format, transform, side, x1, y2, z, u1, v1, color);
        } else {
            ItemTextureQuadConverter.putVertex(builder, format, transform, side, x1, y1, z, u1, v2, color);
            ItemTextureQuadConverter.putVertex(builder, format, transform, side, x1, y2, z, u1, v1, color);
            ItemTextureQuadConverter.putVertex(builder, format, transform, side, x2, y2, z, u2, v1, color);
            ItemTextureQuadConverter.putVertex(builder, format, transform, side, x2, y1, z, u2, v2, color);
        }
        return builder.build();
    }

    private static void putVertex(UnpackedBakedQuad.Builder builder, VertexFormat format, TRSRTransformation transform, EnumFacing side, float x, float y, float z, float u, float v, int color) {
        Vector4f vec = new Vector4f();
        block6: for (int e = 0; e < format.func_177345_h(); ++e) {
            switch (format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    if (transform.isIdentity()) {
                        builder.put(e, x, y, z, 1.0f);
                        continue block6;
                    }
                    vec.x = x;
                    vec.y = y;
                    vec.z = z;
                    vec.w = 1.0f;
                    transform.getMatrixVec().transform((Tuple4f)vec);
                    builder.put(e, vec.x, vec.y, vec.z, vec.w);
                    continue block6;
                }
                case COLOR: {
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color >> 0 & 0xFF) / 255.0f;
                    float a = (float)(color >> 24 & 0xFF) / 255.0f;
                    builder.put(e, r, g, b, a);
                    continue block6;
                }
                case UV: {
                    if (format.func_177348_c(e).func_177369_e() == 0) {
                        builder.put(e, u, v, 0.0f, 1.0f);
                        continue block6;
                    }
                }
                case NORMAL: {
                    builder.put(e, side.func_82601_c(), side.func_96559_d(), side.func_82599_e(), 0.0f);
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }
}

