/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BiomeDictionary {
    private static final boolean DEBUG = false;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<ResourceLocation, BiomeInfo> biomeInfoMap = new HashMap<ResourceLocation, BiomeInfo>();

    public static void addTypes(Biome biome, Type ... types) {
        Preconditions.checkArgument((boolean)ForgeRegistries.BIOMES.containsValue(biome), (String)"Cannot add types to unregistered biome %s", (Object)biome);
        Collection<Type> supertypes = BiomeDictionary.listSupertypes(types);
        Collections.addAll(supertypes, types);
        for (Type type : supertypes) {
            type.biomes.add(biome);
        }
        BiomeInfo biomeInfo = BiomeDictionary.getBiomeInfo(biome);
        Collections.addAll(biomeInfo.types, types);
        biomeInfo.types.addAll(supertypes);
    }

    @Nonnull
    public static Set<Biome> getBiomes(Type type) {
        return type.biomesUn;
    }

    @Nonnull
    public static Set<Type> getTypes(Biome biome) {
        BiomeDictionary.ensureHasTypes(biome);
        return BiomeDictionary.getBiomeInfo(biome).typesUn;
    }

    public static boolean areSimilar(Biome biomeA, Biome biomeB) {
        for (Type type : BiomeDictionary.getTypes(biomeA)) {
            if (!BiomeDictionary.getTypes(biomeB).contains(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasType(Biome biome, Type type) {
        return BiomeDictionary.getTypes(biome).contains(type);
    }

    public static boolean hasAnyType(Biome biome) {
        return !BiomeDictionary.getBiomeInfo(biome).types.isEmpty();
    }

    public static void makeBestGuess(Biome biome) {
        Type type = Type.fromVanilla(biome.func_201856_r());
        if (type != null) {
            BiomeDictionary.addTypes(biome, type);
        }
        if (biome.func_76727_i() > 0.85f) {
            BiomeDictionary.addTypes(biome, Type.WET);
        }
        if (biome.func_76727_i() < 0.15f) {
            BiomeDictionary.addTypes(biome, Type.DRY);
        }
        if (biome.func_185353_n() > 0.85f) {
            BiomeDictionary.addTypes(biome, Type.HOT);
        }
        if (biome.func_185353_n() < 0.15f) {
            BiomeDictionary.addTypes(biome, Type.COLD);
        }
        if (biome.func_76736_e() && biome.func_185355_j() < 0.0f && biome.func_185360_m() <= 0.3f && biome.func_185360_m() >= 0.0f) {
            BiomeDictionary.addTypes(biome, Type.SWAMP);
        }
        if (biome.func_185355_j() <= -0.5f) {
            if (biome.func_185360_m() == 0.0f) {
                BiomeDictionary.addTypes(biome, Type.RIVER);
            } else {
                BiomeDictionary.addTypes(biome, Type.OCEAN);
            }
        }
        if (biome.func_185360_m() >= 0.4f && biome.func_185360_m() < 1.5f) {
            BiomeDictionary.addTypes(biome, Type.HILLS);
        }
        if (biome.func_185360_m() >= 1.5f) {
            BiomeDictionary.addTypes(biome, Type.MOUNTAIN);
        }
    }

    private static BiomeInfo getBiomeInfo(Biome biome) {
        return biomeInfoMap.computeIfAbsent(biome.getRegistryName(), k -> new BiomeInfo());
    }

    static void ensureHasTypes(Biome biome) {
        if (!BiomeDictionary.hasAnyType(biome)) {
            BiomeDictionary.makeBestGuess(biome);
            LOGGER.warn("No types have been added to Biome {}, types have been assigned on a best-effort guess: {}", (Object)biome.getRegistryName(), BiomeDictionary.getTypes(biome));
        }
    }

    private static Collection<Type> listSupertypes(Type ... types) {
        HashSet<Type> supertypes = new HashSet<Type>();
        ArrayDeque<Type> next = new ArrayDeque<Type>();
        Collections.addAll(next, types);
        while (!next.isEmpty()) {
            Type type = (Type)next.remove();
            for (Type sType : Type.byName.values()) {
                if (!sType.subTypes.contains(type) || !supertypes.add(sType)) continue;
                next.add(sType);
            }
        }
        return supertypes;
    }

    private static void registerVanillaBiomes() {
        BiomeDictionary.addTypes(Biomes.field_76771_b, Type.OCEAN);
        BiomeDictionary.addTypes(Biomes.field_76772_c, Type.PLAINS);
        BiomeDictionary.addTypes(Biomes.field_76769_d, Type.HOT, Type.DRY, Type.SANDY);
        BiomeDictionary.addTypes(Biomes.field_76770_e, Type.MOUNTAIN, Type.HILLS);
        BiomeDictionary.addTypes(Biomes.field_76767_f, Type.FOREST);
        BiomeDictionary.addTypes(Biomes.field_76768_g, Type.COLD, Type.CONIFEROUS, Type.FOREST);
        BiomeDictionary.addTypes(Biomes.field_76780_h, Type.WET, Type.SWAMP);
        BiomeDictionary.addTypes(Biomes.field_76781_i, Type.RIVER);
        BiomeDictionary.addTypes(Biomes.field_76778_j, Type.HOT, Type.DRY, Type.NETHER);
        BiomeDictionary.addTypes(Biomes.field_76779_k, Type.COLD, Type.DRY, Type.END);
        BiomeDictionary.addTypes(Biomes.field_76776_l, Type.COLD, Type.OCEAN, Type.SNOWY);
        BiomeDictionary.addTypes(Biomes.field_76777_m, Type.COLD, Type.RIVER, Type.SNOWY);
        BiomeDictionary.addTypes(Biomes.field_76774_n, Type.COLD, Type.SNOWY, Type.WASTELAND);
        BiomeDictionary.addTypes(Biomes.field_76775_o, Type.COLD, Type.SNOWY, Type.MOUNTAIN);
        BiomeDictionary.addTypes(Biomes.field_76789_p, Type.MUSHROOM, Type.RARE);
        BiomeDictionary.addTypes(Biomes.field_76788_q, Type.MUSHROOM, Type.BEACH, Type.RARE);
        BiomeDictionary.addTypes(Biomes.field_76787_r, Type.BEACH);
        BiomeDictionary.addTypes(Biomes.field_76786_s, Type.HOT, Type.DRY, Type.SANDY, Type.HILLS);
        BiomeDictionary.addTypes(Biomes.field_76785_t, Type.FOREST, Type.HILLS);
        BiomeDictionary.addTypes(Biomes.field_76784_u, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.HILLS);
        BiomeDictionary.addTypes(Biomes.field_76783_v, Type.MOUNTAIN);
        BiomeDictionary.addTypes(Biomes.field_76782_w, Type.HOT, Type.WET, Type.DENSE, Type.JUNGLE);
        BiomeDictionary.addTypes(Biomes.field_76792_x, Type.HOT, Type.WET, Type.DENSE, Type.JUNGLE, Type.HILLS);
        BiomeDictionary.addTypes(Biomes.field_150574_L, Type.HOT, Type.WET, Type.JUNGLE, Type.FOREST, Type.RARE);
        BiomeDictionary.addTypes(Biomes.field_150575_M, Type.OCEAN);
        BiomeDictionary.addTypes(Biomes.field_150576_N, Type.BEACH);
        BiomeDictionary.addTypes(Biomes.field_150577_O, Type.COLD, Type.BEACH, Type.SNOWY);
        BiomeDictionary.addTypes(Biomes.field_150583_P, Type.FOREST);
        BiomeDictionary.addTypes(Biomes.field_150582_Q, Type.FOREST, Type.HILLS);
        BiomeDictionary.addTypes(Biomes.field_150585_R, Type.SPOOKY, Type.DENSE, Type.FOREST);
        BiomeDictionary.addTypes(Biomes.field_150584_S, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.SNOWY);
        BiomeDictionary.addTypes(Biomes.field_150579_T, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.SNOWY, Type.HILLS);
        BiomeDictionary.addTypes(Biomes.field_150578_U, Type.COLD, Type.CONIFEROUS, Type.FOREST);
        BiomeDictionary.addTypes(Biomes.field_150581_V, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.HILLS);
        BiomeDictionary.addTypes(Biomes.field_150580_W, Type.MOUNTAIN, Type.FOREST, Type.SPARSE);
        BiomeDictionary.addTypes(Biomes.field_150588_X, Type.HOT, Type.SAVANNA, Type.PLAINS, Type.SPARSE);
        BiomeDictionary.addTypes(Biomes.field_150587_Y, Type.HOT, Type.SAVANNA, Type.PLAINS, Type.SPARSE, Type.RARE);
        BiomeDictionary.addTypes(Biomes.field_150589_Z, Type.MESA, Type.SANDY, Type.DRY);
        BiomeDictionary.addTypes(Biomes.field_150607_aa, Type.MESA, Type.SANDY, Type.DRY, Type.SPARSE);
        BiomeDictionary.addTypes(Biomes.field_150608_ab, Type.MESA, Type.SANDY, Type.DRY);
        BiomeDictionary.addTypes(Biomes.field_201936_P, Type.END);
        BiomeDictionary.addTypes(Biomes.field_201937_Q, Type.END);
        BiomeDictionary.addTypes(Biomes.field_201938_R, Type.END);
        BiomeDictionary.addTypes(Biomes.field_201939_S, Type.END);
        BiomeDictionary.addTypes(Biomes.field_203614_T, Type.OCEAN, Type.HOT);
        BiomeDictionary.addTypes(Biomes.field_203615_U, Type.OCEAN);
        BiomeDictionary.addTypes(Biomes.field_203616_V, Type.OCEAN, Type.COLD);
        BiomeDictionary.addTypes(Biomes.field_203617_W, Type.OCEAN, Type.HOT);
        BiomeDictionary.addTypes(Biomes.field_203618_X, Type.OCEAN);
        BiomeDictionary.addTypes(Biomes.field_203619_Y, Type.OCEAN, Type.COLD);
        BiomeDictionary.addTypes(Biomes.field_203620_Z, Type.OCEAN, Type.COLD);
        BiomeDictionary.addTypes(Biomes.field_185440_P, Type.VOID);
        BiomeDictionary.addTypes(Biomes.field_185441_Q, Type.PLAINS, Type.RARE);
        BiomeDictionary.addTypes(Biomes.field_185442_R, Type.HOT, Type.DRY, Type.SANDY, Type.RARE);
        BiomeDictionary.addTypes(Biomes.field_185443_S, Type.MOUNTAIN, Type.SPARSE, Type.RARE);
        BiomeDictionary.addTypes(Biomes.field_185444_T, Type.FOREST, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(Biomes.field_150590_f, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(Biomes.field_150599_m, Type.WET, Type.SWAMP, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(Biomes.field_185445_W, Type.COLD, Type.SNOWY, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(Biomes.field_185446_X, Type.HOT, Type.WET, Type.DENSE, Type.JUNGLE, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(Biomes.field_185447_Y, Type.HOT, Type.SPARSE, Type.JUNGLE, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(Biomes.field_185448_Z, Type.FOREST, Type.DENSE, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(Biomes.field_185429_aa, Type.FOREST, Type.DENSE, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(Biomes.field_185430_ab, Type.SPOOKY, Type.DENSE, Type.FOREST, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(Biomes.field_185431_ac, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.SNOWY, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(Biomes.field_185432_ad, Type.DENSE, Type.FOREST, Type.RARE);
        BiomeDictionary.addTypes(Biomes.field_185433_ae, Type.DENSE, Type.FOREST, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(Biomes.field_185434_af, Type.MOUNTAIN, Type.SPARSE, Type.RARE);
        BiomeDictionary.addTypes(Biomes.field_185435_ag, Type.HOT, Type.DRY, Type.SPARSE, Type.SAVANNA, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(Biomes.field_185436_ah, Type.HOT, Type.DRY, Type.SPARSE, Type.SAVANNA, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(Biomes.field_185437_ai, Type.HOT, Type.DRY, Type.SPARSE, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(Biomes.field_185438_aj, Type.HOT, Type.DRY, Type.SPARSE, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(Biomes.field_185439_ak, Type.HOT, Type.DRY, Type.SPARSE, Type.MOUNTAIN, Type.RARE);
    }

    private static /* synthetic */ void lambda$registerVanillaBiomes$2(StringBuilder buf, String name, Type type) {
        buf.append("    ").append(type.name).append(": ").append(type.biomes.stream().map(b -> b.getRegistryName().toString()).collect(Collectors.joining(", "))).append('\n');
    }

    static {
        BiomeDictionary.registerVanillaBiomes();
    }

    private static class BiomeInfo {
        private final Set<Type> types = new HashSet<Type>();
        private final Set<Type> typesUn = Collections.unmodifiableSet(this.types);

        private BiomeInfo() {
        }
    }

    public static final class Type {
        private static final Map<String, Type> byName = new HashMap<String, Type>();
        private static Collection<Type> allTypes = Collections.unmodifiableCollection(byName.values());
        public static final Type HOT = new Type("HOT", new Type[0]);
        public static final Type COLD = new Type("COLD", new Type[0]);
        public static final Type SPARSE = new Type("SPARSE", new Type[0]);
        public static final Type DENSE = new Type("DENSE", new Type[0]);
        public static final Type WET = new Type("WET", new Type[0]);
        public static final Type DRY = new Type("DRY", new Type[0]);
        public static final Type SAVANNA = new Type("SAVANNA", new Type[0]);
        public static final Type CONIFEROUS = new Type("CONIFEROUS", new Type[0]);
        public static final Type JUNGLE = new Type("JUNGLE", new Type[0]);
        public static final Type SPOOKY = new Type("SPOOKY", new Type[0]);
        public static final Type DEAD = new Type("DEAD", new Type[0]);
        public static final Type LUSH = new Type("LUSH", new Type[0]);
        public static final Type NETHER = new Type("NETHER", new Type[0]);
        public static final Type END = new Type("END", new Type[0]);
        public static final Type MUSHROOM = new Type("MUSHROOM", new Type[0]);
        public static final Type MAGICAL = new Type("MAGICAL", new Type[0]);
        public static final Type RARE = new Type("RARE", new Type[0]);
        public static final Type OCEAN = new Type("OCEAN", new Type[0]);
        public static final Type RIVER = new Type("RIVER", new Type[0]);
        public static final Type WATER = new Type("WATER", OCEAN, RIVER);
        public static final Type MESA = new Type("MESA", new Type[0]);
        public static final Type FOREST = new Type("FOREST", new Type[0]);
        public static final Type PLAINS = new Type("PLAINS", new Type[0]);
        public static final Type MOUNTAIN = new Type("MOUNTAIN", new Type[0]);
        public static final Type HILLS = new Type("HILLS", new Type[0]);
        public static final Type SWAMP = new Type("SWAMP", new Type[0]);
        public static final Type SANDY = new Type("SANDY", new Type[0]);
        public static final Type SNOWY = new Type("SNOWY", new Type[0]);
        public static final Type WASTELAND = new Type("WASTELAND", new Type[0]);
        public static final Type BEACH = new Type("BEACH", new Type[0]);
        public static final Type VOID = new Type("VOID", new Type[0]);
        private final String name;
        private final List<Type> subTypes;
        private final Set<Biome> biomes = new HashSet<Biome>();
        private final Set<Biome> biomesUn = Collections.unmodifiableSet(this.biomes);

        private Type(String name, Type ... subTypes) {
            this.name = name;
            this.subTypes = ImmutableList.copyOf((Object[])subTypes);
            byName.put(name, this);
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static Type getType(String name, Type ... subTypes) {
            Type t = byName.get(name = name.toUpperCase());
            if (t == null) {
                t = new Type(name, subTypes);
            }
            return t;
        }

        public static Collection<Type> getAll() {
            return allTypes;
        }

        @Nullable
        public static Type fromVanilla(Biome.Category category) {
            if (category == Biome.Category.NONE) {
                return null;
            }
            if (category == Biome.Category.THEEND) {
                return VOID;
            }
            return Type.getType(category.name(), new Type[0]);
        }
    }
}

