/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.init.Biomes;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;

public class BiomeManager {
    private static TrackedList<BiomeEntry>[] biomes = BiomeManager.setupBiomes();
    public static List<Biome> oceanBiomes = new ArrayList<Biome>();

    private static TrackedList<BiomeEntry>[] setupBiomes() {
        TrackedList[] currentBiomes = new TrackedList[BiomeType.values().length];
        ArrayList<BiomeEntry> list = new ArrayList<BiomeEntry>();
        list.add(new BiomeEntry(Biomes.field_76767_f, 10));
        list.add(new BiomeEntry(Biomes.field_150585_R, 10));
        list.add(new BiomeEntry(Biomes.field_76770_e, 10));
        list.add(new BiomeEntry(Biomes.field_76772_c, 10));
        list.add(new BiomeEntry(Biomes.field_150583_P, 10));
        list.add(new BiomeEntry(Biomes.field_76780_h, 10));
        currentBiomes[BiomeType.WARM.ordinal()] = new TrackedList(list);
        list.clear();
        list.add(new BiomeEntry(Biomes.field_76767_f, 10));
        list.add(new BiomeEntry(Biomes.field_76770_e, 10));
        list.add(new BiomeEntry(Biomes.field_76768_g, 10));
        list.add(new BiomeEntry(Biomes.field_76772_c, 10));
        currentBiomes[BiomeType.COOL.ordinal()] = new TrackedList(list);
        list.clear();
        list.add(new BiomeEntry(Biomes.field_76774_n, 30));
        list.add(new BiomeEntry(Biomes.field_150584_S, 10));
        currentBiomes[BiomeType.ICY.ordinal()] = new TrackedList(list);
        list.clear();
        currentBiomes[BiomeType.DESERT.ordinal()] = new TrackedList(list);
        return currentBiomes;
    }

    public static void addSpawnBiome(Biome biome) {
        if (!BiomeProvider.field_201540_a.contains(biome)) {
            BiomeProvider.field_201540_a.add(biome);
        }
    }

    public static void removeSpawnBiome(Biome biome) {
        if (BiomeProvider.field_201540_a.contains(biome)) {
            BiomeProvider.field_201540_a.remove(biome);
        }
    }

    public static void addBiome(BiomeType type, BiomeEntry entry) {
        TrackedList<BiomeEntry> list;
        int idx = type.ordinal();
        TrackedList<BiomeEntry> trackedList = list = idx > biomes.length ? null : biomes[idx];
        if (list != null) {
            list.add(entry);
        }
    }

    public static void removeBiome(BiomeType type, BiomeEntry entry) {
        TrackedList<BiomeEntry> list;
        int idx = type.ordinal();
        TrackedList<BiomeEntry> trackedList = list = idx > biomes.length ? null : biomes[idx];
        if (list != null && list.contains((Object)entry)) {
            list.remove((Object)entry);
        }
    }

    @Nullable
    public static ImmutableList<BiomeEntry> getBiomes(BiomeType type) {
        int idx = type.ordinal();
        TrackedList<BiomeEntry> list = idx >= biomes.length ? null : biomes[idx];
        return list != null ? ImmutableList.copyOf(list) : null;
    }

    public static boolean isTypeListModded(BiomeType type) {
        TrackedList<BiomeEntry> list;
        int idx = type.ordinal();
        TrackedList<BiomeEntry> trackedList = list = idx > biomes.length ? null : biomes[idx];
        if (list != null) {
            return list.isModded();
        }
        return false;
    }

    static {
        oceanBiomes.add(Biomes.field_76771_b);
        oceanBiomes.add(Biomes.field_150575_M);
        oceanBiomes.add(Biomes.field_76776_l);
    }

    private static class TrackedList<E>
    extends ArrayList<E> {
        private static final long serialVersionUID = 1L;
        private boolean isModded = false;

        public TrackedList(Collection<? extends E> c) {
            super(c);
        }

        @Override
        public E set(int index, E element) {
            this.isModded = true;
            return super.set(index, element);
        }

        @Override
        public boolean add(E e) {
            this.isModded = true;
            return super.add(e);
        }

        @Override
        public void add(int index, E element) {
            this.isModded = true;
            super.add(index, element);
        }

        @Override
        public E remove(int index) {
            this.isModded = true;
            return super.remove(index);
        }

        @Override
        public boolean remove(Object o) {
            this.isModded = true;
            return super.remove(o);
        }

        @Override
        public void clear() {
            this.isModded = true;
            super.clear();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            this.isModded = true;
            return super.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            this.isModded = true;
            return super.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            this.isModded = true;
            return super.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            this.isModded = true;
            return super.retainAll(c);
        }

        public boolean isModded() {
            return this.isModded;
        }
    }

    public static class BiomeEntry
    extends WeightedRandom.Item {
        public final Biome biome;

        public BiomeEntry(Biome biome, int weight) {
            super(weight);
            this.biome = biome;
        }
    }

    public static enum BiomeType {
        DESERT,
        WARM,
        COOL,
        ICY;


        public static BiomeType create(String name) {
            return null;
        }
    }
}

