/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecartContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Fluids;
import net.minecraft.inventory.ContainerRepair;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemSpawnEgg;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTippedArrow;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.DifficultyChangeEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.util.TriConsumer;

public class ForgeHooks {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker FORGEHOOKS = MarkerManager.getMarker((String)"FORGEHOOKS");
    static final List<SeedEntry> seedList = new ArrayList<SeedEntry>();
    private static boolean toolInit = false;
    static final Pattern URL_PATTERN = Pattern.compile("((?:[a-z0-9]{2,}:\\/\\/)?(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}|(?:[-\\w_]{1,}\\.[a-z]{2,}?))(?::[0-9]{1,5})?.*?(?=[!\"\u00a7 \n]|$))", 2);
    private static ThreadLocal<EntityPlayer> craftingPlayer = new ThreadLocal();
    private static ThreadLocal<Deque<LootTableContext>> lootContext = new ThreadLocal();
    private static TriConsumer<Block, ToolType, Integer> blockToolSetter;
    private static final DummyBlockReader DUMMY_WORLD;

    @Nonnull
    public static ItemStack getGrassSeed(Random rand, int fortune) {
        if (seedList.size() == 0) {
            return ItemStack.field_190927_a;
        }
        SeedEntry entry = (SeedEntry)WeightedRandom.func_76271_a((Random)rand, seedList);
        if (entry == null || entry.seed.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        return entry.getStack(rand, fortune);
    }

    public static boolean canContinueUsing(@Nonnull ItemStack from, @Nonnull ItemStack to) {
        if (!from.func_190926_b() && !to.func_190926_b()) {
            return from.func_77973_b().canContinueUsing(from, to);
        }
        return false;
    }

    public static boolean canHarvestBlock(@Nonnull IBlockState state, @Nonnull EntityPlayer player, @Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        if (state.func_185904_a().func_76229_l()) {
            return true;
        }
        ItemStack stack = player.func_184614_ca();
        ToolType tool = state.getHarvestTool();
        if (stack.func_190926_b() || tool == null) {
            return player.func_184823_b(state);
        }
        int toolLevel = stack.func_77973_b().getHarvestLevel(stack, tool, player, state);
        if (toolLevel < 0) {
            return player.func_184823_b(state);
        }
        return toolLevel >= state.getHarvestLevel();
    }

    public static boolean canToolHarvestBlock(IWorldReader world, BlockPos pos, @Nonnull ItemStack stack) {
        IBlockState state = world.func_180495_p(pos);
        ToolType tool = state.getHarvestTool();
        if (stack.func_190926_b() || tool == null) {
            return false;
        }
        return stack.getHarvestLevel(tool, null, null) >= state.getHarvestLevel();
    }

    public static boolean isToolEffective(IWorldReader world, BlockPos pos, @Nonnull ItemStack stack) {
        IBlockState state = world.func_180495_p(pos);
        for (ToolType type : stack.getToolTypes()) {
            if (!state.isToolEffective(type)) continue;
            return true;
        }
        return false;
    }

    static void initTools() {
        if (toolInit) {
            return;
        }
        toolInit = true;
        Set blocks = (Set)ForgeHooks.getPrivateValue(ItemPickaxe.class, null, 0);
        blocks.forEach(block -> blockToolSetter.accept(block, (Object)ToolType.PICKAXE, (Object)0));
        blocks = (Set)ForgeHooks.getPrivateValue(ItemSpade.class, null, 0);
        blocks.forEach(block -> blockToolSetter.accept(block, (Object)ToolType.SHOVEL, (Object)0));
        blocks = (Set)ForgeHooks.getPrivateValue(ItemAxe.class, null, 0);
        blocks.forEach(block -> blockToolSetter.accept(block, (Object)ToolType.AXE, (Object)0));
        blockToolSetter.accept((Object)Blocks.field_150343_Z, (Object)ToolType.PICKAXE, (Object)3);
        for (Block block2 : new Block[]{Blocks.field_150484_ah, Blocks.field_150482_ag, Blocks.field_150412_bA, Blocks.field_150475_bE, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_150450_ax}) {
            blockToolSetter.accept((Object)block2, (Object)ToolType.PICKAXE, (Object)2);
        }
        for (Block block2 : new Block[]{Blocks.field_150339_S, Blocks.field_150366_p, Blocks.field_150368_y, Blocks.field_150369_x}) {
            blockToolSetter.accept((Object)block2, (Object)ToolType.PICKAXE, (Object)1);
        }
    }

    public static boolean onPickBlock(RayTraceResult target, EntityPlayer player, World world) {
        ItemStack result;
        boolean isCreative = player.field_71075_bZ.field_75098_d;
        TileEntity te = null;
        if (target.field_72313_a == RayTraceResult.Type.BLOCK) {
            IBlockState state = world.func_180495_p(target.func_178782_a());
            if (state.isAir((IBlockReader)world, target.func_178782_a())) {
                return false;
            }
            if (isCreative && GuiScreen.func_146271_m() && state.hasTileEntity()) {
                te = world.func_175625_s(target.func_178782_a());
            }
            result = state.func_177230_c().getPickBlock(state, target, (IBlockReader)world, target.func_178782_a(), player);
        } else {
            if (target.field_72313_a != RayTraceResult.Type.ENTITY || target.field_72308_g == null || !isCreative) {
                return false;
            }
            result = target.field_72308_g.getPickedResult(target);
        }
        if (result.func_190926_b()) {
            return false;
        }
        if (te != null) {
            Minecraft.func_71410_x().func_184119_a(result, te);
        }
        if (isCreative) {
            player.field_71071_by.func_184434_a(result);
            Minecraft.func_71410_x().field_71442_b.func_78761_a(player.func_184586_b(EnumHand.MAIN_HAND), 36 + player.field_71071_by.field_70461_c);
            return true;
        }
        int slot = player.field_71071_by.func_184429_b(result);
        if (slot != -1) {
            if (InventoryPlayer.func_184435_e((int)slot)) {
                player.field_71071_by.field_70461_c = slot;
            } else {
                Minecraft.func_71410_x().field_71442_b.func_187100_a(slot);
            }
            return true;
        }
        return false;
    }

    public static void onDifficultyChange(EnumDifficulty difficulty, EnumDifficulty oldDifficulty) {
        MinecraftForge.EVENT_BUS.post((Event)new DifficultyChangeEvent(difficulty, oldDifficulty));
    }

    public static void onLivingSetAttackTarget(EntityLivingBase entity, EntityLivingBase target) {
        MinecraftForge.EVENT_BUS.post((Event)new LivingSetAttackTargetEvent(entity, target));
    }

    public static boolean onLivingUpdate(EntityLivingBase entity) {
        return MinecraftForge.EVENT_BUS.post((Event)new LivingEvent.LivingUpdateEvent(entity));
    }

    public static boolean onLivingAttack(EntityLivingBase entity, DamageSource src, float amount) {
        return entity instanceof EntityPlayer || !MinecraftForge.EVENT_BUS.post((Event)new LivingAttackEvent(entity, src, amount));
    }

    public static boolean onPlayerAttack(EntityLivingBase entity, DamageSource src, float amount) {
        return !MinecraftForge.EVENT_BUS.post((Event)new LivingAttackEvent(entity, src, amount));
    }

    public static LivingKnockBackEvent onLivingKnockBack(EntityLivingBase target, Entity attacker, float strength, double ratioX, double ratioZ) {
        LivingKnockBackEvent event = new LivingKnockBackEvent(target, attacker, strength, ratioX, ratioZ);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static float onLivingHurt(EntityLivingBase entity, DamageSource src, float amount) {
        LivingHurtEvent event = new LivingHurtEvent(entity, src, amount);
        return MinecraftForge.EVENT_BUS.post((Event)event) ? 0.0f : event.getAmount();
    }

    public static float onLivingDamage(EntityLivingBase entity, DamageSource src, float amount) {
        LivingDamageEvent event = new LivingDamageEvent(entity, src, amount);
        return MinecraftForge.EVENT_BUS.post((Event)event) ? 0.0f : event.getAmount();
    }

    public static boolean onLivingDeath(EntityLivingBase entity, DamageSource src) {
        return MinecraftForge.EVENT_BUS.post((Event)new LivingDeathEvent(entity, src));
    }

    public static boolean onLivingDrops(EntityLivingBase entity, DamageSource source, Collection<EntityItem> drops, int lootingLevel, boolean recentlyHit) {
        return MinecraftForge.EVENT_BUS.post((Event)new LivingDropsEvent(entity, source, drops, lootingLevel, recentlyHit));
    }

    @Nullable
    public static float[] onLivingFall(EntityLivingBase entity, float distance, float damageMultiplier) {
        float[] fArray;
        LivingFallEvent event = new LivingFallEvent(entity, distance, damageMultiplier);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            fArray = null;
        } else {
            float[] fArray2 = new float[2];
            fArray2[0] = event.getDistance();
            fArray = fArray2;
            fArray2[1] = event.getDamageMultiplier();
        }
        return fArray;
    }

    public static int getLootingLevel(Entity target, @Nullable Entity killer, DamageSource cause) {
        int looting = 0;
        if (killer instanceof EntityLivingBase) {
            looting = EnchantmentHelper.func_185283_h((EntityLivingBase)((EntityLivingBase)killer));
        }
        if (target instanceof EntityLivingBase) {
            looting = ForgeHooks.getLootingLevel((EntityLivingBase)target, cause, looting);
        }
        return looting;
    }

    public static int getLootingLevel(EntityLivingBase target, DamageSource cause, int level) {
        LootingLevelEvent event = new LootingLevelEvent(target, cause, level);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getLootingLevel();
    }

    public static double getPlayerVisibilityDistance(EntityPlayer player, double xzDistance, double maxXZDistance) {
        PlayerEvent.Visibility event = new PlayerEvent.Visibility(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        double value = event.getVisibilityModifier() * xzDistance;
        return value >= maxXZDistance ? maxXZDistance : value;
    }

    public static boolean isLivingOnLadder(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityLivingBase entity) {
        boolean isSpectator;
        boolean bl = isSpectator = entity instanceof EntityPlayer && ((EntityPlayer)entity).func_175149_v();
        if (isSpectator) {
            return false;
        }
        if (!((Boolean)ForgeConfig.SERVER.fullBoundingBoxLadders.get()).booleanValue()) {
            return state.func_177230_c().isLadder(state, (IWorldReader)world, pos, entity);
        }
        AxisAlignedBB bb = entity.func_174813_aQ();
        int mX = MathHelper.func_76128_c((double)bb.field_72340_a);
        int mY = MathHelper.func_76128_c((double)bb.field_72338_b);
        int mZ = MathHelper.func_76128_c((double)bb.field_72339_c);
        int y2 = mY;
        while ((double)y2 < bb.field_72337_e) {
            int x2 = mX;
            while ((double)x2 < bb.field_72336_d) {
                int z2 = mZ;
                while ((double)z2 < bb.field_72334_f) {
                    BlockPos tmp = new BlockPos(x2, y2, z2);
                    state = world.func_180495_p(tmp);
                    if (state.func_177230_c().isLadder(state, (IWorldReader)world, tmp, entity)) {
                        return true;
                    }
                    ++z2;
                }
                ++x2;
            }
            ++y2;
        }
        return false;
    }

    public static void onLivingJump(EntityLivingBase entity) {
        MinecraftForge.EVENT_BUS.post((Event)new LivingEvent.LivingJumpEvent(entity));
    }

    @Nullable
    public static EntityItem onPlayerTossEvent(@Nonnull EntityPlayer player, @Nonnull ItemStack item, boolean includeName) {
        player.captureDrops((Collection)Lists.newArrayList());
        EntityItem ret = player.func_146097_a(item, false, includeName);
        player.captureDrops(null);
        if (ret == null) {
            return null;
        }
        ItemTossEvent event = new ItemTossEvent(ret, player);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return null;
        }
        if (!player.field_70170_p.field_72995_K) {
            player.func_130014_f_().func_72838_d((Entity)event.getEntityItem());
        }
        return event.getEntityItem();
    }

    @Nullable
    public static ITextComponent onServerChatEvent(NetHandlerPlayServer net, String raw, ITextComponent comp) {
        ServerChatEvent event = new ServerChatEvent(net.field_147369_b, raw, comp);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return null;
        }
        return event.getComponent();
    }

    public static ITextComponent newChatWithLinks(String string) {
        return ForgeHooks.newChatWithLinks(string, true);
    }

    public static ITextComponent newChatWithLinks(String string, boolean allowMissingHeader) {
        TextComponentString ichat = null;
        Matcher matcher = URL_PATTERN.matcher(string);
        int lastEnd = 0;
        while (matcher.find()) {
            TextComponentString link;
            String url;
            block13: {
                int start = matcher.start();
                int end = matcher.end();
                String part = string.substring(lastEnd, start);
                if (part.length() > 0) {
                    if (ichat == null) {
                        ichat = new TextComponentString(part);
                    } else {
                        ichat.func_150258_a(part);
                    }
                }
                lastEnd = end;
                url = string.substring(start, end);
                link = new TextComponentString(url);
                try {
                    if (new URI(url).getScheme() != null) break block13;
                    if (!allowMissingHeader) {
                        if (ichat == null) {
                            ichat = new TextComponentString(url);
                            continue;
                        }
                        ichat.func_150258_a(url);
                        continue;
                    }
                    url = "http://" + url;
                }
                catch (URISyntaxException e) {
                    if (ichat == null) {
                        ichat = new TextComponentString(url);
                        continue;
                    }
                    ichat.func_150258_a(url);
                    continue;
                }
            }
            ClickEvent click = new ClickEvent(ClickEvent.Action.OPEN_URL, url);
            link.func_150256_b().func_150241_a(click);
            link.func_150256_b().func_150228_d(Boolean.valueOf(true));
            link.func_150256_b().func_150238_a(TextFormatting.BLUE);
            if (ichat == null) {
                ichat = link;
                continue;
            }
            ichat.func_150257_a((ITextComponent)link);
        }
        String end = string.substring(lastEnd);
        if (ichat == null) {
            ichat = new TextComponentString(end);
        } else if (end.length() > 0) {
            ichat.func_150258_a(string.substring(lastEnd));
        }
        return ichat;
    }

    public static int onBlockBreakEvent(World world, GameType gameType, EntityPlayerMP entityPlayer, BlockPos pos) {
        boolean preCancelEvent = false;
        ItemStack itemstack = entityPlayer.func_184614_ca();
        if (gameType.func_77145_d() && !itemstack.func_190926_b() && !itemstack.func_77973_b().func_195938_a(world.func_180495_p(pos), world, pos, (EntityPlayer)entityPlayer)) {
            preCancelEvent = true;
        }
        if (gameType.func_82752_c()) {
            if (gameType == GameType.SPECTATOR) {
                preCancelEvent = true;
            }
            if (!(entityPlayer.func_175142_cm() || !itemstack.func_190926_b() && itemstack.func_206848_a(world.func_205772_D(), new BlockWorldState((IWorldReaderBase)world, pos, false)))) {
                preCancelEvent = true;
            }
        }
        if (world.func_175625_s(pos) == null) {
            entityPlayer.field_71135_a.func_147359_a((Packet)new SPacketBlockChange((IBlockReader)DUMMY_WORLD, pos));
        }
        IBlockState state = world.func_180495_p(pos);
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, (EntityPlayer)entityPlayer);
        event.setCanceled(preCancelEvent);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            SPacketUpdateTileEntity pkt;
            entityPlayer.field_71135_a.func_147359_a((Packet)new SPacketBlockChange((IBlockReader)world, pos));
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity != null && (pkt = tileentity.func_189518_D_()) != null) {
                entityPlayer.field_71135_a.func_147359_a((Packet)pkt);
            }
        }
        return event.isCanceled() ? -1 : event.getExpToDrop();
    }

    public static boolean onAnvilChange(ContainerRepair container, @Nonnull ItemStack left, @Nonnull ItemStack right, IInventory outputSlot, String name, int baseCost) {
        AnvilUpdateEvent e = new AnvilUpdateEvent(left, right, name, baseCost);
        if (MinecraftForge.EVENT_BUS.post((Event)e)) {
            return false;
        }
        if (e.getOutput().func_190926_b()) {
            return true;
        }
        outputSlot.func_70299_a(0, e.getOutput());
        container.field_82854_e = e.getCost();
        container.field_82856_l = e.getMaterialCost();
        return false;
    }

    public static float onAnvilRepair(EntityPlayer player, @Nonnull ItemStack output, @Nonnull ItemStack left, @Nonnull ItemStack right) {
        AnvilRepairEvent e = new AnvilRepairEvent(player, left, right, output);
        MinecraftForge.EVENT_BUS.post((Event)e);
        return e.getBreakChance();
    }

    public static void setCraftingPlayer(EntityPlayer player) {
        craftingPlayer.set(player);
    }

    public static EntityPlayer getCraftingPlayer() {
        return craftingPlayer.get();
    }

    @Nonnull
    public static ItemStack getContainerItem(@Nonnull ItemStack stack) {
        if (stack.func_77973_b().hasContainerItem(stack)) {
            if (!(stack = stack.func_77973_b().getContainerItem(stack)).func_190926_b() && stack.func_77984_f() && stack.func_77952_i() > stack.func_77958_k()) {
                ForgeEventFactory.onPlayerDestroyItem(craftingPlayer.get(), stack, null);
                return ItemStack.field_190927_a;
            }
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean onPlayerAttackTarget(EntityPlayer player, Entity target) {
        if (MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent(player, target))) {
            return false;
        }
        ItemStack stack = player.func_184614_ca();
        return stack.func_190926_b() || !stack.func_77973_b().onLeftClickEntity(stack, player, target);
    }

    public static boolean onTravelToDimension(Entity entity, DimensionType dimension) {
        EntityTravelToDimensionEvent event = new EntityTravelToDimensionEvent(entity, dimension);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled() && entity instanceof EntityMinecartContainer) {
            ((EntityMinecartContainer)entity).field_94112_b = true;
        }
        return !event.isCanceled();
    }

    @Nullable
    public static RayTraceResult rayTraceEyes(EntityLivingBase entity, double length) {
        Vec3d startPos = new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v);
        Vec3d endPos = startPos.func_178787_e(new Vec3d(entity.func_70040_Z().field_72450_a * length, entity.func_70040_Z().field_72448_b * length, entity.func_70040_Z().field_72449_c * length));
        return entity.field_70170_p.func_72933_a(startPos, endPos);
    }

    @Nullable
    public static Vec3d rayTraceEyeHitVec(EntityLivingBase entity, double length) {
        RayTraceResult git = ForgeHooks.rayTraceEyes(entity, length);
        return git == null ? null : git.field_72307_f;
    }

    public static EnumActionResult onInteractEntityAt(EntityPlayer player, Entity entity, RayTraceResult ray, EnumHand hand) {
        Vec3d vec3d = new Vec3d(ray.field_72307_f.field_72450_a - entity.field_70165_t, ray.field_72307_f.field_72448_b - entity.field_70163_u, ray.field_72307_f.field_72449_c - entity.field_70161_v);
        return ForgeHooks.onInteractEntityAt(player, entity, vec3d, hand);
    }

    public static EnumActionResult onInteractEntityAt(EntityPlayer player, Entity entity, Vec3d vec3d, EnumHand hand) {
        PlayerInteractEvent.EntityInteractSpecific evt = new PlayerInteractEvent.EntityInteractSpecific(player, hand, entity, vec3d);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt.isCanceled() ? evt.getCancellationResult() : null;
    }

    public static EnumActionResult onInteractEntity(EntityPlayer player, Entity entity, EnumHand hand) {
        PlayerInteractEvent.EntityInteract evt = new PlayerInteractEvent.EntityInteract(player, hand, entity);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt.isCanceled() ? evt.getCancellationResult() : null;
    }

    public static EnumActionResult onItemRightClick(EntityPlayer player, EnumHand hand) {
        PlayerInteractEvent.RightClickItem evt = new PlayerInteractEvent.RightClickItem(player, hand);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt.isCanceled() ? evt.getCancellationResult() : null;
    }

    public static PlayerInteractEvent.LeftClickBlock onLeftClickBlock(EntityPlayer player, BlockPos pos, EnumFacing face, Vec3d hitVec) {
        PlayerInteractEvent.LeftClickBlock evt = new PlayerInteractEvent.LeftClickBlock(player, pos, face, hitVec);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt;
    }

    public static PlayerInteractEvent.RightClickBlock onRightClickBlock(EntityPlayer player, EnumHand hand, BlockPos pos, EnumFacing face, Vec3d hitVec) {
        PlayerInteractEvent.RightClickBlock evt = new PlayerInteractEvent.RightClickBlock(player, hand, pos, face, hitVec);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt;
    }

    public static void onEmptyClick(EntityPlayer player, EnumHand hand) {
        MinecraftForge.EVENT_BUS.post((Event)new PlayerInteractEvent.RightClickEmpty(player, hand));
    }

    public static void onEmptyLeftClick(EntityPlayer player) {
        MinecraftForge.EVENT_BUS.post((Event)new PlayerInteractEvent.LeftClickEmpty(player));
    }

    private static LootTableContext getLootTableContext() {
        LootTableContext ctx = lootContext.get().peek();
        if (ctx == null) {
            throw new JsonParseException("Invalid call stack, could not grab json context!");
        }
        return ctx;
    }

    @Nullable
    public static LootTable loadLootTable(Gson gson, ResourceLocation name, String data, boolean custom, LootTableManager lootTableManager) {
        ArrayDeque que = lootContext.get();
        if (que == null) {
            que = Queues.newArrayDeque();
            lootContext.set(que);
        }
        LootTable ret = null;
        try {
            que.push(new LootTableContext(name, custom));
            ret = (LootTable)gson.fromJson(data, LootTable.class);
            que.pop();
        }
        catch (JsonParseException e) {
            que.pop();
            throw e;
        }
        if (!custom) {
            ret = ForgeEventFactory.loadLootTable(name, ret, lootTableManager);
        }
        if (ret != null) {
            ret.freeze();
        }
        return ret;
    }

    public static String readPoolName(JsonObject json) {
        LootTableContext ctx = ForgeHooks.getLootTableContext();
        ctx.resetPoolCtx();
        if (json.has("name")) {
            return JsonUtils.func_151200_h((JsonObject)json, (String)"name");
        }
        if (ctx.custom) {
            return "custom#" + json.hashCode();
        }
        ++ctx.poolCount;
        if (!ctx.vanilla) {
            throw new JsonParseException("Loot Table \"" + ctx.name.toString() + "\" Missing `name` entry for pool #" + (ctx.poolCount - 1));
        }
        return ctx.poolCount == 1 ? "main" : "pool" + (ctx.poolCount - 1);
    }

    public static String readLootEntryName(JsonObject json, String type) {
        LootTableContext ctx = ForgeHooks.getLootTableContext();
        ++ctx.entryCount;
        if (json.has("entryName")) {
            return ctx.validateEntryName(JsonUtils.func_151200_h((JsonObject)json, (String)"entryName"));
        }
        if (ctx.custom) {
            return "custom#" + json.hashCode();
        }
        String name = null;
        if ("item".equals(type)) {
            name = JsonUtils.func_151200_h((JsonObject)json, (String)"name");
        } else if ("loot_table".equals(type)) {
            name = JsonUtils.func_151200_h((JsonObject)json, (String)"name");
        } else if ("empty".equals(type)) {
            name = "empty";
        }
        return ctx.validateEntryName(name);
    }

    public static LootEntry deserializeJsonLootEntry(String type, JsonObject json, int weight, int quality, LootCondition[] conditions) {
        return null;
    }

    public static String getLootEntryType(LootEntry entry) {
        return null;
    }

    public static boolean onCropsGrowPre(World worldIn, BlockPos pos, IBlockState state, boolean def) {
        BlockEvent.CropGrowEvent.Pre ev = new BlockEvent.CropGrowEvent.Pre(worldIn, pos, state);
        MinecraftForge.EVENT_BUS.post((Event)ev);
        return ev.getResult() == Event.Result.ALLOW || ev.getResult() == Event.Result.DEFAULT && def;
    }

    public static void onCropsGrowPost(World worldIn, BlockPos pos, IBlockState state) {
        MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.CropGrowEvent.Post(worldIn, pos, state, worldIn.func_180495_p(pos)));
    }

    @Nullable
    public static CriticalHitEvent getCriticalHit(EntityPlayer player, Entity target, boolean vanillaCritical, float damageModifier) {
        CriticalHitEvent hitResult = new CriticalHitEvent(player, target, damageModifier, vanillaCritical);
        MinecraftForge.EVENT_BUS.post((Event)hitResult);
        if (hitResult.getResult() == Event.Result.ALLOW || vanillaCritical && hitResult.getResult() == Event.Result.DEFAULT) {
            return hitResult;
        }
        return null;
    }

    public static void onAdvancement(EntityPlayerMP player, Advancement advancement) {
        MinecraftForge.EVENT_BUS.post((Event)new AdvancementEvent((EntityPlayer)player, advancement));
    }

    @Nullable
    public static String getDefaultCreatorModId(@Nonnull ItemStack itemStack) {
        String modId;
        Item item = itemStack.func_77973_b();
        ResourceLocation registryName = item.getRegistryName();
        String string = modId = registryName == null ? null : registryName.func_110624_b();
        if ("minecraft".equals(modId)) {
            ResourceLocation resourceLocation;
            if (item instanceof ItemEnchantedBook) {
                NBTTagCompound nbttagcompound;
                ResourceLocation resourceLocation2;
                NBTTagList enchantmentsNbt = ItemEnchantedBook.func_92110_g((ItemStack)itemStack);
                if (enchantmentsNbt.size() == 1 && (resourceLocation2 = ResourceLocation.func_208304_a((String)(nbttagcompound = enchantmentsNbt.func_150305_b(0)).func_74779_i("id"))) != null && ForgeRegistries.ENCHANTMENTS.containsKey(resourceLocation2)) {
                    return resourceLocation2.func_110624_b();
                }
            } else if (item instanceof ItemPotion || item instanceof ItemTippedArrow) {
                PotionType potionType = PotionUtils.func_185191_c((ItemStack)itemStack);
                ResourceLocation resourceLocation3 = ForgeRegistries.POTION_TYPES.getKey(potionType);
                if (resourceLocation3 != null) {
                    return resourceLocation3.func_110624_b();
                }
            } else if (item instanceof ItemSpawnEgg && (resourceLocation = ((ItemSpawnEgg)item).func_208076_b(null).getRegistryName()) != null) {
                return resourceLocation.func_110624_b();
            }
        }
        return modId;
    }

    public static boolean onFarmlandTrample(World world, BlockPos pos, IBlockState state, float fallDistance, Entity entity) {
        if (entity.canTrample(state, pos, fallDistance)) {
            BlockEvent.FarmlandTrampleEvent event = new BlockEvent.FarmlandTrampleEvent(world, pos, state, fallDistance, entity);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return !event.isCanceled();
        }
        return false;
    }

    public static void setBlockToolSetter(TriConsumer<Block, ToolType, Integer> setter) {
        blockToolSetter = setter;
    }

    private static <T, E> T getPrivateValue(Class<? super E> classToAccess, @Nullable E instance, int fieldIndex) {
        try {
            Field f = classToAccess.getDeclaredFields()[fieldIndex];
            f.setAccessible(true);
            return (T)f.get(instance);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static int onNoteChange(World world, BlockPos pos, IBlockState state, int old, int _new) {
        NoteBlockEvent.Change event = new NoteBlockEvent.Change(world, pos, state, old, _new);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return -1;
        }
        return event.getVanillaNoteId();
    }

    public static int canEntitySpawn(EntityLiving entity, IWorld world, double x, double y, double z, MobSpawnerBaseLogic spawner) {
        Event.Result res = ForgeEventFactory.canEntitySpawn(entity, world, x, y, z, null);
        return res == Event.Result.DEFAULT ? 0 : (res == Event.Result.DENY ? -1 : 1);
    }

    public static <T> void deserializeTagAdditions(Tag.Builder<T> builder, Predicate<ResourceLocation> isValueKnown, Function<ResourceLocation, T> valueGetter, JsonObject json) {
        ResourceLocation rl;
        String s;
        if (json.has("optional")) {
            for (JsonElement entry : JsonUtils.func_151214_t((JsonObject)json, (String)"optional")) {
                s = JsonUtils.func_151206_a((JsonElement)entry, (String)"value");
                if (!s.startsWith("#")) {
                    rl = new ResourceLocation(s);
                    if (!isValueKnown.test(rl) || valueGetter.apply(rl) == null) continue;
                    builder.func_200048_a(valueGetter.apply(rl));
                    continue;
                }
                builder.func_200575_a(new OptionalTagEntry(new ResourceLocation(s.substring(1))));
            }
        }
        if (json.has("remove")) {
            for (JsonElement entry : JsonUtils.func_151214_t((JsonObject)json, (String)"remove")) {
                s = JsonUtils.func_151206_a((JsonElement)entry, (String)"value");
                if (!s.startsWith("#")) {
                    rl = new ResourceLocation(s);
                    if (!isValueKnown.test(rl) || valueGetter.apply(rl) == null) continue;
                    Tag.ListEntry dummyEntry = new Tag.ListEntry(Collections.singletonList(valueGetter.apply(rl)));
                    builder.remove((Tag.ITagEntry)dummyEntry);
                    continue;
                }
                Tag.TagEntry dummyEntry = new Tag.TagEntry(new ResourceLocation(s.substring(1)));
                builder.remove((Tag.ITagEntry)dummyEntry);
            }
        }
    }

    static {
        DUMMY_WORLD = new DummyBlockReader();
    }

    private static class OptionalTagEntry<T>
    extends Tag.TagEntry<T> {
        private Tag<T> resolvedTag = null;

        OptionalTagEntry(ResourceLocation referent) {
            super(referent);
        }

        public boolean func_200161_a(@Nonnull Function<ResourceLocation, Tag<T>> resolver) {
            if (this.resolvedTag == null) {
                this.resolvedTag = resolver.apply(this.func_200577_a());
            }
            return true;
        }

        public void func_200162_a(@Nonnull Collection<T> items) {
            if (this.resolvedTag != null) {
                items.addAll(this.resolvedTag.func_199885_a());
            }
        }
    }

    private static class DummyBlockReader
    implements IBlockReader {
        private DummyBlockReader() {
        }

        public TileEntity func_175625_s(BlockPos pos) {
            return null;
        }

        public IBlockState func_180495_p(BlockPos pos) {
            return Blocks.field_150350_a.func_176223_P();
        }

        public IFluidState func_204610_c(BlockPos pos) {
            return Fluids.field_204541_a.func_207188_f();
        }
    }

    private static class LootTableContext {
        public final ResourceLocation name;
        private final boolean vanilla;
        public final boolean custom;
        public int poolCount = 0;
        public int entryCount = 0;
        private HashSet<String> entryNames = Sets.newHashSet();

        private LootTableContext(ResourceLocation name, boolean custom) {
            this.name = name;
            this.custom = custom;
            this.vanilla = "minecraft".equals(this.name.func_110624_b());
        }

        private void resetPoolCtx() {
            this.entryCount = 0;
            this.entryNames.clear();
        }

        public String validateEntryName(@Nullable String name) {
            if (name != null && !this.entryNames.contains(name)) {
                this.entryNames.add(name);
                return name;
            }
            if (!this.vanilla) {
                throw new JsonParseException("Loot Table \"" + this.name.toString() + "\" Duplicate entry name \"" + name + "\" for pool #" + (this.poolCount - 1) + " entry #" + (this.entryCount - 1));
            }
            int x = 0;
            while (this.entryNames.contains(name + "#" + x)) {
                ++x;
            }
            name = name + "#" + x;
            this.entryNames.add(name);
            return name;
        }
    }

    static class SeedEntry
    extends WeightedRandom.Item {
        @Nonnull
        public final ItemStack seed;

        public SeedEntry(@Nonnull ItemStack seed, int weight) {
            super(weight);
            this.seed = seed;
        }

        @Nonnull
        public ItemStack getStack(Random rand, int fortune) {
            return this.seed.func_77946_l();
        }
    }
}

