/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting;

import com.google.gson.JsonObject;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class IngredientNBT
extends Ingredient {
    private final ItemStack stack;

    protected IngredientNBT(ItemStack stack) {
        super(Stream.of(new Ingredient.SingleItemList(stack)));
        this.stack = stack;
    }

    public boolean test(@Nullable ItemStack input) {
        if (input == null) {
            return false;
        }
        return this.stack.func_77973_b() == input.func_77973_b() && this.stack.func_77952_i() == input.func_77952_i() && this.stack.areShareTagsEqual(input);
    }

    public boolean isSimple() {
        return false;
    }

    public static class Serializer
    implements IIngredientSerializer<IngredientNBT> {
        @Override
        public IngredientNBT parse(PacketBuffer buffer) {
            return new IngredientNBT(buffer.func_150791_c());
        }

        @Override
        public IngredientNBT parse(JsonObject json) {
            return new IngredientNBT(CraftingHelper.getItemStack(json, true));
        }

        @Override
        public void write(PacketBuffer buffer, IngredientNBT ingredient) {
            buffer.func_150788_a(ingredient.stack);
        }
    }
}

