/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLeashKnot;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.init.Items;
import net.minecraft.item.ItemSpawnEgg;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.ITeleporter;

public interface IForgeEntity
extends ICapabilitySerializable<NBTTagCompound> {
    default public Entity getEntity() {
        return (Entity)this;
    }

    @Override
    default public void deserializeNBT(NBTTagCompound nbt) {
        this.getEntity().func_70020_e(nbt);
    }

    @Override
    default public NBTTagCompound serializeNBT() {
        NBTTagCompound ret = new NBTTagCompound();
        String id = this.getEntity().func_70022_Q();
        if (id != null) {
            ret.func_74778_a("id", this.getEntity().func_70022_Q());
        }
        return this.getEntity().func_189511_e(ret);
    }

    public boolean canUpdate();

    public void canUpdate(boolean var1);

    @Nullable
    public Collection<EntityItem> captureDrops();

    public Collection<EntityItem> captureDrops(@Nullable Collection<EntityItem> var1);

    public NBTTagCompound getEntityData();

    default public boolean shouldRiderSit() {
        return true;
    }

    default public ItemStack getPickedResult(RayTraceResult target) {
        if (this instanceof EntityPainting) {
            return new ItemStack((IItemProvider)Items.field_151159_an);
        }
        if (this instanceof EntityLeashKnot) {
            return new ItemStack((IItemProvider)Items.field_151058_ca);
        }
        if (this instanceof EntityItemFrame) {
            ItemStack held = ((EntityItemFrame)this).func_82335_i();
            if (held.func_190926_b()) {
                return new ItemStack((IItemProvider)Items.field_151160_bD);
            }
            return held.func_77946_l();
        }
        if (this instanceof EntityMinecart) {
            return ((EntityMinecart)this).getCartItem();
        }
        if (this instanceof EntityBoat) {
            return new ItemStack((IItemProvider)((EntityBoat)this).func_184455_j());
        }
        if (this instanceof EntityArmorStand) {
            return new ItemStack((IItemProvider)Items.field_179565_cj);
        }
        if (this instanceof EntityEnderCrystal) {
            return new ItemStack((IItemProvider)Items.field_185158_cP);
        }
        ItemSpawnEgg egg = ItemSpawnEgg.func_200889_b((EntityType)this.getEntity().func_200600_R());
        if (egg != null) {
            return new ItemStack((IItemProvider)egg);
        }
        return ItemStack.field_190927_a;
    }

    default public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }

    default public boolean canRiderInteract() {
        return false;
    }

    default public boolean canBeRiddenInWater(Entity rider) {
        return this instanceof EntityLivingBase;
    }

    @Nullable
    public Entity changeDimension(DimensionType var1, ITeleporter var2);

    public boolean canTrample(IBlockState var1, BlockPos var2, float var3);

    default public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        if (forSpawnCount && this instanceof EntityLiving && ((EntityLiving)this).func_104002_bU()) {
            return false;
        }
        return type.func_75598_a().isAssignableFrom(this.getClass());
    }

    public boolean isAddedToWorld();

    public void onAddedToWorld();

    public void onRemovedFromWorld();

    public void revive();
}

