/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.world;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public class BlockEvent
extends Event {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugBlockEvent", "false"));
    private final IWorld world;
    private final BlockPos pos;
    private final IBlockState state;

    public BlockEvent(IWorld world, BlockPos pos, IBlockState state) {
        this.pos = pos;
        this.world = world;
        this.state = state;
    }

    public IWorld getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public IBlockState getState() {
        return this.state;
    }

    @Cancelable
    public static class PortalSpawnEvent
    extends BlockEvent {
        private final BlockPortal.Size size;

        public PortalSpawnEvent(IWorld world, BlockPos pos, IBlockState state, BlockPortal.Size size) {
            super(world, pos, state);
            this.size = size;
        }

        public BlockPortal.Size getPortalSize() {
            return this.size;
        }
    }

    @Cancelable
    public static class FarmlandTrampleEvent
    extends BlockEvent {
        private final Entity entity;
        private final float fallDistance;

        public FarmlandTrampleEvent(World world, BlockPos pos, IBlockState state, float fallDistance, Entity entity) {
            super((IWorld)world, pos, state);
            this.entity = entity;
            this.fallDistance = fallDistance;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public float getFallDistance() {
            return this.fallDistance;
        }
    }

    public static class CropGrowEvent
    extends BlockEvent {
        public CropGrowEvent(World world, BlockPos pos, IBlockState state) {
            super((IWorld)world, pos, state);
        }

        public static class Post
        extends CropGrowEvent {
            private final IBlockState originalState;

            public Post(World world, BlockPos pos, IBlockState original, IBlockState state) {
                super(world, pos, state);
                this.originalState = original;
            }

            public IBlockState getOriginalState() {
                return this.originalState;
            }
        }

        @Event.HasResult
        public static class Pre
        extends CropGrowEvent {
            public Pre(World world, BlockPos pos, IBlockState state) {
                super(world, pos, state);
            }
        }
    }

    @Cancelable
    public static class FluidPlaceBlockEvent
    extends BlockEvent {
        private final BlockPos liquidPos;
        private IBlockState newState;
        private IBlockState origState;

        public FluidPlaceBlockEvent(World world, BlockPos pos, BlockPos liquidPos, IBlockState state) {
            super((IWorld)world, pos, state);
            this.liquidPos = liquidPos;
            this.newState = state;
            this.origState = world.func_180495_p(pos);
        }

        public BlockPos getLiquidPos() {
            return this.liquidPos;
        }

        public IBlockState getNewState() {
            return this.newState;
        }

        public void setNewState(IBlockState state) {
            this.newState = state;
        }

        public IBlockState getOriginalState() {
            return this.origState;
        }
    }

    @Event.HasResult
    public static class CreateFluidSourceEvent
    extends BlockEvent {
        public CreateFluidSourceEvent(World world, BlockPos pos, IBlockState state) {
            super((IWorld)world, pos, state);
        }
    }

    @Cancelable
    public static class NeighborNotifyEvent
    extends BlockEvent {
        private final EnumSet<EnumFacing> notifiedSides;
        private final boolean forceRedstoneUpdate;

        public NeighborNotifyEvent(World world, BlockPos pos, IBlockState state, EnumSet<EnumFacing> notifiedSides, boolean forceRedstoneUpdate) {
            super((IWorld)world, pos, state);
            this.notifiedSides = notifiedSides;
            this.forceRedstoneUpdate = forceRedstoneUpdate;
        }

        public EnumSet<EnumFacing> getNotifiedSides() {
            return this.notifiedSides;
        }

        public boolean getForceRedstoneUpdate() {
            return this.forceRedstoneUpdate;
        }
    }

    @Cancelable
    public static class MultiPlaceEvent
    extends PlaceEvent {
        private final List<BlockSnapshot> blockSnapshots;

        public MultiPlaceEvent(@Nonnull List<BlockSnapshot> blockSnapshots, @Nonnull IBlockState placedAgainst, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
            super(blockSnapshots.get(0), placedAgainst, player, hand);
            this.blockSnapshots = ImmutableList.copyOf(blockSnapshots);
            if (DEBUG) {
                System.out.printf("Created MultiPlaceEvent - [PlacedAgainst: %s ][ItemInHand: %s ][Player: %s ]\n", placedAgainst, player.func_184586_b(hand), player);
            }
        }

        public List<BlockSnapshot> getReplacedBlockSnapshots() {
            return this.blockSnapshots;
        }
    }

    @Cancelable
    public static class PlaceEvent
    extends BlockEvent {
        private final EntityPlayer player;
        private final BlockSnapshot blockSnapshot;
        private final IBlockState placedBlock;
        private final IBlockState placedAgainst;
        private final EnumHand hand;

        public PlaceEvent(@Nonnull BlockSnapshot blockSnapshot, @Nonnull IBlockState placedAgainst, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
            super((IWorld)blockSnapshot.getWorld(), blockSnapshot.getPos(), blockSnapshot.getCurrentBlock());
            this.player = player;
            this.blockSnapshot = blockSnapshot;
            this.placedBlock = blockSnapshot.getCurrentBlock();
            this.placedAgainst = placedAgainst;
            this.hand = hand;
            if (DEBUG) {
                System.out.printf("Created PlaceEvent - [PlacedBlock: %s ][PlacedAgainst: %s ][ItemStack: %s ][Player: %s ][Hand: %s]\n", this.getPlacedBlock(), placedAgainst, player.func_184586_b(hand), player, hand);
            }
        }

        public EntityPlayer getPlayer() {
            return this.player;
        }

        public BlockSnapshot getBlockSnapshot() {
            return this.blockSnapshot;
        }

        public IBlockState getPlacedBlock() {
            return this.placedBlock;
        }

        public IBlockState getPlacedAgainst() {
            return this.placedAgainst;
        }

        public EnumHand getHand() {
            return this.hand;
        }
    }

    @Cancelable
    public static class BreakEvent
    extends BlockEvent {
        private final EntityPlayer player;
        private int exp;

        public BreakEvent(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
            super((IWorld)world, pos, state);
            this.player = player;
            if (state == null || !ForgeHooks.canHarvestBlock(state, player, (IBlockReader)world, pos) || state.canSilkHarvest((IWorldReader)world, pos, player) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)player.func_184614_ca()) > 0) {
                this.exp = 0;
            } else {
                int bonusLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184614_ca());
                this.exp = state.func_177230_c().getExpDrop(state, (IWorldReader)world, pos, bonusLevel);
            }
        }

        public EntityPlayer getPlayer() {
            return this.player;
        }

        public int getExpToDrop() {
            return this.isCanceled() ? 0 : this.exp;
        }

        public void setExpToDrop(int exp) {
            this.exp = exp;
        }
    }

    public static class HarvestDropsEvent
    extends BlockEvent {
        private final int fortuneLevel;
        private final NonNullList<ItemStack> drops;
        private final boolean isSilkTouching;
        private float dropChance;
        private final EntityPlayer harvester;

        public HarvestDropsEvent(World world, BlockPos pos, IBlockState state, int fortuneLevel, float dropChance, NonNullList<ItemStack> drops, EntityPlayer harvester, boolean isSilkTouching) {
            super((IWorld)world, pos, state);
            this.fortuneLevel = fortuneLevel;
            this.setDropChance(dropChance);
            this.drops = drops;
            this.isSilkTouching = isSilkTouching;
            this.harvester = harvester;
        }

        public int getFortuneLevel() {
            return this.fortuneLevel;
        }

        public List<ItemStack> getDrops() {
            return this.drops;
        }

        public boolean isSilkTouching() {
            return this.isSilkTouching;
        }

        public float getDropChance() {
            return this.dropChance;
        }

        public void setDropChance(float dropChance) {
            this.dropChance = dropChance;
        }

        public EntityPlayer getHarvester() {
            return this.harvester;
        }
    }
}

