/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingException;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.forgespi.language.ILifecycleEvent;

public enum LifecycleEventProvider {
    CONSTRUCT(() -> new LifecycleEvent(ModLoadingStage.CONSTRUCT)),
    CREATE_REGISTRIES(() -> new LifecycleEvent(ModLoadingStage.CREATE_REGISTRIES), ModList.inlineDispatcher),
    LOAD_REGISTRIES(() -> new LifecycleEvent(ModLoadingStage.LOAD_REGISTRIES, LifecycleEvent.Progression.STAY), ModList.inlineDispatcher),
    SETUP(() -> new LifecycleEvent(ModLoadingStage.COMMON_SETUP)),
    SIDED_SETUP(() -> new LifecycleEvent(ModLoadingStage.SIDED_SETUP)),
    ENQUEUE_IMC(() -> new LifecycleEvent(ModLoadingStage.ENQUEUE_IMC)),
    PROCESS_IMC(() -> new LifecycleEvent(ModLoadingStage.PROCESS_IMC)),
    COMPLETE(() -> new LifecycleEvent(ModLoadingStage.COMPLETE));

    private final Supplier<? extends LifecycleEvent> event;
    private final BiConsumer<LifecycleEvent, Consumer<List<ModLoadingException>>> eventDispatcher;
    private Supplier<Event> customEventSupplier;
    private LifecycleEvent.Progression progression = LifecycleEvent.Progression.NEXT;

    private LifecycleEventProvider(Supplier<? extends LifecycleEvent> e) {
        this(e, ModList.parallelDispatcher);
    }

    private LifecycleEventProvider(Supplier<? extends LifecycleEvent> e, BiConsumer<LifecycleEvent, Consumer<List<ModLoadingException>>> eventDispatcher) {
        this.event = e;
        this.eventDispatcher = eventDispatcher;
    }

    public void setCustomEventSupplier(Supplier<Event> eventSupplier) {
        this.customEventSupplier = eventSupplier;
    }

    public void changeProgression(LifecycleEvent.Progression progression) {
        this.progression = progression;
    }

    public void dispatch(Consumer<List<ModLoadingException>> errorHandler) {
        LifecycleEvent lifecycleEvent = this.event.get();
        lifecycleEvent.setCustomEventSupplier(this.customEventSupplier);
        lifecycleEvent.changeProgression(this.progression);
        this.eventDispatcher.accept(lifecycleEvent, errorHandler);
    }

    public static class LifecycleEvent
    implements ILifecycleEvent<LifecycleEvent> {
        private final ModLoadingStage stage;
        private Supplier<Event> customEventSupplier;
        private Progression progression;

        LifecycleEvent(ModLoadingStage stage) {
            this(stage, Progression.NEXT);
        }

        LifecycleEvent(ModLoadingStage stage, Progression progression) {
            this.stage = stage;
            this.progression = progression;
        }

        public ModLoadingStage fromStage() {
            return this.stage;
        }

        public ModLoadingStage toStage() {
            return this.progression.apply(this.stage);
        }

        public void setCustomEventSupplier(Supplier<Event> customEventSupplier) {
            this.customEventSupplier = customEventSupplier;
        }

        public void changeProgression(Progression p) {
            this.progression = p;
        }

        public Event getOrBuildEvent(ModContainer modContainer) {
            if (this.customEventSupplier != null) {
                return this.customEventSupplier.get();
            }
            return this.stage.getModEvent(modContainer);
        }

        public String toString() {
            return "LifecycleEvent:" + (Object)((Object)this.stage);
        }

        public static enum Progression {
            NEXT(current -> ModLoadingStage.values()[current.ordinal() + 1]),
            STAY(Function.identity());

            private final Function<ModLoadingStage, ModLoadingStage> edge;

            private Progression(Function<ModLoadingStage, ModLoadingStage> edge) {
                this.edge = edge;
            }

            public ModLoadingStage apply(ModLoadingStage in) {
                return this.edge.apply(in);
            }
        }
    }
}

