/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client;

import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.DownloadingPackFinder;
import net.minecraft.client.resources.ResourcePackInfoClient;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.ResourcePackList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.fml.LoadingFailedException;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.fml.SidedProvider;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.client.ClientHooks;
import net.minecraftforge.fml.client.gui.LoadingErrorScreen;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.packs.ResourcePackLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ClientModLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean loading;
    private static Minecraft mc;
    private static LoadingFailedException error;

    public static void begin(Minecraft minecraft, ResourcePackList<ResourcePackInfoClient> defaultResourcePacks, IReloadableResourceManager mcResourceManager, DownloadingPackFinder metadataSerializer) {
        loading = true;
        mc = minecraft;
        SidedProvider.setClient(() -> minecraft);
        LogicalSidedProvider.setClient(() -> minecraft);
        try {
            ModLoader.get().loadMods();
        }
        catch (LoadingFailedException e) {
            error = e;
        }
        ResourcePackLoader.loadResourcePacks(defaultResourcePacks);
    }

    public static void end() {
        block2: {
            try {
                ModLoader.get().finishMods();
            }
            catch (LoadingFailedException e) {
                if (error != null) break block2;
                error = e;
            }
        }
        loading = false;
        ClientModLoader.mc.field_71474_y.func_74300_a();
    }

    public static VersionChecker.Status checkForUpdates() {
        return VersionChecker.Status.UP_TO_DATE;
    }

    public static void complete() {
        GlStateManager.func_179090_x();
        GlStateManager.func_179098_w();
        List<ModLoadingWarning> warnings = ModLoader.get().getWarnings();
        boolean showWarnings = true;
        try {
            showWarnings = (Boolean)ForgeConfig.CLIENT.showLoadWarnings.get();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (!showWarnings) {
            if (!warnings.isEmpty()) {
                LOGGER.warn(LogMarkers.LOADING, "Mods loaded with {} warning(s)", (Object)warnings.size());
                warnings.forEach(warning -> LOGGER.warn(LogMarkers.LOADING, warning.formatToString()));
            }
            warnings = Collections.emptyList();
        }
        if (error != null || !warnings.isEmpty()) {
            mc.func_147108_a((GuiScreen)new LoadingErrorScreen(error, warnings));
        } else {
            ClientHooks.logMissingTextureErrors();
        }
    }

    public static boolean isLoading() {
        return loading;
    }
}

