/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client.gui;

import com.google.common.base.Strings;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiErrorScreen;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.util.Util;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.ForgeI18n;
import net.minecraftforge.fml.LoadingFailedException;
import net.minecraftforge.fml.ModLoadingException;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.fml.client.ClientHooks;
import net.minecraftforge.fml.client.gui.GuiButtonClickConsumer;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoadingErrorScreen
extends GuiErrorScreen {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Path modsDir;
    private final Path logFile;
    private final List<ModLoadingException> modLoadErrors;
    private final List<ModLoadingWarning> modLoadWarnings;
    private LoadingEntryList entryList;
    private String errorHeader;
    private String warningHeader;

    public LoadingErrorScreen(LoadingFailedException loadingException, List<ModLoadingWarning> warnings) {
        super(null, null);
        this.modLoadWarnings = warnings;
        this.modLoadErrors = loadingException == null ? Collections.emptyList() : loadingException.getErrors();
        this.modsDir = FMLPaths.MODSDIR.get();
        this.logFile = FMLPaths.GAMEDIR.get().resolve(Paths.get("logs", "latest.log"));
    }

    private double openModsDir(double mouseX, double mouseY) {
        Util.func_110647_a().func_195641_a(this.modsDir.toFile());
        return 0.0;
    }

    private double openLogFile(double mouseX, double mouseY) {
        Util.func_110647_a().func_195641_a(this.logFile.toFile());
        return 0.0;
    }

    private double continueGame(double mouseX, double mouseY) {
        ClientHooks.logMissingTextureErrors();
        this.field_146297_k.func_147108_a(null);
        return 0.0;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_195124_j.clear();
        this.errorHeader = TextFormatting.RED + ForgeI18n.parseMessage("fml.loadingerrorscreen.errorheader", this.modLoadErrors.size()) + TextFormatting.RESET;
        this.warningHeader = TextFormatting.YELLOW + ForgeI18n.parseMessage("fml.loadingerrorscreen.warningheader", this.modLoadErrors.size()) + TextFormatting.RESET;
        int yOffset = this.modLoadErrors.isEmpty() ? 46 : 38;
        this.func_189646_b(new GuiButtonClickConsumer(10, 50, this.field_146295_m - yOffset, this.field_146294_l / 2 - 55, 20, ForgeI18n.parseMessage("fml.button.open.mods.folder", new Object[0]), this::openModsDir));
        this.func_189646_b(new GuiButtonClickConsumer(11, this.field_146294_l / 2 + 5, this.field_146295_m - yOffset, this.field_146294_l / 2 - 55, 20, ForgeI18n.parseMessage("fml.button.open.file", this.logFile.getFileName()), this::openLogFile));
        if (this.modLoadErrors.isEmpty()) {
            this.func_189646_b(new GuiButtonClickConsumer(12, this.field_146294_l / 4, this.field_146295_m - 24, this.field_146294_l / 2, 20, ForgeI18n.parseMessage("fml.button.continue.launch", new Object[0]), this::continueGame));
        }
        this.entryList = new LoadingEntryList(this, this.modLoadErrors, this.modLoadWarnings);
        this.field_195124_j.add(this.entryList);
        this.func_195073_a((IGuiEventListener)this.entryList);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.entryList.func_148128_a(mouseX, mouseY, partialTicks);
        this.drawMultiLineCenteredString(this.field_146289_q, this.modLoadErrors.isEmpty() ? this.warningHeader : this.errorHeader, this.field_146294_l / 2, 10);
        this.field_146292_n.forEach(button -> button.func_194828_a(mouseX, mouseY, partialTicks));
    }

    private void drawMultiLineCenteredString(FontRenderer fr, String str, int x, int y) {
        for (String s : fr.func_78271_c(str, this.field_146294_l)) {
            fr.func_175063_a(s, (float)((double)x - (double)fr.func_78256_a(s) / 2.0), (float)y, 0xFFFFFF);
            y += fr.field_78288_b;
        }
    }

    public static class LoadingEntryList
    extends GuiListExtended<LoadingMessageEntry> {
        LoadingEntryList(LoadingErrorScreen parent, List<ModLoadingException> errors, List<ModLoadingWarning> warnings) {
            super(parent.field_146297_k, parent.field_146294_l, parent.field_146295_m, 35, parent.field_146295_m - 50, 2 * parent.field_146297_k.field_71466_p.field_78288_b + 8);
            boolean both;
            boolean bl = both = !errors.isEmpty() && !warnings.isEmpty();
            if (both) {
                this.func_195085_a(new LoadingMessageEntry(parent.errorHeader, true));
            }
            errors.forEach(e -> this.func_195085_a(new LoadingMessageEntry(e.formatToString())));
            if (both) {
                int maxChars = (this.field_148155_a - 10) / parent.field_146297_k.field_71466_p.func_78256_a("-");
                this.func_195085_a(new LoadingMessageEntry("\n" + Strings.repeat((String)"-", (int)maxChars) + "\n"));
                this.func_195085_a(new LoadingMessageEntry(parent.warningHeader, true));
            }
            warnings.forEach(w -> this.func_195085_a(new LoadingMessageEntry(w.formatToString())));
        }

        protected int func_148137_d() {
            return this.field_148151_d - 6;
        }

        public int func_148139_c() {
            return this.field_148155_a;
        }

        public class LoadingMessageEntry
        extends GuiListExtended.IGuiListEntry<LoadingMessageEntry> {
            private final String message;
            private final boolean center;

            LoadingMessageEntry(String message) {
                this(message, false);
            }

            LoadingMessageEntry(String message, boolean center) {
                this.message = Objects.requireNonNull(message);
                this.center = center;
            }

            public void func_194999_a(int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
                int top = this.func_195001_c();
                int left = this.func_195002_d();
                FontRenderer font = Minecraft.func_71410_x().field_71466_p;
                List strings = font.func_78271_c(this.message, LoadingEntryList.this.field_148155_a);
                int y = top + 2;
                for (int i = 0; i < Math.min(strings.size(), 2); ++i) {
                    if (this.center) {
                        font.func_211126_b((String)strings.get(i), (float)left + (float)LoadingEntryList.this.field_148155_a / 2.0f - (float)font.func_78256_a((String)strings.get(i)) / 2.0f, (float)y, 0xFFFFFF);
                    } else {
                        font.func_211126_b((String)strings.get(i), (float)(left + 5), (float)y, 0xFFFFFF);
                    }
                    y += font.field_78288_b;
                }
            }
        }
    }
}

