/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.event.lifecycle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.ModLifecycleEvent;

public class FMLModIdMappingEvent
extends ModLifecycleEvent {
    private final Map<ResourceLocation, ImmutableList<ModRemapping>> remaps;
    private final ImmutableSet<ResourceLocation> keys;
    public final boolean isFrozen;

    public FMLModIdMappingEvent(Map<ResourceLocation, Map<ResourceLocation, Integer[]>> remaps, boolean isFrozen) {
        super(null);
        this.isFrozen = isFrozen;
        this.remaps = Maps.newHashMap();
        remaps.forEach((name, rm) -> {
            ArrayList tmp = Lists.newArrayList();
            rm.forEach((key, value) -> tmp.add(new ModRemapping((ResourceLocation)name, (ResourceLocation)key, value[0], value[1])));
            tmp.sort(Comparator.comparingInt(o -> o.newId));
            this.remaps.put((ResourceLocation)name, (ImmutableList<ModRemapping>)ImmutableList.copyOf((Collection)tmp));
        });
        this.keys = ImmutableSet.copyOf(this.remaps.keySet());
    }

    public ImmutableSet<ResourceLocation> getRegistries() {
        return this.keys;
    }

    public ImmutableList<ModRemapping> getRemaps(ResourceLocation registry) {
        return this.remaps.get(registry);
    }

    public class ModRemapping {
        public final ResourceLocation registry;
        public final ResourceLocation key;
        public final int oldId;
        public final int newId;

        private ModRemapping(ResourceLocation registry, ResourceLocation key, int oldId, int newId) {
            this.registry = registry;
            this.key = key;
            this.oldId = oldId;
            this.newId = newId;
        }
    }
}

