/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.network;

import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegistryManager;

public class FMLHandshakeMessages {

    public static class S2CConfigData
    extends LoginIndexedMessage {
        private final String fileName;
        private final byte[] fileData;

        public S2CConfigData(String configFileName, byte[] configFileData) {
            this.fileName = configFileName;
            this.fileData = configFileData;
        }

        void encode(PacketBuffer buffer) {
            buffer.func_180714_a(this.fileName);
            buffer.func_179250_a(this.fileData);
        }

        public static S2CConfigData decode(PacketBuffer buffer) {
            return new S2CConfigData(buffer.func_150789_c(128), buffer.func_179251_a());
        }

        public String getFileName() {
            return this.fileName;
        }

        public byte[] getBytes() {
            return this.fileData;
        }
    }

    public static class S2CRegistry
    extends LoginIndexedMessage {
        private ResourceLocation registryName;
        @Nullable
        private ForgeRegistry.Snapshot snapshot;

        public S2CRegistry(ResourceLocation name, @Nullable ForgeRegistry.Snapshot snapshot) {
            this.registryName = name;
            this.snapshot = snapshot;
        }

        void encode(PacketBuffer buffer) {
            buffer.func_192572_a(this.registryName);
            buffer.writeBoolean(this.hasSnapshot());
            if (this.hasSnapshot()) {
                buffer.writeBytes((ByteBuf)this.snapshot.getPacketData());
            }
        }

        public static S2CRegistry decode(PacketBuffer buffer) {
            ResourceLocation name = buffer.func_192575_l();
            ForgeRegistry.Snapshot snapshot = null;
            if (buffer.readBoolean()) {
                snapshot = ForgeRegistry.Snapshot.read(buffer);
            }
            return new S2CRegistry(name, snapshot);
        }

        public ResourceLocation getRegistryName() {
            return this.registryName;
        }

        public boolean hasSnapshot() {
            return this.snapshot != null;
        }

        @Nullable
        public ForgeRegistry.Snapshot getSnapshot() {
            return this.snapshot;
        }
    }

    public static class C2SAcknowledge
    extends LoginIndexedMessage {
        public void encode(PacketBuffer buf) {
        }

        public static C2SAcknowledge decode(PacketBuffer buf) {
            return new C2SAcknowledge();
        }
    }

    public static class C2SModListReply
    extends LoginIndexedMessage {
        private List<String> mods;
        private Map<ResourceLocation, String> channels;
        private Map<ResourceLocation, String> registries;

        public C2SModListReply() {
            this.mods = ModList.get().getMods().stream().map(ModInfo::getModId).collect(Collectors.toList());
            this.channels = NetworkRegistry.buildChannelVersions();
            this.registries = Maps.newHashMap();
        }

        private C2SModListReply(List<String> mods, Map<ResourceLocation, String> channels, Map<ResourceLocation, String> registries) {
            this.mods = mods;
            this.channels = channels;
            this.registries = registries;
        }

        public static C2SModListReply decode(PacketBuffer input) {
            ArrayList<String> mods = new ArrayList<String>();
            int len = input.func_150792_a();
            for (int x = 0; x < len; ++x) {
                mods.add(input.func_150789_c(256));
            }
            HashMap<ResourceLocation, String> channels = new HashMap<ResourceLocation, String>();
            len = input.func_150792_a();
            for (int x = 0; x < len; ++x) {
                channels.put(input.func_192575_l(), input.func_150789_c(256));
            }
            HashMap<ResourceLocation, String> registries = new HashMap<ResourceLocation, String>();
            len = input.func_150792_a();
            for (int x = 0; x < len; ++x) {
                registries.put(input.func_192575_l(), input.func_150789_c(256));
            }
            return new C2SModListReply(mods, channels, registries);
        }

        public void encode(PacketBuffer output) {
            output.func_150787_b(this.mods.size());
            this.mods.forEach(m -> output.func_211400_a(m, 256));
            output.func_150787_b(this.channels.size());
            this.channels.forEach((k, v) -> {
                output.func_192572_a(k);
                output.func_211400_a(v, 256);
            });
            output.func_150787_b(this.registries.size());
            this.registries.forEach((k, v) -> {
                output.func_192572_a(k);
                output.func_211400_a(v, 256);
            });
        }

        public List<String> getModList() {
            return this.mods;
        }

        public Map<ResourceLocation, String> getRegistries() {
            return this.registries;
        }

        public Map<ResourceLocation, String> getChannels() {
            return this.channels;
        }
    }

    public static class S2CModList
    extends LoginIndexedMessage {
        private List<String> mods;
        private Map<ResourceLocation, String> channels;
        private List<ResourceLocation> registries;

        public S2CModList() {
            this.mods = ModList.get().getMods().stream().map(ModInfo::getModId).collect(Collectors.toList());
            this.channels = NetworkRegistry.buildChannelVersions();
            this.registries = RegistryManager.registryNames();
        }

        private S2CModList(List<String> mods, Map<ResourceLocation, String> channels, List<ResourceLocation> registries) {
            this.mods = mods;
            this.channels = channels;
            this.registries = registries;
        }

        public static S2CModList decode(PacketBuffer input) {
            ArrayList<String> mods = new ArrayList<String>();
            int len = input.func_150792_a();
            for (int x = 0; x < len; ++x) {
                mods.add(input.func_150789_c(256));
            }
            HashMap<ResourceLocation, String> channels = new HashMap<ResourceLocation, String>();
            len = input.func_150792_a();
            for (int x = 0; x < len; ++x) {
                channels.put(input.func_192575_l(), input.func_150789_c(256));
            }
            ArrayList<ResourceLocation> registries = new ArrayList<ResourceLocation>();
            len = input.func_150792_a();
            for (int x = 0; x < len; ++x) {
                registries.add(input.func_192575_l());
            }
            return new S2CModList(mods, channels, registries);
        }

        public void encode(PacketBuffer output) {
            output.func_150787_b(this.mods.size());
            this.mods.forEach(m -> output.func_211400_a(m, 256));
            output.func_150787_b(this.channels.size());
            this.channels.forEach((k, v) -> {
                output.func_192572_a(k);
                output.func_211400_a(v, 256);
            });
            output.func_150787_b(this.registries.size());
            this.registries.forEach(arg_0 -> ((PacketBuffer)output).func_192572_a(arg_0));
        }

        public List<String> getModList() {
            return this.mods;
        }

        public List<ResourceLocation> getRegistries() {
            return this.registries;
        }

        public Map<ResourceLocation, String> getChannels() {
            return this.channels;
        }
    }

    static class LoginIndexedMessage {
        private int loginIndex;

        LoginIndexedMessage() {
        }

        void setLoginIndex(int loginIndex) {
            this.loginIndex = loginIndex;
        }

        int getLoginIndex() {
            return this.loginIndex;
        }
    }
}

