/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.packs;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.resources.AbstractResourcePack;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.StackTraceUtils;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModFileResourcePack
extends AbstractResourcePack {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ModFile modFile;
    private ResourcePackInfo packInfo;
    private static final ExecutorService STUPIDPAULSCODEISSTUPIDWORKAROUNDTHREAD = Executors.newSingleThreadExecutor();
    private static final Path tempDir;

    public ModFileResourcePack(ModFile modFile) {
        super(new File("dummy"));
        this.modFile = modFile;
    }

    public ModFile getModFile() {
        return this.modFile;
    }

    public String func_195762_a() {
        return this.modFile.getFileName();
    }

    protected InputStream func_195766_a(String name) throws IOException {
        Path path = this.modFile.getLocator().findPath(this.modFile, new String[]{name});
        if (path.getFileSystem() == FileSystems.getDefault()) {
            LOGGER.trace(Logging.CORE, "Request for resource {} returning FileInputStream for regular file {}", (Object)name, (Object)path);
            return new FileInputStream(path.toFile());
        }
        if (StackTraceUtils.threadClassNameEquals("paulscode.sound.CommandThread")) {
            Path tempFile = Files.createTempFile(tempDir, "modpack", "soundresource", new FileAttribute[0]);
            Future<FileInputStream> fis = STUPIDPAULSCODEISSTUPIDWORKAROUNDTHREAD.submit(() -> {
                try (SeekableByteChannel resourceChannel = Files.newByteChannel(path, StandardOpenOption.READ);
                     FileChannel tempFileChannel = FileChannel.open(tempFile, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                    long size = resourceChannel.size();
                    for (long written = 0L; written < size; written += tempFileChannel.transferFrom(resourceChannel, written, size - written)) {
                    }
                }
                LOGGER.trace(Logging.CORE, "Request for resource {} returning DeletingTemporaryFileInputStream for packed file {} on paulscode thread", (Object)name, (Object)path);
                return new FileInputStream(tempFile.toFile());
            });
            try {
                while (true) {
                    try {
                        return fis.get();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
            catch (ExecutionException e) {
                LOGGER.fatal(Logging.CORE, "Encountered fatal exception copying sound resource", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return Files.newInputStream(path, StandardOpenOption.READ);
    }

    protected boolean func_195768_c(String name) {
        return Files.exists(this.modFile.getLocator().findPath(this.modFile, new String[]{name}), new LinkOption[0]);
    }

    public Collection<ResourceLocation> func_195758_a(ResourcePackType type, String pathIn, int maxDepth, Predicate<String> filter) {
        try {
            Path root = this.modFile.getLocator().findPath(this.modFile, new String[]{type.func_198956_a()}).toAbsolutePath();
            Path inputPath = root.getFileSystem().getPath(pathIn, new String[0]);
            return Files.walk(root, new FileVisitOption[0]).map(path -> root.relativize(path.toAbsolutePath())).filter(path -> path.getNameCount() > 1 && path.getNameCount() - 1 <= maxDepth).filter(path -> !path.toString().endsWith(".mcmeta")).filter(path -> path.subpath(1, path.getNameCount()).startsWith(inputPath)).filter(path -> filter.test(path.getFileName().toString())).map(path -> new ResourceLocation(path.getName(0).toString(), Joiner.on((char)'/').join((Iterable)path.subpath(1, Math.min(maxDepth, path.getNameCount()))))).collect(Collectors.toList());
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public Set<String> func_195759_a(ResourcePackType type) {
        try {
            Path root = this.modFile.getLocator().findPath(this.modFile, new String[]{type.func_198956_a()}).toAbsolutePath();
            return Files.walk(root, 1, new FileVisitOption[0]).map(path -> root.relativize(path.toAbsolutePath())).filter(path -> path.getNameCount() > 0).map(p -> p.toString().replaceAll("/$", "")).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        }
        catch (IOException e) {
            return Collections.emptySet();
        }
    }

    public InputStream func_195761_a(ResourcePackType type, ResourceLocation location) throws IOException {
        if (location.func_110623_a().startsWith("lang/")) {
            return super.func_195761_a(ResourcePackType.CLIENT_RESOURCES, location);
        }
        return super.func_195761_a(type, location);
    }

    public boolean func_195764_b(ResourcePackType type, ResourceLocation location) {
        if (location.func_110623_a().startsWith("lang/")) {
            return super.func_195764_b(ResourcePackType.CLIENT_RESOURCES, location);
        }
        return super.func_195764_b(type, location);
    }

    public void close() throws IOException {
    }

    <T extends ResourcePackInfo> void setPackInfo(T packInfo) {
        this.packInfo = packInfo;
    }

    <T extends ResourcePackInfo> T getPackInfo() {
        return (T)this.packInfo;
    }

    public boolean isHidden() {
        return !this.modFile.getModFileInfo().showAsResourcePack();
    }

    static {
        try {
            tempDir = Files.createTempDirectory("modpacktmp", new FileAttribute[0]);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    Files.walk(tempDir, new FileVisitOption[0]).forEach(f -> {
                        try {
                            Files.deleteIfExists(f);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    });
                    Files.delete(tempDir);
                }
                catch (IOException ioe) {
                    LOGGER.fatal("Failed to clean up tempdir {}", (Object)tempDir);
                }
            }));
        }
        catch (IOException e) {
            LOGGER.fatal(Logging.CORE, "Failed to create temporary directory", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

