/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.google.common.reflect.TypeToken;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IRegistryDelegate;
import net.minecraftforge.registries.RegistryDelegate;

public abstract class ForgeRegistryEntry<V extends IForgeRegistryEntry<V>>
implements IForgeRegistryEntry<V> {
    private final TypeToken<V> token = new TypeToken<V>(this.getClass()){};
    public final IRegistryDelegate<V> delegate = new RegistryDelegate<ForgeRegistryEntry>(this, this.token.getRawType());
    private ResourceLocation registryName = null;

    public final V setRegistryName(String name) {
        if (this.getRegistryName() != null) {
            throw new IllegalStateException("Attempted to set registry name with existing registry name! New: " + name + " Old: " + this.getRegistryName());
        }
        this.registryName = GameData.checkPrefix(name);
        return (V)this;
    }

    @Override
    public final V setRegistryName(ResourceLocation name) {
        return this.setRegistryName(name.toString());
    }

    public final V setRegistryName(String modID, String name) {
        return this.setRegistryName(modID + ":" + name);
    }

    @Override
    @Nullable
    public final ResourceLocation getRegistryName() {
        if (this.delegate.name() != null) {
            return this.delegate.name();
        }
        return this.registryName != null ? this.registryName : null;
    }

    @Override
    public final Class<V> getRegistryType() {
        return this.token.getRawType();
    }
}

