/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.console;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.minecraft.server.dedicated.DedicatedServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;

final class ConsoleCommandCompleter
implements Completer {
    private static final Logger logger = LogManager.getLogger();
    private final DedicatedServer server;

    public ConsoleCommandCompleter(DedicatedServer server) {
        this.server = (DedicatedServer)Preconditions.checkNotNull((Object)server, (Object)"server");
    }

    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        boolean prefix;
        String buffer = line.line();
        if (buffer.isEmpty() || buffer.charAt(0) != '/') {
            buffer = '/' + buffer;
            prefix = false;
        } else {
            prefix = true;
        }
        String input = buffer;
        StringReader stringReader = new StringReader(input);
        if (stringReader.canRead() && stringReader.peek() == '/') {
            stringReader.skip();
        }
        try {
            ParseResults results = (ParseResults)this.server.func_175586_a(() -> this.server.func_195571_aL().func_197054_a().parse(stringReader, (Object)this.server.func_195573_aM())).get();
            Suggestions tabComplete = (Suggestions)this.server.func_195571_aL().func_197054_a().getCompletionSuggestions(results).get();
            for (Suggestion suggestion : tabComplete.getList()) {
                String completion = suggestion.getText();
                if (completion.isEmpty()) continue;
                boolean hasPrefix = prefix || completion.charAt(0) != '/';
                Candidate candidate = new Candidate(hasPrefix ? completion : completion.substring(1));
                candidates.add(candidate);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            logger.error("Failed to tab complete", (Throwable)e);
        }
    }
}

