/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.entity.model.ModelBiped;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.HorseArmorType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public interface IForgeItem {
    default public Item getItem() {
        return (Item)this;
    }

    default public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        return this.getItem().func_111205_h(slot);
    }

    default public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        return true;
    }

    default public String getHighlightTip(ItemStack item, String displayName) {
        return displayName;
    }

    default public EnumActionResult onItemUseFirst(ItemStack stack, ItemUseContext context) {
        return EnumActionResult.PASS;
    }

    public boolean isRepairable();

    default public float getXpRepairRatio(ItemStack stack) {
        return 2.0f;
    }

    @Nullable
    default public NBTTagCompound getShareTag(ItemStack stack) {
        return stack.func_77978_p();
    }

    default public void readShareTag(ItemStack stack, @Nullable NBTTagCompound nbt) {
        stack.func_77982_d(nbt);
    }

    default public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        return false;
    }

    default public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
    }

    default public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return false;
    }

    default public ItemStack getContainerItem(ItemStack itemStack) {
        if (!this.hasContainerItem(itemStack)) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack((IItemProvider)this.getItem().func_77668_q());
    }

    default public boolean hasContainerItem(ItemStack stack) {
        return this.getItem().func_77634_r();
    }

    default public int getEntityLifespan(ItemStack itemStack, World world) {
        return 6000;
    }

    default public boolean hasCustomEntity(ItemStack stack) {
        return false;
    }

    @Nullable
    default public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return null;
    }

    default public boolean onEntityItemUpdate(ItemStack stack, EntityItem entity) {
        return false;
    }

    default public Collection<ItemGroup> getCreativeTabs() {
        return Collections.singletonList(this.getItem().func_77640_w());
    }

    default public float getSmeltingExperience(ItemStack item) {
        return -1.0f;
    }

    default public boolean doesSneakBypassUse(ItemStack stack, IWorldReader world, BlockPos pos, EntityPlayer player) {
        return false;
    }

    default public void onArmorTick(ItemStack stack, World world, EntityPlayer player) {
    }

    default public boolean canEquip(ItemStack stack, EntityEquipmentSlot armorType, Entity entity) {
        return EntityLiving.func_184640_d((ItemStack)stack) == armorType;
    }

    @Nullable
    default public EntityEquipmentSlot getEquipmentSlot(ItemStack stack) {
        return null;
    }

    default public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    @Nullable
    default public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    default public FontRenderer getFontRenderer(ItemStack stack) {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    default public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        return null;
    }

    default public boolean onEntitySwing(ItemStack stack, EntityLivingBase entity) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void renderHelmetOverlay(ItemStack stack, EntityPlayer player, int width, int height, float partialTicks) {
    }

    default public int getDamage(ItemStack stack) {
        return !stack.func_77942_o() ? 0 : stack.func_77978_p().func_74762_e("Damage");
    }

    default public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77951_h();
    }

    default public double getDurabilityForDisplay(ItemStack stack) {
        return (double)stack.func_77952_i() / (double)stack.func_77958_k();
    }

    default public int getRGBDurabilityForDisplay(ItemStack stack) {
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)(1.0 - this.getDurabilityForDisplay(stack))) / 3.0f), (float)1.0f, (float)1.0f);
    }

    default public int getMaxDamage(ItemStack stack) {
        return this.getItem().func_77612_l();
    }

    default public boolean isDamaged(ItemStack stack) {
        return stack.func_77952_i() > 0;
    }

    default public void setDamage(ItemStack stack, int damage) {
        stack.func_196082_o().func_74768_a("Damage", Math.max(0, damage));
    }

    default public boolean canHarvestBlock(ItemStack stack, IBlockState state) {
        return this.getItem().func_150897_b(state);
    }

    default public int getItemStackLimit(ItemStack stack) {
        return this.getItem().func_77639_j();
    }

    public Set<ToolType> getToolTypes(ItemStack var1);

    public int getHarvestLevel(ItemStack var1, ToolType var2, @Nullable EntityPlayer var3, @Nullable IBlockState var4);

    default public int getItemEnchantability(ItemStack stack) {
        return this.getItem().func_77619_b();
    }

    default public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y.func_77557_a(stack.func_77973_b());
    }

    default public boolean isBeaconPayment(ItemStack stack) {
        return this == Items.field_151166_bC || this == Items.field_151045_i || this == Items.field_151043_k || this == Items.field_151042_j;
    }

    default public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.equals(newStack);
    }

    default public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return newStack.func_77973_b() != oldStack.func_77973_b() || !ItemStack.func_77970_a((ItemStack)newStack, (ItemStack)oldStack) || !newStack.func_77984_f() && newStack.func_77952_i() != oldStack.func_77952_i();
    }

    default public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return oldStack.equals(newStack);
    }

    @Nullable
    default public String getCreatorModId(ItemStack itemStack) {
        return ForgeHooks.getDefaultCreatorModId(itemStack);
    }

    @Nullable
    default public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return null;
    }

    default public ImmutableMap<String, ITimeValue> getAnimationParameters(ItemStack stack, World world, EntityLivingBase entity) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.getItem().field_185051_m.forEach((k, v) -> builder.put((Object)k.toString(), input -> v.call(stack, world, entity)));
        return builder.build();
    }

    default public boolean canDisableShield(ItemStack stack, ItemStack shield, EntityLivingBase entity, EntityLivingBase attacker) {
        return this instanceof ItemAxe;
    }

    default public boolean isShield(ItemStack stack, @Nullable EntityLivingBase entity) {
        return stack.func_77973_b() == Items.field_185159_cQ;
    }

    default public int getBurnTime(ItemStack itemStack) {
        return -1;
    }

    default public HorseArmorType getHorseArmorType(ItemStack stack) {
        return HorseArmorType.func_188576_a((Item)stack.func_77973_b());
    }

    default public void onHorseArmorTick(ItemStack stack, World world, EntityLiving horse) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public TileEntityItemStackRenderer getTileEntityItemStackRenderer();
}

