/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client.gui;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.GuiUtilRenderComponents;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.Size2i;
import net.minecraftforge.fml.ForgeI18n;
import net.minecraftforge.fml.MavenVersionStringHelper;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.client.ConfigGuiHandler;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.client.gui.GuiButtonClickConsumer;
import net.minecraftforge.fml.client.gui.GuiSlotModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.fml.packs.ModFileResourcePack;
import net.minecraftforge.fml.packs.ResourcePackLoader;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class GuiModList
extends GuiScreen {
    private static final Logger LOGGER = LogManager.getLogger();
    private GuiScreen mainMenu;
    private GuiSlotModList modList;
    private InfoPanel modInfo;
    private int selected = -1;
    private ModInfo selectedMod;
    private int listWidth;
    private List<ModInfo> mods;
    private final List<ModInfo> unsortedMods;
    private GuiButton configButton;
    private int buttonMargin = 1;
    private int numButtons = SortType.values().length;
    private String lastFilterText = "";
    private GuiTextField search;
    private boolean sorted = false;
    private SortType sortType = SortType.NORMAL;

    public GuiModList(GuiScreen mainMenu) {
        this.mainMenu = mainMenu;
        this.mods = Collections.unmodifiableList(ModList.get().getMods());
        this.unsortedMods = Collections.unmodifiableList(this.mods);
    }

    public void func_73866_w_() {
        for (ModInfo mod : this.mods) {
            this.listWidth = Math.max(this.listWidth, this.getFontRenderer().func_78256_a(mod.getDisplayName()) + 10);
            this.listWidth = Math.max(this.listWidth, this.getFontRenderer().func_78256_a(MavenVersionStringHelper.artifactVersionToString(mod.getVersion())) + 5);
        }
        this.listWidth = Math.min(this.listWidth, 150);
        this.listWidth += this.listWidth % this.numButtons != 0 ? this.numButtons - this.listWidth % this.numButtons : 0;
        this.modList = new GuiSlotModList(this, this.listWidth);
        this.modList.func_148140_g(6);
        this.modInfo = new InfoPanel(this.field_146297_k, this.field_146294_l - this.listWidth - 20, this.field_146295_m, 10, this.field_146295_m - 30, this.field_146295_m - 46);
        this.modInfo.func_148140_g(this.listWidth + 14);
        this.func_189646_b(new GuiButtonClickConsumer(6, (this.modList.field_148151_d + this.field_146294_l) / 2 - 100, this.field_146295_m - 24, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), (x, y) -> this.field_146297_k.func_147108_a(this.mainMenu)));
        this.configButton = new GuiButtonClickConsumer(20, 6, this.field_146295_m - 24, this.listWidth, 20, I18n.func_135052_a((String)"fml.menu.mods.config", (Object[])new Object[0]), (x, y) -> this.displayModConfig());
        this.func_189646_b(this.configButton);
        this.search = new GuiTextField(0, this.getFontRenderer(), 8, this.modList.field_148154_c + 17, this.listWidth - 4, 14);
        this.field_195124_j.add(this.search);
        this.field_195124_j.add(this.modList);
        this.field_195124_j.add(this.modInfo);
        this.search.func_146195_b(true);
        this.search.func_146205_d(true);
        int width = this.listWidth / this.numButtons;
        int x2 = 6;
        int y2 = 10;
        SortType.NORMAL.button = new SortButton(SortType.NORMAL.buttonID, x2, y2, width - this.buttonMargin, 20, SortType.NORMAL);
        this.func_189646_b(SortType.NORMAL.button);
        SortType.A_TO_Z.button = new SortButton(SortType.NORMAL.buttonID, x2 += width + this.buttonMargin, y2, width - this.buttonMargin, 20, SortType.A_TO_Z);
        this.func_189646_b(SortType.A_TO_Z.button);
        SortType.Z_TO_A.button = new SortButton(SortType.NORMAL.buttonID, x2 += width + this.buttonMargin, y2, width - this.buttonMargin, 20, SortType.Z_TO_A);
        this.func_189646_b(SortType.Z_TO_A.button);
        this.resortMods();
        this.updateCache();
    }

    private void displayModConfig() {
        if (this.selectedMod == null) {
            return;
        }
        try {
            ConfigGuiHandler.getGuiFactoryFor(this.selectedMod).map(f -> (GuiScreen)f.apply(this.field_146297_k, this)).ifPresent(newScreen -> this.field_146297_k.func_147108_a(newScreen));
        }
        catch (Exception e) {
            LOGGER.error("There was a critical issue trying to build the config GUI for {}", (Object)this.selectedMod.getModId(), (Object)e);
        }
    }

    public void func_73876_c() {
        this.search.func_146178_a();
        if (!this.search.func_146179_b().equals(this.lastFilterText)) {
            this.reloadMods();
            this.sorted = false;
        }
        if (!this.sorted) {
            this.reloadMods();
            this.mods.sort(this.sortType);
            this.selected = this.mods.indexOf(this.selectedMod);
            this.modList.refreshList();
            this.sorted = true;
        }
    }

    public <T extends GuiListExtended.IGuiListEntry<T>> void buildModList(Consumer<T> modListViewConsumer, Function<ModInfo, T> newEntry) {
        this.mods.forEach(mod -> modListViewConsumer.accept(newEntry.apply((ModInfo)mod)));
    }

    private void reloadMods() {
        this.mods = this.unsortedMods.stream().filter(mi -> net.minecraftforge.fml.loading.StringUtils.toLowerCase((String)StringUtils.func_76338_a((String)mi.getDisplayName())).contains(net.minecraftforge.fml.loading.StringUtils.toLowerCase((String)this.search.func_146179_b()))).collect(Collectors.toList());
        this.lastFilterText = this.search.func_146179_b();
    }

    private void resortMods() {
        for (GuiButton b : this.field_146292_n) {
            if (!(b instanceof SortButton)) continue;
            b.field_146124_l = this.sortType.button != b;
        }
        this.sorted = false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.modList.func_148128_a(mouseX, mouseY, partialTicks);
        this.modInfo.func_148128_a(mouseX, mouseY, partialTicks);
        int left = (this.field_146294_l - this.listWidth - 38) / 2 + this.listWidth + 30;
        String text = I18n.func_135052_a((String)"fml.menu.mods.search", (Object[])new Object[0]);
        int x = (10 + this.modList.field_148151_d) / 2 - this.getFontRenderer().func_78256_a(text) / 2;
        this.getFontRenderer().func_211126_b(text, (float)x, (float)(this.modList.field_148154_c + 5), 0xFFFFFF);
        this.search.func_195608_a(mouseX, mouseY, partialTicks);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    Minecraft getMinecraftInstance() {
        return this.field_146297_k;
    }

    FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public void selectModIndex(int index) {
        this.selected = index == this.selected ? -1 : index;
        this.selectedMod = this.selected >= 0 && this.selected < this.mods.size() ? this.mods.get(this.selected) : null;
        this.updateCache();
    }

    public boolean modIndexSelected(int index) {
        return index == this.selected;
    }

    private void updateCache() {
        if (this.selectedMod == null) {
            this.modInfo.clear();
            return;
        }
        this.configButton.field_146124_l = this.selectedMod.hasConfigUI();
        ArrayList<String> lines = new ArrayList<String>();
        VersionChecker.CheckResult vercheck = VersionChecker.getResult((IModInfo)this.selectedMod);
        Pair logoData = this.selectedMod.getLogoFile().map(logoFile -> {
            TextureManager tm = this.field_146297_k.func_110434_K();
            ModFileResourcePack resourcePack = ResourcePackLoader.getResourcePackFor(this.selectedMod.getModId()).orElse(ResourcePackLoader.getResourcePackFor("forge").orElseThrow(() -> new RuntimeException("Can't find forge, WHAT!")));
            try {
                NativeImage logo = null;
                InputStream logoResource = resourcePack.func_195763_b((String)logoFile);
                if (logoResource != null) {
                    logo = NativeImage.func_195713_a((InputStream)logoResource);
                }
                if (logo != null) {
                    return Pair.of((Object)tm.func_110578_a("modlogo", new DynamicTexture(logo)), (Object)new Size2i(logo.func_195702_a(), logo.func_195714_b()));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return Pair.of(null, (Object)new Size2i(0, 0));
        }).orElse(Pair.of(null, (Object)new Size2i(0, 0)));
        lines.add(this.selectedMod.getDisplayName());
        lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.version", MavenVersionStringHelper.artifactVersionToString(this.selectedMod.getVersion())));
        lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.idstate", this.selectedMod.getModId(), ModList.get().getModContainerById(this.selectedMod.getModId()).map(ModContainer::getCurrentState).map(Object::toString).orElse("NONE")));
        this.selectedMod.getModConfig().getOptional("credits").ifPresent(credits -> lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.credits", credits)));
        this.selectedMod.getModConfig().getOptional("authors").ifPresent(authors -> lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.authors", authors)));
        this.selectedMod.getModConfig().getOptional("displayURL").ifPresent(displayURL -> lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.displayurl", displayURL)));
        if (this.selectedMod.getOwningFile() == null || this.selectedMod.getOwningFile().getMods().size() == 1) {
            lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.nochildmods", new Object[0]));
        } else {
            lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.childmods", this.selectedMod.getOwningFile().getMods().stream().map(IModInfo::getDisplayName).collect(Collectors.joining(","))));
        }
        if (vercheck.status == VersionChecker.Status.OUTDATED || vercheck.status == VersionChecker.Status.BETA_OUTDATED) {
            lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.updateavailable", vercheck.url == null ? "" : vercheck.url));
        }
        lines.add(null);
        lines.add(this.selectedMod.getDescription());
        if ((vercheck.status == VersionChecker.Status.OUTDATED || vercheck.status == VersionChecker.Status.BETA_OUTDATED) && vercheck.changes.size() > 0) {
            lines.add(null);
            lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.changelogheader", new Object[0]));
            for (Map.Entry<ComparableVersion, String> entry : vercheck.changes.entrySet()) {
                lines.add("  " + entry.getKey() + ":");
                lines.add(entry.getValue());
                lines.add(null);
            }
        }
        InfoPanel infoPanel = this.modInfo;
        ((Object)((Object)infoPanel)).getClass();
        this.modInfo.setInfo(infoPanel.new InfoPanel.Info(this.modInfo, lines, (ResourceLocation)logoData.getLeft(), (Size2i)logoData.getRight()));
    }

    class InfoPanel
    extends GuiListExtended<Info> {
        InfoPanel(Minecraft mcIn, int widthIn, int heightIn, int topIn, int bottomIn, int slotHeightIn) {
            super(mcIn, widthIn, heightIn, topIn, bottomIn, slotHeightIn);
        }

        protected int func_148137_d() {
            return this.field_148151_d - 6;
        }

        public int func_148139_c() {
            return this.field_148155_a;
        }

        void setInfo(Info info) {
            this.func_195086_c();
            this.func_195085_a(info);
        }

        public void clear() {
            this.func_195086_c();
        }

        class Info
        extends GuiListExtended.IGuiListEntry<Info> {
            private ResourceLocation logoPath;
            private Size2i logoDims;
            private List<ITextComponent> lines;

            public Info(GuiListExtended<Info> parent, @Nullable List<String> lines, ResourceLocation logoPath, Size2i logoDims) {
                this.field_195004_a = parent;
                this.lines = this.resizeContent(lines);
                this.logoPath = logoPath;
                this.logoDims = logoDims;
            }

            private List<ITextComponent> resizeContent(List<String> lines) {
                ArrayList<ITextComponent> ret = new ArrayList<ITextComponent>();
                for (String line : lines) {
                    if (line == null) {
                        ret.add(null);
                        continue;
                    }
                    ITextComponent chat = ForgeHooks.newChatWithLinks(line, false);
                    int maxTextLength = InfoPanel.this.field_148155_a - 8;
                    if (maxTextLength < 0) continue;
                    ret.addAll(GuiUtilRenderComponents.func_178908_a((ITextComponent)chat, (int)maxTextLength, (FontRenderer)GuiModList.this.field_146289_q, (boolean)false, (boolean)true));
                }
                return ret;
            }

            public void func_194999_a(int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
                int top = this.func_195001_c();
                int left = this.func_195002_d();
                if (this.logoPath != null) {
                    InfoPanel.this.field_148161_k.func_110434_K().func_110577_a(this.logoPath);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    int headerHeight = 50;
                    GuiUtils.drawInscribedRect(left, top, entryWidth - 5, headerHeight, this.logoDims.width, this.logoDims.height, false, true);
                    top += headerHeight;
                }
                for (ITextComponent line : this.lines) {
                    if (line != null) {
                        GlStateManager.func_179147_l();
                        GuiModList.this.field_146289_q.func_175063_a(line.func_150254_d(), (float)(left + 4), (float)top, 0xFFFFFF);
                        GlStateManager.func_179118_c();
                        GlStateManager.func_179084_k();
                    }
                    top += ((GuiModList)GuiModList.this).field_146289_q.field_78288_b;
                }
                ITextComponent component = this.findTextLine(mouseX, mouseY, 0, 0);
                if (component != null) {
                    GuiModList.this.func_175272_a(component, mouseX, mouseY);
                }
            }

            private ITextComponent findTextLine(int mouseX, int mouseY, int offX, int offY) {
                int offset = mouseY - offY;
                if (this.logoPath != null) {
                    offset -= this.logoDims.height + 10;
                }
                if (offset <= 0) {
                    return null;
                }
                int lineIdx = offset / ((GuiModList)GuiModList.this).field_146289_q.field_78288_b;
                if (lineIdx >= this.lines.size() || lineIdx < 1) {
                    return null;
                }
                ITextComponent line = this.lines.get(lineIdx - 1);
                if (line != null) {
                    int k = offX;
                    for (ITextComponent part : line) {
                        if (!(part instanceof TextComponentString) || (k += GuiModList.this.field_146289_q.func_78256_a(((TextComponentString)part).func_150265_g())) < mouseX) continue;
                        return part;
                    }
                }
                return null;
            }

            public boolean mouseClicked(double mouseX, double mouseY, int buttonmask) {
                ITextComponent component = this.findTextLine((int)mouseX, (int)mouseY, InfoPanel.this.field_148152_e, InfoPanel.this.field_148153_b);
                if (component != null) {
                    GuiModList.this.func_175276_a(component);
                    return true;
                }
                return false;
            }
        }
    }

    private class SortButton
    extends GuiButton {
        private final SortType type;

        public SortButton(int buttonId, int x, int y, int width, int height, SortType type) {
            super(buttonId, x, y, width, height, type.getButtonText());
            this.type = type;
        }

        public void func_194829_a(double mouseX, double mouseY) {
            GuiModList.this.sortType = this.type;
            GuiModList.this.resortMods();
        }
    }

    private static enum SortType implements Comparator<ModInfo>
    {
        NORMAL(24),
        A_TO_Z(25){

            @Override
            protected int compare(String name1, String name2) {
                return name1.compareTo(name2);
            }
        }
        ,
        Z_TO_A(26){

            @Override
            protected int compare(String name1, String name2) {
                return name2.compareTo(name1);
            }
        };

        GuiButton button;
        private int buttonID;

        private SortType(int buttonID) {
            this.buttonID = buttonID;
        }

        @Override
        protected int compare(String name1, String name2) {
            return 0;
        }

        @Override
        public int compare(ModInfo o1, ModInfo o2) {
            String name1 = net.minecraftforge.fml.loading.StringUtils.toLowerCase((String)StringUtils.func_76338_a((String)o1.getDisplayName()));
            String name2 = net.minecraftforge.fml.loading.StringUtils.toLowerCase((String)StringUtils.func_76338_a((String)o2.getDisplayName()));
            return this.compare(name1, name2);
        }

        String getButtonText() {
            return I18n.func_135052_a((String)("fml.menu.mods." + net.minecraftforge.fml.loading.StringUtils.toLowerCase((String)this.name())), (Object[])new Object[0]);
        }
    }
}

