/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.progress;

import com.google.common.base.Stopwatch;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.client.SplashProgress;
import net.minecraftforge.fml.common.progress.IProgressBarTracker;
import net.minecraftforge.fml.common.progress.ProgressBar;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.MessageFormatMessage;

class StartupProgressBarTracker
implements IProgressBarTracker {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final List<ProgressBar> bars = new CopyOnWriteArrayList<ProgressBar>();
    private final boolean timeEachStep;
    private final int steps;
    private final Stopwatch stopwatch;
    @Nullable
    private Stopwatch stepStopwatch;
    private String logPrefix = "";

    StartupProgressBarTracker(boolean timeEachStep, int steps) {
        this.timeEachStep = timeEachStep;
        this.steps = steps;
        this.stopwatch = Stopwatch.createUnstarted();
    }

    @Override
    public void onBarCreated(ProgressBar bar) {
        int depth = bars.size();
        this.logPrefix = StringUtils.repeat((String)"        ", (int)depth);
        bars.add(bar);
        DistExecutor.runWhenOn(Dist.CLIENT, () -> SplashProgress::processMessages);
    }

    @Override
    public void onStepStarted(ProgressBar bar, int step, String message) {
        if (step == 1) {
            if (this.steps > 1) {
                LOGGER.debug(Logging.SPLASH, () -> new MessageFormatMessage("{0}Bar Starting: {1}", new Object[]{this.logPrefix, bar.getTitle()}));
                if (this.timeEachStep) {
                    this.stepStopwatch = Stopwatch.createStarted();
                }
            } else {
                LOGGER.debug(Logging.SPLASH, () -> new MessageFormatMessage("{0}Bar Starting: {1} - {2}", new Object[]{this.logPrefix, bar.getTitle(), message}));
            }
            this.stopwatch.start();
        }
        if (this.stepStopwatch != null) {
            LOGGER.debug(Logging.SPLASH, () -> new MessageFormatMessage("{0}    Bar Step: {1} - {2} - starting", new Object[]{this.logPrefix, bar.getTitle(), message}));
            this.stepStopwatch.reset();
            this.stepStopwatch.start();
        }
    }

    @Override
    public void onStepFinished(ProgressBar bar, int step, String message) {
        if (this.stepStopwatch != null) {
            this.stepStopwatch.stop();
            LOGGER.debug(Logging.SPLASH, () -> new MessageFormatMessage("{0}    Bar Step: {1} - {2} - took {3}", new Object[]{this.logPrefix, bar.getTitle(), message, this.stepStopwatch}));
        }
    }

    @Override
    public void onBarFinished(ProgressBar bar, int step, String message) {
        if (this.steps > 0) {
            this.stopwatch.stop();
            bars.remove(bar);
            if (this.steps > 1) {
                LOGGER.debug(Logging.SPLASH, () -> new MessageFormatMessage("{0}Bar Finished: {1} - took {2}", new Object[]{this.logPrefix, bar.getTitle(), this.stopwatch}));
            } else {
                LOGGER.debug(Logging.SPLASH, () -> new MessageFormatMessage("{0}Bar Finished: {1} - {2} - took {3}", new Object[]{this.logPrefix, bar.getTitle(), message, this.stopwatch}));
            }
            DistExecutor.runWhenOn(Dist.CLIENT, () -> SplashProgress::processMessages);
        }
    }

    public static Iterator<ProgressBar> barIterator() {
        return bars.iterator();
    }
}

