/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.network;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.login.client.CPacketCustomPayloadLogin;
import net.minecraft.network.login.server.SPacketCustomPayloadLogin;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.network.play.server.SPacketCustomPayload;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.FMLLoginWrapper;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.unsafe.UnsafeHacks;

public interface ICustomPacket<T extends Packet<?>> {
    default public PacketBuffer getData() {
        return ((Fields)((Object)Fields.lookup.get(this.getClass()))).data.map(f -> (PacketBuffer)UnsafeHacks.getField((Field)f, (Object)this)).orElse(null);
    }

    default public ResourceLocation getName() {
        return ((Fields)((Object)Fields.lookup.get(this.getClass()))).channel.map(f -> (ResourceLocation)UnsafeHacks.getField((Field)f, (Object)this)).orElse(FMLLoginWrapper.WRAPPER);
    }

    default public int getIndex() {
        return ((Fields)((Object)Fields.lookup.get(this.getClass()))).index.map(f -> UnsafeHacks.getIntField((Field)f, (Object)this)).orElse(Integer.MIN_VALUE);
    }

    default public void setData(PacketBuffer buffer) {
        ((Fields)((Object)Fields.lookup.get(this.getClass()))).data.ifPresent(f -> UnsafeHacks.setField((Field)f, (Object)this, (Object)buffer));
    }

    default public void setName(ResourceLocation channelName) {
        ((Fields)((Object)Fields.lookup.get(this.getClass()))).channel.ifPresent(f -> UnsafeHacks.setField((Field)f, (Object)this, (Object)channelName));
    }

    default public void setIndex(int index) {
        ((Fields)((Object)Fields.lookup.get(this.getClass()))).index.ifPresent(f -> UnsafeHacks.setIntField((Field)f, (Object)this, (int)index));
    }

    default public NetworkDirection getDirection() {
        return NetworkDirection.directionFor(this.getClass());
    }

    default public T getThis() {
        return (T)((Packet)this);
    }

    public static enum Fields {
        CPACKETCUSTOMPAYLOAD(CPacketCustomPayload.class),
        SPACKETCUSTOMPAYLOAD(SPacketCustomPayload.class),
        CPACKETCUSTOMLOGIN(CPacketCustomPayloadLogin.class),
        SPACKETCUSTOMLOGIN(SPacketCustomPayloadLogin.class);

        static final Reference2ReferenceArrayMap<Class<?>, Fields> lookup;
        private final Class<?> clazz;
        final Optional<Field> data;
        final Optional<Field> channel;
        final Optional<Field> index;

        private Fields(Class<?> customPacketClass) {
            this.clazz = customPacketClass;
            Field[] fields = customPacketClass.getDeclaredFields();
            this.data = Arrays.stream(fields).filter(f -> !Modifier.isStatic(f.getModifiers()) && f.getType() == PacketBuffer.class).findFirst();
            this.channel = Arrays.stream(fields).filter(f -> !Modifier.isStatic(f.getModifiers()) && f.getType() == ResourceLocation.class).findFirst();
            this.index = Arrays.stream(fields).filter(f -> !Modifier.isStatic(f.getModifiers()) && f.getType() == Integer.TYPE).findFirst();
        }

        private Class<?> getClazz() {
            return this.clazz;
        }

        static {
            lookup = Stream.of(Fields.values()).collect(Collectors.toMap(Fields::getClazz, Function.identity(), (m1, m2) -> m1, Reference2ReferenceArrayMap::new));
        }
    }
}

