/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.command.CommandSource;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentBase;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.SessionLockException;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.WorldWorkerManager;

public class ChunkGenWorker
implements WorldWorkerManager.IWorker {
    private final CommandSource listener;
    protected final BlockPos start;
    protected final int total;
    private final DimensionType dim;
    private final Queue<BlockPos> queue;
    private final int notificationFrequency;
    private int lastNotification = 0;
    private long lastNotifcationTime = 0L;
    private int genned = 0;
    private Boolean keepingLoaded;

    public ChunkGenWorker(CommandSource listener, BlockPos start, int total, DimensionType dim, int interval) {
        this.listener = listener;
        this.start = start;
        this.total = total;
        this.dim = dim;
        this.queue = this.buildQueue();
        this.notificationFrequency = interval != -1 ? interval : Math.max(total / 20, 100);
        this.lastNotifcationTime = System.currentTimeMillis();
    }

    protected Queue<BlockPos> buildQueue() {
        ArrayDeque<BlockPos> ret = new ArrayDeque<BlockPos>();
        ret.add(this.start);
        int radius = 1;
        while (ret.size() < this.total) {
            int q;
            for (q = -radius + 1; q <= radius && ret.size() < this.total; ++q) {
                ret.add(this.start.func_177982_a(radius, 0, q));
            }
            for (q = radius - 1; q >= -radius && ret.size() < this.total; --q) {
                ret.add(this.start.func_177982_a(q, 0, radius));
            }
            for (q = radius - 1; q >= -radius && ret.size() < this.total; --q) {
                ret.add(this.start.func_177982_a(-radius, 0, q));
            }
            for (q = -radius + 1; q <= radius && ret.size() < this.total; ++q) {
                ret.add(this.start.func_177982_a(q, 0, -radius));
            }
            ++radius;
        }
        return ret;
    }

    public TextComponentBase getStartMessage(CommandSource sender) {
        return new TextComponentTranslation("commands.forge.gen.start", new Object[]{this.total, this.start.func_177958_n(), this.start.func_177952_p(), this.dim});
    }

    @Override
    public boolean hasWork() {
        return this.queue.size() > 0;
    }

    @Override
    public boolean doWork() {
        AnvilChunkLoader loader;
        WorldServer world = DimensionManager.getWorld(this.listener.func_197028_i(), this.dim, false, false);
        if (world == null && (world = DimensionManager.initWorld(this.listener.func_197028_i(), this.dim)) == null) {
            this.listener.func_197030_a((ITextComponent)new TextComponentTranslation("commands.forge.gen.dim_fail", new Object[]{this.dim}), true);
            this.queue.clear();
            return false;
        }
        AnvilChunkLoader anvilChunkLoader = loader = world.func_72863_F().field_73247_e instanceof AnvilChunkLoader ? (AnvilChunkLoader)world.func_72863_F().field_73247_e : null;
        if (loader != null && loader.getPendingSaveCount() > 100) {
            if (this.lastNotifcationTime < System.currentTimeMillis() - 10000L) {
                this.listener.func_197030_a((ITextComponent)new TextComponentTranslation("commands.forge.gen.progress", new Object[]{this.total - this.queue.size(), this.total}), true);
                this.lastNotifcationTime = System.currentTimeMillis();
            }
            return false;
        }
        BlockPos next = this.queue.poll();
        if (next != null) {
            if (this.keepingLoaded == null) {
                this.keepingLoaded = DimensionManager.keepLoaded(this.dim, true);
            }
            if (++this.lastNotification >= this.notificationFrequency || this.lastNotifcationTime < System.currentTimeMillis() - 60000L) {
                this.listener.func_197030_a((ITextComponent)new TextComponentTranslation("commands.forge.gen.progress", new Object[]{this.total - this.queue.size(), this.total}), true);
                this.lastNotification = 0;
                this.lastNotifcationTime = System.currentTimeMillis();
            }
            int x = next.func_177958_n();
            int z = next.func_177952_p();
            Chunk target = world.func_72964_e(x, z);
            Chunk[] chunks = new Chunk[]{target};
            if (!target.func_150802_k()) {
                chunks = new Chunk[]{target, world.func_72964_e(x + 1, z), world.func_72964_e(x + 1, z + 1), world.func_72964_e(x, z + 1)};
                try {
                    world.func_72863_F().field_73247_e.func_75816_a((World)world, (IChunk)target);
                }
                catch (IOException | SessionLockException e) {
                    this.listener.func_197030_a((ITextComponent)new TextComponentTranslation("commands.forge.gen.saveerror", new Object[]{e.getMessage()}), true);
                }
                ++this.genned;
            }
            for (Chunk chunk : chunks) {
                PlayerChunkMapEntry watchers = world.func_184164_w().func_187301_b(chunk.field_76635_g, chunk.field_76647_h);
                if (watchers != null) continue;
                world.func_72863_F().func_189549_a(chunk);
            }
        }
        if (this.queue.size() == 0) {
            this.listener.func_197030_a((ITextComponent)new TextComponentTranslation("commands.forge.gen.complete", new Object[]{this.genned, this.total, this.dim}), true);
            if (this.keepingLoaded != null && !this.keepingLoaded.booleanValue()) {
                DimensionManager.keepLoaded(this.dim, false);
            }
            return false;
        }
        return true;
    }
}

