/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.minecart.ContainerMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.RepairContainer;
import net.minecraft.item.AxeItem;
import net.minecraft.item.BucketItem;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.PotionItem;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.item.TippedArrowItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.stats.Stats;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IntIdentityHashBiMap;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.spawner.AbstractSpawner;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.DifficultyChangeEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.DataSerializerEntry;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.GameData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.util.TriConsumer;

public class ForgeHooks {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker FORGEHOOKS = MarkerManager.getMarker((String)"FORGEHOOKS");
    private static boolean toolInit = false;
    static final Pattern URL_PATTERN = Pattern.compile("((?:[a-z0-9]{2,}:\\/\\/)?(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}|(?:[-\\w_]{1,}\\.[a-z]{2,}?))(?::[0-9]{1,5})?.*?(?=[!\"\u00a7 \n]|$))", 2);
    private static ThreadLocal<PlayerEntity> craftingPlayer = new ThreadLocal();
    private static ThreadLocal<Deque<LootTableContext>> lootContext = new ThreadLocal();
    private static TriConsumer<Block, ToolType, Integer> blockToolSetter;
    private static final DummyBlockReader DUMMY_WORLD;
    private static final Map<IDataSerializer<?>, DataSerializerEntry> serializerEntries;

    public static boolean canContinueUsing(@Nonnull ItemStack from, @Nonnull ItemStack to) {
        if (!from.func_190926_b() && !to.func_190926_b()) {
            return from.func_77973_b().canContinueUsing(from, to);
        }
        return false;
    }

    public static boolean canHarvestBlock(@Nonnull BlockState state, @Nonnull PlayerEntity player, @Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        if (state.func_185904_a().func_76229_l()) {
            return true;
        }
        ItemStack stack = player.func_184614_ca();
        ToolType tool = state.getHarvestTool();
        if (stack.func_190926_b() || tool == null) {
            return player.func_184823_b(state);
        }
        int toolLevel = stack.func_77973_b().getHarvestLevel(stack, tool, player, state);
        if (toolLevel < 0) {
            return player.func_184823_b(state);
        }
        return toolLevel >= state.getHarvestLevel();
    }

    public static boolean canToolHarvestBlock(IWorldReader world, BlockPos pos, @Nonnull ItemStack stack) {
        BlockState state = world.func_180495_p(pos);
        ToolType tool = state.getHarvestTool();
        if (stack.func_190926_b() || tool == null) {
            return false;
        }
        return stack.getHarvestLevel(tool, null, null) >= state.getHarvestLevel();
    }

    public static boolean isToolEffective(IWorldReader world, BlockPos pos, @Nonnull ItemStack stack) {
        BlockState state = world.func_180495_p(pos);
        for (ToolType type : stack.getToolTypes()) {
            if (!state.isToolEffective(type)) continue;
            return true;
        }
        return false;
    }

    static void initTools() {
        if (toolInit) {
            return;
        }
        toolInit = true;
        Set blocks = (Set)ForgeHooks.getPrivateValue(PickaxeItem.class, null, 0);
        blocks.forEach(block -> blockToolSetter.accept(block, (Object)ToolType.PICKAXE, (Object)0));
        blocks = (Set)ForgeHooks.getPrivateValue(ShovelItem.class, null, 0);
        blocks.forEach(block -> blockToolSetter.accept(block, (Object)ToolType.SHOVEL, (Object)0));
        blocks = (Set)ForgeHooks.getPrivateValue(AxeItem.class, null, 0);
        blocks.forEach(block -> blockToolSetter.accept(block, (Object)ToolType.AXE, (Object)0));
        blockToolSetter.accept((Object)Blocks.field_150343_Z, (Object)ToolType.PICKAXE, (Object)3);
        for (Block block2 : new Block[]{Blocks.field_150484_ah, Blocks.field_150482_ag, Blocks.field_150412_bA, Blocks.field_150475_bE, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_150450_ax}) {
            blockToolSetter.accept((Object)block2, (Object)ToolType.PICKAXE, (Object)2);
        }
        for (Block block2 : new Block[]{Blocks.field_150339_S, Blocks.field_150366_p, Blocks.field_150368_y, Blocks.field_150369_x}) {
            blockToolSetter.accept((Object)block2, (Object)ToolType.PICKAXE, (Object)1);
        }
    }

    public static boolean onPickBlock(RayTraceResult target, PlayerEntity player, World world) {
        Entity entity;
        ItemStack result = ItemStack.field_190927_a;
        boolean isCreative = player.field_71075_bZ.field_75098_d;
        TileEntity te = null;
        if (target.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos pos = ((BlockRayTraceResult)target).func_216350_a();
            BlockState state = world.func_180495_p(pos);
            if (state.isAir((IBlockReader)world, pos)) {
                return false;
            }
            if (isCreative && Screen.hasControlDown() && state.hasTileEntity()) {
                te = world.func_175625_s(pos);
            }
            if ((result = state.func_177230_c().getPickBlock(state, target, (IBlockReader)world, pos, player)).func_190926_b()) {
                LOGGER.warn("Picking on: [{}] {} gave null item", (Object)target.func_216346_c(), (Object)state.func_177230_c().getRegistryName());
            }
        } else if (target.func_216346_c() == RayTraceResult.Type.ENTITY && (result = (entity = ((EntityRayTraceResult)target).func_216348_a()).getPickedResult(target)).func_190926_b()) {
            LOGGER.warn("Picking on: [{}] {} gave null item", (Object)target.func_216346_c(), (Object)entity.func_200600_R().getRegistryName());
        }
        if (result.func_190926_b()) {
            return false;
        }
        if (te != null) {
            Minecraft.func_71410_x().func_184119_a(result, te);
        }
        if (isCreative) {
            player.field_71071_by.func_184434_a(result);
            Minecraft.func_71410_x().field_71442_b.func_78761_a(player.func_184586_b(Hand.MAIN_HAND), 36 + player.field_71071_by.field_70461_c);
            return true;
        }
        int slot = player.field_71071_by.func_184429_b(result);
        if (slot != -1) {
            if (PlayerInventory.func_184435_e((int)slot)) {
                player.field_71071_by.field_70461_c = slot;
            } else {
                Minecraft.func_71410_x().field_71442_b.func_187100_a(slot);
            }
            return true;
        }
        return false;
    }

    public static void onDifficultyChange(Difficulty difficulty, Difficulty oldDifficulty) {
        MinecraftForge.EVENT_BUS.post((Event)new DifficultyChangeEvent(difficulty, oldDifficulty));
    }

    public static void onLivingSetAttackTarget(LivingEntity entity, LivingEntity target) {
        MinecraftForge.EVENT_BUS.post((Event)new LivingSetAttackTargetEvent(entity, target));
    }

    public static boolean onLivingUpdate(LivingEntity entity) {
        return MinecraftForge.EVENT_BUS.post((Event)new LivingEvent.LivingUpdateEvent(entity));
    }

    public static boolean onLivingAttack(LivingEntity entity, DamageSource src, float amount) {
        return entity instanceof PlayerEntity || !MinecraftForge.EVENT_BUS.post((Event)new LivingAttackEvent(entity, src, amount));
    }

    public static boolean onPlayerAttack(LivingEntity entity, DamageSource src, float amount) {
        return !MinecraftForge.EVENT_BUS.post((Event)new LivingAttackEvent(entity, src, amount));
    }

    public static LivingKnockBackEvent onLivingKnockBack(LivingEntity target, Entity attacker, float strength, double ratioX, double ratioZ) {
        LivingKnockBackEvent event = new LivingKnockBackEvent(target, attacker, strength, ratioX, ratioZ);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static float onLivingHurt(LivingEntity entity, DamageSource src, float amount) {
        LivingHurtEvent event = new LivingHurtEvent(entity, src, amount);
        return MinecraftForge.EVENT_BUS.post((Event)event) ? 0.0f : event.getAmount();
    }

    public static float onLivingDamage(LivingEntity entity, DamageSource src, float amount) {
        LivingDamageEvent event = new LivingDamageEvent(entity, src, amount);
        return MinecraftForge.EVENT_BUS.post((Event)event) ? 0.0f : event.getAmount();
    }

    public static boolean onLivingDeath(LivingEntity entity, DamageSource src) {
        return MinecraftForge.EVENT_BUS.post((Event)new LivingDeathEvent(entity, src));
    }

    public static boolean onLivingDrops(LivingEntity entity, DamageSource source, Collection<ItemEntity> drops, int lootingLevel, boolean recentlyHit) {
        return MinecraftForge.EVENT_BUS.post((Event)new LivingDropsEvent(entity, source, drops, lootingLevel, recentlyHit));
    }

    @Nullable
    public static float[] onLivingFall(LivingEntity entity, float distance, float damageMultiplier) {
        float[] fArray;
        LivingFallEvent event = new LivingFallEvent(entity, distance, damageMultiplier);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            fArray = null;
        } else {
            float[] fArray2 = new float[2];
            fArray2[0] = event.getDistance();
            fArray = fArray2;
            fArray2[1] = event.getDamageMultiplier();
        }
        return fArray;
    }

    public static int getLootingLevel(Entity target, @Nullable Entity killer, DamageSource cause) {
        int looting = 0;
        if (killer instanceof LivingEntity) {
            looting = EnchantmentHelper.func_185283_h((LivingEntity)((LivingEntity)killer));
        }
        if (target instanceof LivingEntity) {
            looting = ForgeHooks.getLootingLevel((LivingEntity)target, cause, looting);
        }
        return looting;
    }

    public static int getLootingLevel(LivingEntity target, DamageSource cause, int level) {
        LootingLevelEvent event = new LootingLevelEvent(target, cause, level);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getLootingLevel();
    }

    public static double getPlayerVisibilityDistance(PlayerEntity player, double xzDistance, double maxXZDistance) {
        PlayerEvent.Visibility event = new PlayerEvent.Visibility(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        double value = event.getVisibilityModifier() * xzDistance;
        return value >= maxXZDistance ? maxXZDistance : value;
    }

    public static boolean isLivingOnLadder(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull LivingEntity entity) {
        boolean isSpectator;
        boolean bl = isSpectator = entity instanceof PlayerEntity && ((PlayerEntity)entity).func_175149_v();
        if (isSpectator) {
            return false;
        }
        if (!((Boolean)ForgeConfig.SERVER.fullBoundingBoxLadders.get()).booleanValue()) {
            return state.isLadder((IWorldReader)world, pos, entity);
        }
        AxisAlignedBB bb = entity.func_174813_aQ();
        int mX = MathHelper.func_76128_c((double)bb.field_72340_a);
        int mY = MathHelper.func_76128_c((double)bb.field_72338_b);
        int mZ = MathHelper.func_76128_c((double)bb.field_72339_c);
        int y2 = mY;
        while ((double)y2 < bb.field_72337_e) {
            int x2 = mX;
            while ((double)x2 < bb.field_72336_d) {
                int z2 = mZ;
                while ((double)z2 < bb.field_72334_f) {
                    BlockPos tmp = new BlockPos(x2, y2, z2);
                    state = world.func_180495_p(tmp);
                    if (state.isLadder((IWorldReader)world, tmp, entity)) {
                        return true;
                    }
                    ++z2;
                }
                ++x2;
            }
            ++y2;
        }
        return false;
    }

    public static void onLivingJump(LivingEntity entity) {
        MinecraftForge.EVENT_BUS.post((Event)new LivingEvent.LivingJumpEvent(entity));
    }

    @Nullable
    public static ItemEntity onPlayerTossEvent(@Nonnull PlayerEntity player, @Nonnull ItemStack item, boolean includeName) {
        player.captureDrops((Collection)Lists.newArrayList());
        ItemEntity ret = player.func_146097_a(item, false, includeName);
        player.captureDrops(null);
        if (ret == null) {
            return null;
        }
        ItemTossEvent event = new ItemTossEvent(ret, player);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return null;
        }
        if (!player.field_70170_p.field_72995_K) {
            player.func_130014_f_().func_217376_c((Entity)event.getEntityItem());
        }
        return event.getEntityItem();
    }

    @Nullable
    public static ITextComponent onServerChatEvent(ServerPlayNetHandler net, String raw, ITextComponent comp) {
        ServerChatEvent event = new ServerChatEvent(net.field_147369_b, raw, comp);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return null;
        }
        return event.getComponent();
    }

    public static ITextComponent newChatWithLinks(String string) {
        return ForgeHooks.newChatWithLinks(string, true);
    }

    public static ITextComponent newChatWithLinks(String string, boolean allowMissingHeader) {
        StringTextComponent ichat = null;
        Matcher matcher = URL_PATTERN.matcher(string);
        int lastEnd = 0;
        while (matcher.find()) {
            StringTextComponent link;
            String url;
            block13: {
                int start = matcher.start();
                int end = matcher.end();
                String part = string.substring(lastEnd, start);
                if (part.length() > 0) {
                    if (ichat == null) {
                        ichat = new StringTextComponent(part);
                    } else {
                        ichat.func_150258_a(part);
                    }
                }
                lastEnd = end;
                url = string.substring(start, end);
                link = new StringTextComponent(url);
                try {
                    if (new URI(url).getScheme() != null) break block13;
                    if (!allowMissingHeader) {
                        if (ichat == null) {
                            ichat = new StringTextComponent(url);
                            continue;
                        }
                        ichat.func_150258_a(url);
                        continue;
                    }
                    url = "http://" + url;
                }
                catch (URISyntaxException e) {
                    if (ichat == null) {
                        ichat = new StringTextComponent(url);
                        continue;
                    }
                    ichat.func_150258_a(url);
                    continue;
                }
            }
            ClickEvent click = new ClickEvent(ClickEvent.Action.OPEN_URL, url);
            link.func_150256_b().func_150241_a(click);
            link.func_150256_b().func_150228_d(Boolean.valueOf(true));
            link.func_150256_b().func_150238_a(TextFormatting.BLUE);
            if (ichat == null) {
                ichat = new StringTextComponent("");
            }
            ichat.func_150257_a((ITextComponent)link);
        }
        String end = string.substring(lastEnd);
        if (ichat == null) {
            ichat = new StringTextComponent(end);
        } else if (end.length() > 0) {
            ichat.func_150258_a(string.substring(lastEnd));
        }
        return ichat;
    }

    public static int onBlockBreakEvent(World world, GameType gameType, ServerPlayerEntity entityPlayer, BlockPos pos) {
        boolean preCancelEvent = false;
        ItemStack itemstack = entityPlayer.func_184614_ca();
        if (gameType.func_77145_d() && !itemstack.func_190926_b() && !itemstack.func_77973_b().func_195938_a(world.func_180495_p(pos), world, pos, (PlayerEntity)entityPlayer)) {
            preCancelEvent = true;
        }
        if (gameType.func_82752_c()) {
            if (gameType == GameType.SPECTATOR) {
                preCancelEvent = true;
            }
            if (!(entityPlayer.func_175142_cm() || !itemstack.func_190926_b() && itemstack.func_206848_a(world.func_205772_D(), new CachedBlockInfo((IWorldReader)world, pos, false)))) {
                preCancelEvent = true;
            }
        }
        if (world.func_175625_s(pos) == null) {
            entityPlayer.field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)DUMMY_WORLD, pos));
        }
        BlockState state = world.func_180495_p(pos);
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, (PlayerEntity)entityPlayer);
        event.setCanceled(preCancelEvent);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            SUpdateTileEntityPacket pkt;
            entityPlayer.field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)world, pos));
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity != null && (pkt = tileentity.func_189518_D_()) != null) {
                entityPlayer.field_71135_a.func_147359_a((IPacket)pkt);
            }
        }
        return event.isCanceled() ? -1 : event.getExpToDrop();
    }

    public static ActionResultType onPlaceItemIntoWorld(@Nonnull ItemUseContext context) {
        ItemStack itemstack = context.func_195996_i();
        World world = context.func_195991_k();
        int size = itemstack.func_190916_E();
        CompoundNBT nbt = null;
        if (itemstack.func_77978_p() != null) {
            nbt = itemstack.func_77978_p().func_74737_b();
        }
        if (!(itemstack.func_77973_b() instanceof BucketItem)) {
            world.captureBlockSnapshots = true;
        }
        ActionResultType ret = itemstack.func_77973_b().func_195939_a(context);
        world.captureBlockSnapshots = false;
        if (ret == ActionResultType.SUCCESS) {
            int newSize = itemstack.func_190916_E();
            CompoundNBT newNBT = null;
            if (itemstack.func_77978_p() != null) {
                newNBT = itemstack.func_77978_p().func_74737_b();
            }
            List blockSnapshots = (List)world.capturedBlockSnapshots.clone();
            world.capturedBlockSnapshots.clear();
            itemstack.func_190920_e(size);
            itemstack.func_77982_d(nbt);
            PlayerEntity player = context.func_195999_j();
            Direction side = context.func_196000_l();
            boolean eventResult = false;
            if (blockSnapshots.size() > 1) {
                eventResult = ForgeEventFactory.onMultiBlockPlace((Entity)player, blockSnapshots, side);
            } else if (blockSnapshots.size() == 1) {
                eventResult = ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)blockSnapshots.get(0), side);
            }
            if (eventResult) {
                ret = ActionResultType.FAIL;
                for (BlockSnapshot blocksnapshot : Lists.reverse((List)blockSnapshots)) {
                    world.restoringBlockSnapshots = true;
                    blocksnapshot.restore(true, false);
                    world.restoringBlockSnapshots = false;
                }
            } else {
                itemstack.func_190920_e(newSize);
                itemstack.func_77982_d(newNBT);
                for (BlockSnapshot snap : blockSnapshots) {
                    int updateFlag = snap.getFlag();
                    BlockState oldBlock = snap.getReplacedBlock();
                    BlockState newBlock = world.func_180495_p(snap.getPos());
                    if (!newBlock.func_177230_c().hasTileEntity(newBlock)) {
                        newBlock.func_215705_a(world, snap.getPos(), oldBlock, false);
                    }
                    world.markAndNotifyBlock(snap.getPos(), null, oldBlock, newBlock, updateFlag);
                }
                player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)itemstack.func_77973_b()));
            }
        }
        world.capturedBlockSnapshots.clear();
        return ret;
    }

    public static boolean onAnvilChange(RepairContainer container, @Nonnull ItemStack left, @Nonnull ItemStack right, IInventory outputSlot, String name, int baseCost) {
        AnvilUpdateEvent e = new AnvilUpdateEvent(left, right, name, baseCost);
        if (MinecraftForge.EVENT_BUS.post((Event)e)) {
            return false;
        }
        if (e.getOutput().func_190926_b()) {
            return true;
        }
        outputSlot.func_70299_a(0, e.getOutput());
        container.setMaximumCost(e.getCost());
        container.field_82856_l = e.getMaterialCost();
        return false;
    }

    public static float onAnvilRepair(PlayerEntity player, @Nonnull ItemStack output, @Nonnull ItemStack left, @Nonnull ItemStack right) {
        AnvilRepairEvent e = new AnvilRepairEvent(player, left, right, output);
        MinecraftForge.EVENT_BUS.post((Event)e);
        return e.getBreakChance();
    }

    public static void setCraftingPlayer(PlayerEntity player) {
        craftingPlayer.set(player);
    }

    public static PlayerEntity getCraftingPlayer() {
        return craftingPlayer.get();
    }

    @Nonnull
    public static ItemStack getContainerItem(@Nonnull ItemStack stack) {
        if (stack.func_77973_b().hasContainerItem(stack)) {
            if (!(stack = stack.func_77973_b().getContainerItem(stack)).func_190926_b() && stack.func_77984_f() && stack.func_77952_i() > stack.func_77958_k()) {
                ForgeEventFactory.onPlayerDestroyItem(craftingPlayer.get(), stack, null);
                return ItemStack.field_190927_a;
            }
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean onPlayerAttackTarget(PlayerEntity player, Entity target) {
        if (MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent(player, target))) {
            return false;
        }
        ItemStack stack = player.func_184614_ca();
        return stack.func_190926_b() || !stack.func_77973_b().onLeftClickEntity(stack, player, target);
    }

    public static boolean onTravelToDimension(Entity entity, DimensionType dimension) {
        EntityTravelToDimensionEvent event = new EntityTravelToDimensionEvent(entity, dimension);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled() && entity instanceof ContainerMinecartEntity) {
            ((ContainerMinecartEntity)entity).dropContentsWhenDead(true);
        }
        return !event.isCanceled();
    }

    public static ActionResultType onInteractEntityAt(PlayerEntity player, Entity entity, RayTraceResult ray, Hand hand) {
        Vec3d vec3d = new Vec3d(ray.func_216347_e().field_72450_a - entity.field_70165_t, ray.func_216347_e().field_72448_b - entity.field_70163_u, ray.func_216347_e().field_72449_c - entity.field_70161_v);
        return ForgeHooks.onInteractEntityAt(player, entity, vec3d, hand);
    }

    public static ActionResultType onInteractEntityAt(PlayerEntity player, Entity entity, Vec3d vec3d, Hand hand) {
        PlayerInteractEvent.EntityInteractSpecific evt = new PlayerInteractEvent.EntityInteractSpecific(player, hand, entity, vec3d);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt.isCanceled() ? evt.getCancellationResult() : null;
    }

    public static ActionResultType onInteractEntity(PlayerEntity player, Entity entity, Hand hand) {
        PlayerInteractEvent.EntityInteract evt = new PlayerInteractEvent.EntityInteract(player, hand, entity);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt.isCanceled() ? evt.getCancellationResult() : null;
    }

    public static ActionResultType onItemRightClick(PlayerEntity player, Hand hand) {
        PlayerInteractEvent.RightClickItem evt = new PlayerInteractEvent.RightClickItem(player, hand);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt.isCanceled() ? evt.getCancellationResult() : null;
    }

    public static PlayerInteractEvent.LeftClickBlock onLeftClickBlock(PlayerEntity player, BlockPos pos, Direction face) {
        PlayerInteractEvent.LeftClickBlock evt = new PlayerInteractEvent.LeftClickBlock(player, pos, face);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt;
    }

    public static PlayerInteractEvent.RightClickBlock onRightClickBlock(PlayerEntity player, Hand hand, BlockPos pos, Direction face) {
        PlayerInteractEvent.RightClickBlock evt = new PlayerInteractEvent.RightClickBlock(player, hand, pos, face);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt;
    }

    public static void onEmptyClick(PlayerEntity player, Hand hand) {
        MinecraftForge.EVENT_BUS.post((Event)new PlayerInteractEvent.RightClickEmpty(player, hand));
    }

    public static void onEmptyLeftClick(PlayerEntity player) {
        MinecraftForge.EVENT_BUS.post((Event)new PlayerInteractEvent.LeftClickEmpty(player));
    }

    private static LootTableContext getLootTableContext() {
        LootTableContext ctx = lootContext.get().peek();
        if (ctx == null) {
            throw new JsonParseException("Invalid call stack, could not grab json context!");
        }
        return ctx;
    }

    @Nullable
    public static LootTable loadLootTable(Gson gson, ResourceLocation name, JsonObject data, boolean custom, LootTableManager lootTableManager) {
        ArrayDeque que = lootContext.get();
        if (que == null) {
            que = Queues.newArrayDeque();
            lootContext.set(que);
        }
        LootTable ret = null;
        try {
            que.push(new LootTableContext(name, custom));
            ret = (LootTable)gson.fromJson((JsonElement)data, LootTable.class);
            que.pop();
        }
        catch (JsonParseException e) {
            que.pop();
            throw e;
        }
        if (!custom) {
            ret = ForgeEventFactory.loadLootTable(name, ret, lootTableManager);
        }
        if (ret != null) {
            ret.freeze();
        }
        return ret;
    }

    public static String readPoolName(JsonObject json) {
        LootTableContext ctx = ForgeHooks.getLootTableContext();
        ctx.resetPoolCtx();
        if (json.has("name")) {
            return JSONUtils.func_151200_h((JsonObject)json, (String)"name");
        }
        if (ctx.custom) {
            return "custom#" + json.hashCode();
        }
        ++ctx.poolCount;
        if (!ctx.vanilla) {
            throw new JsonParseException("Loot Table \"" + ctx.name.toString() + "\" Missing `name` entry for pool #" + (ctx.poolCount - 1));
        }
        return ctx.poolCount == 1 ? "main" : "pool" + (ctx.poolCount - 1);
    }

    public static String readLootEntryName(JsonObject json, String type) {
        LootTableContext ctx = ForgeHooks.getLootTableContext();
        ++ctx.entryCount;
        if (json.has("entryName")) {
            return ctx.validateEntryName(JSONUtils.func_151200_h((JsonObject)json, (String)"entryName"));
        }
        if (ctx.custom) {
            return "custom#" + json.hashCode();
        }
        String name = null;
        if ("item".equals(type)) {
            name = JSONUtils.func_151200_h((JsonObject)json, (String)"name");
        } else if ("loot_table".equals(type)) {
            name = JSONUtils.func_151200_h((JsonObject)json, (String)"name");
        } else if ("empty".equals(type)) {
            name = "empty";
        }
        return ctx.validateEntryName(name);
    }

    public static boolean onCropsGrowPre(World worldIn, BlockPos pos, BlockState state, boolean def) {
        BlockEvent.CropGrowEvent.Pre ev = new BlockEvent.CropGrowEvent.Pre(worldIn, pos, state);
        MinecraftForge.EVENT_BUS.post((Event)ev);
        return ev.getResult() == Event.Result.ALLOW || ev.getResult() == Event.Result.DEFAULT && def;
    }

    public static void onCropsGrowPost(World worldIn, BlockPos pos, BlockState state) {
        MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.CropGrowEvent.Post(worldIn, pos, state, worldIn.func_180495_p(pos)));
    }

    @Nullable
    public static CriticalHitEvent getCriticalHit(PlayerEntity player, Entity target, boolean vanillaCritical, float damageModifier) {
        CriticalHitEvent hitResult = new CriticalHitEvent(player, target, damageModifier, vanillaCritical);
        MinecraftForge.EVENT_BUS.post((Event)hitResult);
        if (hitResult.getResult() == Event.Result.ALLOW || vanillaCritical && hitResult.getResult() == Event.Result.DEFAULT) {
            return hitResult;
        }
        return null;
    }

    public static void onAdvancement(ServerPlayerEntity player, Advancement advancement) {
        MinecraftForge.EVENT_BUS.post((Event)new AdvancementEvent((PlayerEntity)player, advancement));
    }

    @Nullable
    public static String getDefaultCreatorModId(@Nonnull ItemStack itemStack) {
        String modId;
        Item item = itemStack.func_77973_b();
        ResourceLocation registryName = item.getRegistryName();
        String string = modId = registryName == null ? null : registryName.func_110624_b();
        if ("minecraft".equals(modId)) {
            ResourceLocation resourceLocation;
            if (item instanceof EnchantedBookItem) {
                CompoundNBT nbttagcompound;
                ResourceLocation resourceLocation2;
                ListNBT enchantmentsNbt = EnchantedBookItem.func_92110_g((ItemStack)itemStack);
                if (enchantmentsNbt.size() == 1 && (resourceLocation2 = ResourceLocation.func_208304_a((String)(nbttagcompound = enchantmentsNbt.func_150305_b(0)).func_74779_i("id"))) != null && ForgeRegistries.ENCHANTMENTS.containsKey(resourceLocation2)) {
                    return resourceLocation2.func_110624_b();
                }
            } else if (item instanceof PotionItem || item instanceof TippedArrowItem) {
                Potion potionType = PotionUtils.func_185191_c((ItemStack)itemStack);
                ResourceLocation resourceLocation3 = ForgeRegistries.POTION_TYPES.getKey(potionType);
                if (resourceLocation3 != null) {
                    return resourceLocation3.func_110624_b();
                }
            } else if (item instanceof SpawnEggItem && (resourceLocation = ((SpawnEggItem)item).func_208076_b(null).getRegistryName()) != null) {
                return resourceLocation.func_110624_b();
            }
        }
        return modId;
    }

    public static boolean onFarmlandTrample(World world, BlockPos pos, BlockState state, float fallDistance, Entity entity) {
        if (entity.canTrample(state, pos, fallDistance)) {
            BlockEvent.FarmlandTrampleEvent event = new BlockEvent.FarmlandTrampleEvent(world, pos, state, fallDistance, entity);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return !event.isCanceled();
        }
        return false;
    }

    public static void setBlockToolSetter(TriConsumer<Block, ToolType, Integer> setter) {
        blockToolSetter = setter;
    }

    private static <T, E> T getPrivateValue(Class<? super E> classToAccess, @Nullable E instance, int fieldIndex) {
        try {
            Field f = classToAccess.getDeclaredFields()[fieldIndex];
            f.setAccessible(true);
            return (T)f.get(instance);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static int onNoteChange(World world, BlockPos pos, BlockState state, int old, int _new) {
        NoteBlockEvent.Change event = new NoteBlockEvent.Change(world, pos, state, old, _new);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return -1;
        }
        return event.getVanillaNoteId();
    }

    public static int canEntitySpawn(MobEntity entity, IWorld world, double x, double y, double z, AbstractSpawner spawner) {
        Event.Result res = ForgeEventFactory.canEntitySpawn(entity, world, x, y, z, null);
        return res == Event.Result.DEFAULT ? 0 : (res == Event.Result.DENY ? -1 : 1);
    }

    /*
     * Exception decompiling
     */
    public static <T> void deserializeTagAdditions(Tag.Builder<T> builder, Function<ResourceLocation, Optional<T>> valueGetter, JsonObject json) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.getBindingFor(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "res" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer.getGtbNullFiltered(GenericInferer.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer.inferGenericObjectInfoFromCalls(GenericInferer.java:139)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:484)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    public static IDataSerializer<?> getSerializer(int id, IntIdentityHashBiMap<IDataSerializer<?>> vanilla) {
        DataSerializerEntry entry;
        IDataSerializer<?> serializer = (IDataSerializer<?>)vanilla.func_148745_a(id);
        if (serializer == null && (entry = (DataSerializerEntry)((ForgeRegistry)ForgeRegistries.DATA_SERIALIZERS).getValue(id)) != null) {
            serializer = entry.getSerializer();
        }
        return serializer;
    }

    public static int getSerializerId(IDataSerializer<?> serializer, IntIdentityHashBiMap<IDataSerializer<?>> vanilla) {
        DataSerializerEntry entry;
        int id = vanilla.func_186815_a(serializer);
        if (id < 0 && (entry = serializerEntries.get(serializer)) != null) {
            id = ((ForgeRegistry)ForgeRegistries.DATA_SERIALIZERS).getID(entry);
        }
        return id;
    }

    public static boolean canEntityDestroy(World world, BlockPos pos, LivingEntity entity) {
        BlockState state = world.func_180495_p(pos);
        return ForgeEventFactory.getMobGriefingEvent(world, (Entity)entity) && state.canEntityDestroy((IBlockReader)world, pos, (Entity)entity) && ForgeEventFactory.onEntityDestroyBlock(entity, pos, state);
    }

    static {
        DUMMY_WORLD = new DummyBlockReader();
        serializerEntries = GameData.getSerializerMap();
    }

    private static class OptionalTagEntry<T>
    extends Tag.TagEntry<T> {
        private Tag<T> resolvedTag = null;

        OptionalTagEntry(ResourceLocation referent) {
            super(referent);
        }

        public boolean func_200161_a(@Nonnull Function<ResourceLocation, Tag<T>> resolver) {
            if (this.resolvedTag == null) {
                this.resolvedTag = resolver.apply(this.func_200577_a());
            }
            return true;
        }

        public void func_200162_a(@Nonnull Collection<T> items) {
            if (this.resolvedTag != null) {
                items.addAll(this.resolvedTag.func_199885_a());
            }
        }
    }

    private static class DummyBlockReader
    implements IBlockReader {
        private DummyBlockReader() {
        }

        public TileEntity func_175625_s(BlockPos pos) {
            return null;
        }

        public BlockState func_180495_p(BlockPos pos) {
            return Blocks.field_150350_a.func_176223_P();
        }

        public IFluidState func_204610_c(BlockPos pos) {
            return Fluids.field_204541_a.func_207188_f();
        }
    }

    private static class LootTableContext {
        public final ResourceLocation name;
        private final boolean vanilla;
        public final boolean custom;
        public int poolCount = 0;
        public int entryCount = 0;
        private HashSet<String> entryNames = Sets.newHashSet();

        private LootTableContext(ResourceLocation name, boolean custom) {
            this.name = name;
            this.custom = custom;
            this.vanilla = "minecraft".equals(this.name.func_110624_b());
        }

        private void resetPoolCtx() {
            this.entryCount = 0;
            this.entryNames.clear();
        }

        public String validateEntryName(@Nullable String name) {
            if (name != null && !this.entryNames.contains(name)) {
                this.entryNames.add(name);
                return name;
            }
            if (!this.vanilla) {
                throw new JsonParseException("Loot Table \"" + this.name.toString() + "\" Duplicate entry name \"" + name + "\" for pool #" + (this.poolCount - 1) + " entry #" + (this.entryCount - 1));
            }
            int x = 0;
            while (this.entryNames.contains(name + "#" + x)) {
                ++x;
            }
            name = name + "#" + x;
            this.entryNames.add(name);
            return name;
        }
    }
}

