/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.registries.IRegistryDelegate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FluidStack {
    private static final Logger LOGGER = LogManager.getLogger();
    public int amount;
    public CompoundNBT tag;
    private IRegistryDelegate<Fluid> fluidDelegate;

    public FluidStack(Fluid fluid, int amount) {
        if (fluid == null) {
            LOGGER.fatal("Null fluid supplied to fluidstack. Did you try and create a stack for an unregistered fluid?");
            throw new IllegalArgumentException("Cannot create a fluidstack from a null fluid");
        }
        this.fluidDelegate = null;
        this.amount = amount;
    }

    public FluidStack(Fluid fluid, int amount, CompoundNBT nbt) {
        this(fluid, amount);
        if (nbt != null) {
            this.tag = nbt.func_74737_b();
        }
    }

    public FluidStack(FluidStack stack, int amount) {
        this(stack.getFluid(), amount, stack.tag);
    }

    @Nullable
    public static FluidStack loadFluidStackFromNBT(CompoundNBT nbt) {
        if (nbt == null) {
            return null;
        }
        if (!nbt.func_150297_b("FluidName", 8)) {
            return null;
        }
        String fluidName = nbt.func_74779_i("FluidName");
        return null;
    }

    public CompoundNBT writeToNBT(CompoundNBT nbt) {
        nbt.func_74768_a("Amount", this.amount);
        if (this.tag != null) {
            nbt.func_218657_a("Tag", (INBT)this.tag);
        }
        return nbt;
    }

    public final Fluid getFluid() {
        return this.fluidDelegate.get();
    }

    public String getLocalizedName() {
        return this.getFluid().getLocalizedName(this);
    }

    public String getUnlocalizedName() {
        return this.getFluid().getUnlocalizedName(this);
    }

    public FluidStack copy() {
        return new FluidStack(this.getFluid(), this.amount, this.tag);
    }

    public boolean isFluidEqual(@Nullable FluidStack other) {
        return other != null && this.getFluid() == other.getFluid() && this.isFluidStackTagEqual(other);
    }

    private boolean isFluidStackTagEqual(FluidStack other) {
        return this.tag == null ? other.tag == null : (other.tag == null ? false : this.tag.equals((Object)other.tag));
    }

    public static boolean areFluidStackTagsEqual(@Nullable FluidStack stack1, @Nullable FluidStack stack2) {
        return stack1 == null && stack2 == null ? true : (stack1 == null || stack2 == null ? false : stack1.isFluidStackTagEqual(stack2));
    }

    public boolean containsFluid(@Nullable FluidStack other) {
        return this.isFluidEqual(other) && this.amount >= other.amount;
    }

    public boolean isFluidStackIdentical(FluidStack other) {
        return this.isFluidEqual(other) && this.amount == other.amount;
    }

    public boolean isFluidEqual(ItemStack other) {
        if (other == null) {
            return false;
        }
        return FluidUtil.getFluidContained(other).map(this::isFluidEqual).orElse(false);
    }

    public final int hashCode() {
        int code = 1;
        code = 31 * code + this.getFluid().hashCode();
        code = 31 * code + this.amount;
        if (this.tag != null) {
            code = 31 * code + this.tag.hashCode();
        }
        return code;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof FluidStack)) {
            return false;
        }
        return this.isFluidEqual((FluidStack)o);
    }
}

