/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import com.google.common.collect.ImmutableList;
import cpw.mods.modlauncher.TransformingClassLoader;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.util.registry.Bootstrap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LifecycleEventProvider;
import net.minecraftforge.fml.LoadingFailedException;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingException;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.fml.StartupMessageManager;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.lifecycle.ModLifecycleEvent;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.InvalidModIdentifier;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.IModLanguageProvider;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.ObjectHolderRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static ModLoader INSTANCE;
    private final TransformingClassLoader launchClassLoader;
    private final LoadingModList loadingModList;
    private final List<ModLoadingException> loadingExceptions;
    private final List<ModLoadingWarning> loadingWarnings;
    private GatherDataEvent.DataGeneratorConfig dataGeneratorConfig;
    private final Optional<Consumer<String>> statusConsumer = StartupMessageManager.modLoaderConsumer();

    private ModLoader() {
        INSTANCE = this;
        this.launchClassLoader = FMLLoader.getLaunchClassLoader();
        this.loadingModList = FMLLoader.getLoadingModList();
        this.loadingExceptions = FMLLoader.getLoadingModList().getErrors().stream().flatMap(ModLoadingException::fromEarlyException).collect(Collectors.toList());
        this.loadingWarnings = FMLLoader.getLoadingModList().getBrokenFiles().stream().map(file -> new ModLoadingWarning(null, ModLoadingStage.VALIDATE, InvalidModIdentifier.identifyJarProblem((Path)file.getFilePath()).orElse("fml.modloading.brokenfile"), file.getFileName())).collect(Collectors.toList());
        LOGGER.info(Logging.CORE, "Loading Network data for FML net version: {}", (Object)"FML2");
    }

    public static ModLoader get() {
        return INSTANCE == null ? (INSTANCE = new ModLoader()) : INSTANCE;
    }

    public void loadMods(Executor mainThreadExecutor, Consumer<Consumer<Supplier<Event>>> preSidedRunnable, Consumer<Consumer<Supplier<Event>>> postSidedRunnable) {
        this.statusConsumer.ifPresent(c -> c.accept("Loading mod config"));
        DistExecutor.runWhenOn(Dist.CLIENT, () -> () -> ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.CLIENT, FMLPaths.CONFIGDIR.get()));
        ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.COMMON, FMLPaths.CONFIGDIR.get());
        this.statusConsumer.ifPresent(c -> c.accept("Mod setup: SETUP"));
        this.dispatchAndHandleError(LifecycleEventProvider.SETUP, mainThreadExecutor, null);
        this.statusConsumer.ifPresent(c -> c.accept("Mod setup: SIDED SETUP"));
        mainThreadExecutor.execute(() -> preSidedRunnable.accept(c -> ModList.get().forEachModContainer((arg_0, arg_1) -> ModLoader.lambda$null$6((Supplier)c, arg_0, arg_1))));
        this.dispatchAndHandleError(LifecycleEventProvider.SIDED_SETUP, mainThreadExecutor, null);
        mainThreadExecutor.execute(() -> postSidedRunnable.accept(c -> ModList.get().forEachModContainer((arg_0, arg_1) -> ModLoader.lambda$null$9((Supplier)c, arg_0, arg_1))));
        this.statusConsumer.ifPresent(c -> c.accept("Mod setup complete"));
    }

    public void gatherAndInitializeMods(Runnable ticker) {
        this.statusConsumer.ifPresent(c -> c.accept("Loading mods"));
        ModList modList = ModList.of(this.loadingModList.getModFiles().stream().map(ModFileInfo::getFile).collect(Collectors.toList()), this.loadingModList.getMods());
        if (!this.loadingExceptions.isEmpty()) {
            LOGGER.fatal(Logging.CORE, "Error during pre-loading phase", (Throwable)this.loadingExceptions.get(0));
            modList.setLoadedMods(Collections.emptyList());
            throw new LoadingFailedException(this.loadingExceptions);
        }
        this.statusConsumer.ifPresent(c -> c.accept("Building Mod List"));
        List<ModContainer> modContainers = this.loadingModList.getModFiles().stream().map(ModFileInfo::getFile).map(mf -> this.buildMods((ModFile)mf, this.launchClassLoader)).flatMap(Collection::stream).collect(Collectors.toList());
        if (!this.loadingExceptions.isEmpty()) {
            LOGGER.fatal(Logging.CORE, "Failed to initialize mod containers", (Throwable)this.loadingExceptions.get(0));
            modList.setLoadedMods(Collections.emptyList());
            throw new LoadingFailedException(this.loadingExceptions);
        }
        modList.setLoadedMods(modContainers);
        this.statusConsumer.ifPresent(c -> c.accept(String.format("Constructing %d mods", modList.size())));
        this.dispatchAndHandleError(LifecycleEventProvider.CONSTRUCT, Runnable::run, ticker);
        this.statusConsumer.ifPresent(c -> c.accept("Creating registries"));
        GameData.fireCreateRegistryEvents(LifecycleEventProvider.CREATE_REGISTRIES, event -> this.dispatchAndHandleError((LifecycleEventProvider)((Object)event), Runnable::run, ticker));
        ObjectHolderRegistry.findObjectHolders();
        CapabilityManager.INSTANCE.injectCapabilities(modList.getAllScanData());
        this.statusConsumer.ifPresent(c -> c.accept("Populating registries"));
        GameData.fireRegistryEvents(rl -> true, LifecycleEventProvider.LOAD_REGISTRIES, event -> this.dispatchAndHandleError((LifecycleEventProvider)((Object)event), Runnable::run, ticker));
        this.statusConsumer.ifPresent(c -> c.accept("Early mod loading complete"));
    }

    private void dispatchAndHandleError(LifecycleEventProvider event, Executor executor, Runnable ticker) {
        if (!this.loadingExceptions.isEmpty()) {
            LOGGER.error(Logging.LOADING, "Skipping lifecycle event {}, {} errors found.", (Object)event, (Object)this.loadingExceptions.size());
        } else {
            event.dispatch(this::accumulateErrors, executor, ticker);
        }
        if (!this.loadingExceptions.isEmpty()) {
            LOGGER.fatal(Logging.LOADING, "Failed to complete lifecycle event {}, {} errors found", (Object)event, (Object)this.loadingExceptions.size());
            throw new LoadingFailedException(this.loadingExceptions);
        }
    }

    private void accumulateErrors(List<ModLoadingException> errors) {
        this.loadingExceptions.addAll(errors);
    }

    private List<ModContainer> buildMods(ModFile modFile, TransformingClassLoader modClassLoader) {
        Map modInfoMap = modFile.getModFileInfo().getMods().stream().collect(Collectors.toMap(IModInfo::getModId, Function.identity()));
        LOGGER.debug(Logging.LOADING, "ModContainer is {}", (Object)ModContainer.class.getClassLoader());
        List<ModContainer> containers = modFile.getScanResult().getTargets().entrySet().stream().map(e -> this.buildModContainerFromTOML(modFile, modClassLoader, modInfoMap, (Map.Entry<String, ? extends IModLanguageProvider.IModLanguageLoader>)e)).collect(Collectors.toList());
        if (containers.size() != modInfoMap.size()) {
            LOGGER.fatal(Logging.LOADING, "File {} constructed {} mods: {}, but had {} mods specified: {}", (Object)modFile.getFilePath(), (Object)containers.size(), containers.stream().map(ModContainer::getModId).collect(Collectors.toList()), (Object)modInfoMap.size(), modInfoMap.values().stream().map(IModInfo::getModId).collect(Collectors.toList()));
            this.loadingExceptions.add(new ModLoadingException(null, ModLoadingStage.CONSTRUCT, "fml.modloading.missingclasses", null, modFile.getFilePath()));
        }
        return containers;
    }

    private ModContainer buildModContainerFromTOML(ModFile modFile, TransformingClassLoader modClassLoader, Map<String, IModInfo> modInfoMap, Map.Entry<String, ? extends IModLanguageProvider.IModLanguageLoader> idToProviderEntry) {
        try {
            String modId = idToProviderEntry.getKey();
            IModLanguageProvider.IModLanguageLoader languageLoader = idToProviderEntry.getValue();
            IModInfo info = Optional.ofNullable(modInfoMap.get(modId)).orElseThrow(() -> new ModLoadingException(null, ModLoadingStage.CONSTRUCT, "fml.modloading.missingmetadata", null, modId));
            return (ModContainer)languageLoader.loadMod(info, (ClassLoader)modClassLoader, modFile.getScanResult());
        }
        catch (ModLoadingException mle) {
            this.loadingExceptions.add(mle);
            return null;
        }
    }

    public void postEvent(Event e) {
        ModList.get().forEachModContainer((id, mc) -> mc.acceptEvent(e));
    }

    public void finishMods(Executor mainThreadExecutor) {
        this.statusConsumer.ifPresent(c -> c.accept("Mod setup: ENQUEUE IMC"));
        this.dispatchAndHandleError(LifecycleEventProvider.ENQUEUE_IMC, mainThreadExecutor, null);
        this.statusConsumer.ifPresent(c -> c.accept("Mod setup: PROCESS IMC"));
        this.dispatchAndHandleError(LifecycleEventProvider.PROCESS_IMC, mainThreadExecutor, null);
        this.statusConsumer.ifPresent(c -> c.accept("Mod setup: Final completion"));
        this.dispatchAndHandleError(LifecycleEventProvider.COMPLETE, mainThreadExecutor, null);
        this.statusConsumer.ifPresent(c -> c.accept("Freezing data"));
        GameData.freezeData();
        NetworkRegistry.lock();
        this.statusConsumer.ifPresent(c -> c.accept(String.format("Mod loading complete - %d mods loaded", ModList.get().size())));
    }

    public List<ModLoadingWarning> getWarnings() {
        return ImmutableList.copyOf(this.loadingWarnings);
    }

    public void addWarning(ModLoadingWarning warning) {
        this.loadingWarnings.add(warning);
    }

    public void runDataGenerator(Set<String> mods, Path path, Collection<Path> inputs, boolean serverGenerators, boolean clientGenerators, boolean devToolGenerators, boolean reportsGenerator, boolean structureValidator) {
        if (mods.contains("minecraft") && mods.size() == 1) {
            return;
        }
        LOGGER.info("Initializing Data Gatherer for mods {}", mods);
        Bootstrap.func_151354_b();
        this.dataGeneratorConfig = new GatherDataEvent.DataGeneratorConfig(mods, path, inputs, serverGenerators, clientGenerators, devToolGenerators, reportsGenerator, structureValidator);
        this.gatherAndInitializeMods(null);
        this.dispatchAndHandleError(LifecycleEventProvider.GATHERDATA, Runnable::run, null);
        this.dataGeneratorConfig.runAll();
    }

    public Function<ModContainer, ModLifecycleEvent> getDataGeneratorEvent() {
        return mc -> new GatherDataEvent((ModContainer)mc, this.dataGeneratorConfig.makeGenerator(p -> this.dataGeneratorConfig.getMods().size() == 1 ? p : p.resolve(mc.getModId()), this.dataGeneratorConfig.getMods().contains(mc.getModId())), this.dataGeneratorConfig);
    }

    private static /* synthetic */ void lambda$null$9(Supplier c, String mi, ModContainer mc) {
        mc.acceptEvent((Event)c.get());
    }

    private static /* synthetic */ void lambda$null$6(Supplier c, String mi, ModContainer mc) {
        mc.acceptEvent((Event)c.get());
    }
}

