/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.ClientResourcePackInfo;
import net.minecraft.client.resources.DownloadingPackFinder;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.ResourcePackList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.BrandingControl;
import net.minecraftforge.fml.LoadingFailedException;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.fml.SidedProvider;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.client.ClientHooks;
import net.minecraftforge.fml.client.EarlyLoaderGUI;
import net.minecraftforge.fml.client.gui.LoadingErrorScreen;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.packs.ResourcePackLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ClientModLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean loading;
    private static Minecraft mc;
    private static LoadingFailedException error;
    private static EarlyLoaderGUI earlyLoaderGUI;

    public static void begin(Minecraft minecraft, ResourcePackList<ClientResourcePackInfo> defaultResourcePacks, IReloadableResourceManager mcResourceManager, DownloadingPackFinder metadataSerializer) {
        loading = true;
        mc = minecraft;
        SidedProvider.setClient(() -> minecraft);
        LogicalSidedProvider.setClient(() -> minecraft);
        earlyLoaderGUI = new EarlyLoaderGUI(minecraft.field_195558_d);
        ClientModLoader.createRunnableWithCatch(() -> ModLoader.get().gatherAndInitializeMods(earlyLoaderGUI::renderTick)).run();
        ResourcePackLoader.loadResourcePacks(defaultResourcePacks);
        mcResourceManager.func_219534_a(ClientModLoader::onreload);
        mcResourceManager.func_219534_a((IFutureReloadListener)BrandingControl.resourceManagerReloadListener());
    }

    private static CompletableFuture<Void> onreload(IFutureReloadListener.IStage stage, IResourceManager resourceManager, IProfiler prepareProfiler, IProfiler executeProfiler, Executor asyncExecutor, Executor syncExecutor) {
        return ((CompletableFuture)CompletableFuture.runAsync(ClientModLoader.createRunnableWithCatch(() -> ClientModLoader.startModLoading(syncExecutor)), asyncExecutor).thenCompose(arg_0 -> ((IFutureReloadListener.IStage)stage).func_216872_a(arg_0))).thenRunAsync(() -> ClientModLoader.finishModLoading(syncExecutor), asyncExecutor);
    }

    private static Runnable createRunnableWithCatch(Runnable r) {
        return () -> {
            block2: {
                try {
                    r.run();
                }
                catch (LoadingFailedException e) {
                    MinecraftForge.EVENT_BUS.shutdown();
                    if (error != null) break block2;
                    error = e;
                }
            }
        };
    }

    private static void startModLoading(Executor executor) {
        earlyLoaderGUI.handleElsewhere();
        ClientModLoader.createRunnableWithCatch(() -> ModLoader.get().loadMods(executor, ClientModLoader::preSidedRunnable, ClientModLoader::postSidedRunnable)).run();
    }

    private static void postSidedRunnable(Consumer<Supplier<Event>> perModContainerEventProcessor) {
        RenderingRegistry.loadEntityRenderers(mc.func_175598_ae());
    }

    private static void preSidedRunnable(Consumer<Supplier<Event>> perModContainerEventProcessor) {
        perModContainerEventProcessor.accept(ModelRegistryEvent::new);
    }

    private static void finishModLoading(Executor executor) {
        ClientModLoader.createRunnableWithCatch(() -> ModLoader.get().finishMods(executor)).run();
        loading = false;
        executor.execute(() -> ClientModLoader.mc.field_71474_y.func_74300_a());
    }

    public static VersionChecker.Status checkForUpdates() {
        return VersionChecker.Status.UP_TO_DATE;
    }

    public static void complete() {
        GlStateManager.disableTexture();
        GlStateManager.enableTexture();
        List<ModLoadingWarning> warnings = ModLoader.get().getWarnings();
        boolean showWarnings = true;
        try {
            showWarnings = (Boolean)ForgeConfig.CLIENT.showLoadWarnings.get();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (!showWarnings) {
            if (!warnings.isEmpty()) {
                LOGGER.warn(LogMarkers.LOADING, "Mods loaded with {} warning(s)", (Object)warnings.size());
                warnings.forEach(warning -> LOGGER.warn(LogMarkers.LOADING, warning.formatToString()));
            }
            warnings = Collections.emptyList();
        }
        if (error != null || !warnings.isEmpty()) {
            mc.func_147108_a((Screen)new LoadingErrorScreen(error, warnings));
        } else {
            ClientHooks.logMissingTextureErrors();
        }
        if (error == null) {
            MinecraftForge.EVENT_BUS.start();
        }
    }

    public static void renderProgressText() {
        earlyLoaderGUI.renderFromGUI();
    }

    public static boolean isLoading() {
        return loading;
    }
}

