/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fml.MavenVersionStringHelper;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.client.gui.GuiModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IModInfo;

public class GuiSlotModList
extends ExtendedList<ModEntry> {
    private static final ResourceLocation VERSION_CHECK_ICONS = new ResourceLocation("forge", "textures/gui/version_check_icons.png");
    private final int listWidth;
    private GuiModList parent;

    public GuiSlotModList(GuiModList parent, int listWidth) {
        Minecraft minecraft = parent.getMinecraftInstance();
        int n = parent.height;
        int n2 = parent.height - 67 + 4;
        parent.getFontRenderer().getClass();
        super(minecraft, listWidth, n, 32, n2, 9 * 2 + 8);
        this.parent = parent;
        this.listWidth = listWidth;
        this.refreshList();
    }

    protected int getScrollbarPosition() {
        return this.listWidth;
    }

    public int getRowWidth() {
        return this.listWidth;
    }

    void refreshList() {
        this.clearEntries();
        this.parent.buildModList(arg_0 -> ((GuiSlotModList)this).addEntry(arg_0), mod -> new ModEntry((ModInfo)mod, this.parent));
    }

    protected void renderBackground() {
        this.parent.renderBackground();
    }

    class ModEntry
    extends ExtendedList.AbstractListEntry<ModEntry> {
        private final ModInfo modInfo;
        private final GuiModList parent;

        ModEntry(ModInfo info, GuiModList parent) {
            this.modInfo = info;
            this.parent = parent;
        }

        public void render(int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
            String name = StringUtils.func_76338_a((String)this.modInfo.getDisplayName());
            String version = StringUtils.func_76338_a((String)MavenVersionStringHelper.artifactVersionToString(this.modInfo.getVersion()));
            VersionChecker.CheckResult vercheck = VersionChecker.getResult((IModInfo)this.modInfo);
            FontRenderer font = this.parent.getFontRenderer();
            font.func_211126_b(font.func_78269_a(name, GuiSlotModList.this.listWidth), (float)(left + 3), (float)(top + 2), 0xFFFFFF);
            String string = font.func_78269_a(version, GuiSlotModList.this.listWidth);
            float f = left + 3;
            font.getClass();
            font.func_211126_b(string, f, (float)(top + 2 + 9), 0xCCCCCC);
            if (vercheck.status.shouldDraw()) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(VERSION_CHECK_ICONS);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.pushMatrix();
                AbstractGui.blit((int)(GuiSlotModList.this.getRight() - (GuiSlotModList.this.height / 2 + 4)), (int)(GuiSlotModList.this.getTop() + (GuiSlotModList.this.height / 2 - 4)), (float)(vercheck.status.getSheetOffset() * 8), (float)(vercheck.status.isAnimated() && (System.currentTimeMillis() / 800L & 1L) == 1L ? 8.0f : 0.0f), (int)8, (int)8, (int)64, (int)16);
                GlStateManager.popMatrix();
            }
        }

        public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            this.parent.setSelected(this);
            GuiSlotModList.this.setSelected((AbstractList.AbstractListEntry)this);
            return false;
        }

        public ModInfo getInfo() {
            return this.modInfo;
        }
    }
}

