/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.gameevent;

import javax.annotation.Nonnull;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.eventbus.api.Event;

public class PlayerEvent
extends Event {
    private final PlayerEntity player;

    private PlayerEvent(PlayerEntity player) {
        this.player = player;
    }

    public PlayerEntity getPlayer() {
        return this.player;
    }

    public static class PlayerChangedDimensionEvent
    extends PlayerEvent {
        private final DimensionType fromDim;
        private final DimensionType toDim;

        public PlayerChangedDimensionEvent(PlayerEntity player, DimensionType fromDim, DimensionType toDim) {
            super(player);
            this.fromDim = fromDim;
            this.toDim = toDim;
        }

        public DimensionType getFrom() {
            return this.fromDim;
        }

        public DimensionType getTo() {
            return this.toDim;
        }
    }

    public static class PlayerRespawnEvent
    extends PlayerEvent {
        private final boolean endConquered;

        public PlayerRespawnEvent(PlayerEntity player, boolean endConquered) {
            super(player);
            this.endConquered = endConquered;
        }

        public boolean isEndConquered() {
            return this.endConquered;
        }
    }

    public static class PlayerLoggedOutEvent
    extends PlayerEvent {
        public PlayerLoggedOutEvent(PlayerEntity player) {
            super(player);
        }
    }

    public static class PlayerLoggedInEvent
    extends PlayerEvent {
        public PlayerLoggedInEvent(PlayerEntity player) {
            super(player);
        }
    }

    public static class ItemSmeltedEvent
    extends PlayerEvent {
        @Nonnull
        private final ItemStack smelting;

        public ItemSmeltedEvent(PlayerEntity player, @Nonnull ItemStack crafting) {
            super(player);
            this.smelting = crafting;
        }

        @Nonnull
        public ItemStack getSmelting() {
            return this.smelting;
        }
    }

    public static class ItemCraftedEvent
    extends PlayerEvent {
        @Nonnull
        private final ItemStack crafting;
        private final IInventory craftMatrix;

        public ItemCraftedEvent(PlayerEntity player, @Nonnull ItemStack crafting, IInventory craftMatrix) {
            super(player);
            this.crafting = crafting;
            this.craftMatrix = craftMatrix;
        }

        @Nonnull
        public ItemStack getCrafting() {
            return this.crafting;
        }

        public IInventory getInventory() {
            return this.craftMatrix;
        }
    }

    public static class ItemPickupEvent
    extends PlayerEvent {
        private final ItemEntity originalEntity;
        private final ItemStack stack;

        public ItemPickupEvent(PlayerEntity player, ItemEntity entPickedUp, ItemStack stack) {
            super(player);
            this.originalEntity = entPickedUp;
            this.stack = stack;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public ItemEntity getOriginalEntity() {
            return this.originalEntity;
        }
    }
}

