/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.IntIdentityHashBiMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.MutableRegistry;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class ClearableRegistry<T>
extends MutableRegistry<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker REGISTRY = MarkerManager.getMarker((String)"REGISTRY");
    private final IntIdentityHashBiMap<T> ids = new IntIdentityHashBiMap(256);
    private final BiMap<ResourceLocation, T> map = HashBiMap.create();
    private final Set<ResourceLocation> keys = Collections.unmodifiableSet(this.map.keySet());
    private List<T> values = new ArrayList<T>();
    private final ResourceLocation name;
    private int nextId = 0;

    public ClearableRegistry(ResourceLocation name) {
        this.name = name;
    }

    @Nullable
    public ResourceLocation func_177774_c(T value) {
        return (ResourceLocation)this.map.inverse().get(value);
    }

    @Nullable
    public int func_148757_b(T value) {
        return this.ids.func_186815_a(value);
    }

    @Nullable
    public T func_148745_a(int id) {
        return (T)this.ids.func_148745_a(id);
    }

    public Iterator<T> iterator() {
        return this.ids.iterator();
    }

    @Nullable
    public T func_82594_a(ResourceLocation key) {
        return (T)this.map.get((Object)key);
    }

    public <V extends T> V func_218382_a(int id, ResourceLocation key, V value) {
        Validate.isTrue((id >= 0 ? 1 : 0) != 0, (String)"Invalid ID, can not be < 0", (Object[])new Object[0]);
        Validate.notNull((Object)key);
        Validate.notNull(value);
        Object old = this.map.get((Object)key);
        if (old != null) {
            LOGGER.debug(REGISTRY, "{}: Adding suplicate key '{}' to registry. Old: {} New: {}", (Object)this.name, (Object)key, old, value);
            this.values.remove(old);
        }
        this.map.put((Object)key, value);
        this.ids.func_186814_a(value, id);
        this.values.add(value);
        if (this.nextId <= id) {
            this.nextId = id + 1;
        }
        return value;
    }

    public <V extends T> V func_218381_a(ResourceLocation key, V value) {
        return this.func_218382_a(this.nextId, key, value);
    }

    public Set<ResourceLocation> func_148742_b() {
        return this.keys;
    }

    public boolean func_195866_d() {
        return this.map.isEmpty();
    }

    @Nullable
    public T func_186801_a(Random random) {
        return this.values.isEmpty() ? null : (T)this.values.get(random.nextInt(this.values.size()));
    }

    public boolean func_212607_c(ResourceLocation key) {
        return this.map.containsKey((Object)key);
    }

    public void clear() {
        LOGGER.debug(REGISTRY, "{}: Clearing registry", (Object)this.name);
        this.map.clear();
        this.values.clear();
        this.ids.func_186812_a();
        this.nextId = 0;
    }

    public int getNextId() {
        return this.nextId;
    }

    public Optional<T> func_218349_b(ResourceLocation key) {
        return Optional.ofNullable(this.map.get((Object)key));
    }
}

