/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.common.WorldWorkerManager;
import net.minecraftforge.common.data.ForgeBlockTagsProvider;
import net.minecraftforge.common.data.ForgeItemTagsProvider;
import net.minecraftforge.common.data.ForgeRecipeProvider;
import net.minecraftforge.common.model.animation.CapabilityAnimation;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.FMLWorldPersistenceHook;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.StartupMessageManager;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.WorldPersistenceHooks;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLModIdMappingEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.server.command.ConfigCommand;
import net.minecraftforge.server.command.ForgeCommand;
import net.minecraftforge.versions.forge.ForgeVersion;
import net.minecraftforge.versions.mcp.MCPVersion;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

@Mod(value="forge")
public class ForgeMod
implements WorldPersistenceHooks.WorldPersistenceHook {
    public static final String VERSION_CHECK_CAT = "version_checking";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker FORGEMOD = MarkerManager.getMarker((String)"FORGEMOD");
    public static int[] blendRanges = new int[]{2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34};
    public static boolean disableVersionCheck = false;
    public static boolean forgeLightPipelineEnabled = true;
    public static boolean zoomInMissingModelTextInGui = false;
    public static boolean disableStairSlabCulling = false;
    public static boolean alwaysSetupTerrainOffThread = false;
    public static boolean logCascadingWorldGeneration = true;
    public static boolean fixVanillaCascading = false;
    private static ForgeMod INSTANCE;
    public UniversalBucket universalBucket;

    public static ForgeMod getInstance() {
        return INSTANCE;
    }

    public ForgeMod() {
        LOGGER.info(FORGEMOD, "Forge mod loading, version {}, for MC {} with MCP {}", (Object)ForgeVersion.getVersion(), (Object)MCPVersion.getMCVersion(), (Object)MCPVersion.getMCPVersion());
        INSTANCE = this;
        MinecraftForge.initialize();
        WorldPersistenceHooks.addHook(this);
        WorldPersistenceHooks.addHook(new FMLWorldPersistenceHook());
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::preInit);
        modEventBus.addListener(this::gatherData);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
        MinecraftForge.EVENT_BUS.addListener(this::playerLogin);
        MinecraftForge.EVENT_BUS.addListener(this::serverStopping);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ForgeConfig.clientSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, ForgeConfig.serverSpec);
        modEventBus.register(ForgeConfig.class);
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "ANY", (remote, isServer) -> true));
        StartupMessageManager.addModMessage("Forge version " + ForgeVersion.getVersion());
    }

    public void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        UsernameCache.setUsername(event.getPlayer().func_110124_au(), event.getPlayer().func_146103_bH().getName());
    }

    public void preInit(FMLCommonSetupEvent evt) {
        CapabilityItemHandler.register();
        CapabilityFluidHandler.register();
        CapabilityAnimation.register();
        CapabilityEnergy.register();
        MinecraftForge.EVENT_BUS.register((Object)MinecraftForge.INTERNAL_HANDLER);
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (!disableVersionCheck) {
            VersionChecker.startVersionCheck();
        }
    }

    public void serverStarting(FMLServerStartingEvent evt) {
        new ForgeCommand(evt.getCommandDispatcher());
        ConfigCommand.register(evt.getCommandDispatcher());
    }

    public void serverStopping(FMLServerStoppingEvent evt) {
        WorldWorkerManager.clear();
    }

    @Override
    public CompoundNBT getDataForWriting(SaveHandler handler, WorldInfo info) {
        CompoundNBT forgeData = new CompoundNBT();
        CompoundNBT dims = new CompoundNBT();
        DimensionManager.writeRegistry(dims);
        if (!dims.isEmpty()) {
            forgeData.func_218657_a("dims", (INBT)dims);
        }
        return forgeData;
    }

    @Override
    public void readData(SaveHandler handler, WorldInfo info, CompoundNBT tag) {
        if (tag.func_150297_b("dims", 10)) {
            DimensionManager.readRegistry(tag.func_74775_l("dims"));
        }
    }

    public void mappingChanged(FMLModIdMappingEvent evt) {
    }

    @Override
    public String getModId() {
        return "forge";
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        if (event.includeServer()) {
            gen.func_200390_a((IDataProvider)new ForgeBlockTagsProvider(gen));
            gen.func_200390_a((IDataProvider)new ForgeItemTagsProvider(gen));
            gen.func_200390_a((IDataProvider)new ForgeRecipeProvider(gen));
        }
    }
}

