/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.IConditionSerializer;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.IngredientNBT;
import net.minecraftforge.common.crafting.StackList;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class CraftingHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker CRAFTHELPER = MarkerManager.getMarker((String)"CRAFTHELPER");
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<ResourceLocation, IConditionSerializer> conditions = new HashMap<ResourceLocation, IConditionSerializer>();
    private static final BiMap<ResourceLocation, IIngredientSerializer<?>> ingredients = HashBiMap.create();
    private static Map<ResourceLocation, Ingredient.IItemList> constants = new HashMap<ResourceLocation, Ingredient.IItemList>();
    public static final IConditionSerializer CONDITION_MOD_LOADED = CraftingHelper.condition("mod_loaded", json -> {
        String modid = JSONUtils.func_151200_h((JsonObject)json, (String)"modid");
        return () -> ModList.get().isLoaded(modid);
    });
    public static final IConditionSerializer CONDITION_ITEM_EXISTS = CraftingHelper.condition("item_exists", json -> {
        String itemName = JSONUtils.func_151200_h((JsonObject)json, (String)"item");
        return () -> ForgeRegistries.ITEMS.containsKey(new ResourceLocation(itemName));
    });
    public static final IConditionSerializer CONDITION_NOT = CraftingHelper.condition("not", json -> {
        BooleanSupplier child = CraftingHelper.getCondition(JSONUtils.func_152754_s((JsonObject)json, (String)"value"));
        return () -> !child.getAsBoolean();
    });
    public static final IConditionSerializer CONDITION_OR = CraftingHelper.condition("or", json -> {
        JsonArray values = JSONUtils.func_151214_t((JsonObject)json, (String)"values");
        ArrayList children = Lists.newArrayList();
        for (JsonElement j : values) {
            if (!j.isJsonObject()) {
                throw new JsonSyntaxException("Or condition values must be an array of JsonObjects");
            }
            children.add(CraftingHelper.getCondition(j.getAsJsonObject()));
        }
        return () -> children.stream().anyMatch(BooleanSupplier::getAsBoolean);
    });
    public static final IConditionSerializer CONDITION_AND = CraftingHelper.condition("and", json -> {
        JsonArray values = JSONUtils.func_151214_t((JsonObject)json, (String)"values");
        ArrayList children = Lists.newArrayList();
        for (JsonElement j : values) {
            if (!j.isJsonObject()) {
                throw new JsonSyntaxException("And condition values must be an array of JsonObjects");
            }
            children.add(CraftingHelper.getCondition(j.getAsJsonObject()));
        }
        return () -> children.stream().allMatch(c -> c.getAsBoolean());
    });
    public static final IConditionSerializer CONDITION_FALSE = CraftingHelper.condition("false", json -> () -> false);
    public static final IIngredientSerializer<IngredientNBT> INGREDIENT_NBT = CraftingHelper.register(new ResourceLocation("forge", "nbt"), new IngredientNBT.Serializer());
    public static final IIngredientSerializer<CompoundIngredient> INGREDIENT_COMPOUND = CraftingHelper.register(new ResourceLocation("forge", "compound"), new CompoundIngredient.Serializer());
    public static final IIngredientSerializer<Ingredient> INGREDIENT_VANILLA = CraftingHelper.register(new ResourceLocation("minecraft", "item"), new IIngredientSerializer<Ingredient>(){

        @Override
        public Ingredient parse(PacketBuffer buffer) {
            return Ingredient.func_209357_a(Stream.generate(() -> new Ingredient.SingleItemList(buffer.func_150791_c())).limit(buffer.func_150792_a()));
        }

        @Override
        public Ingredient parse(JsonObject json) {
            return Ingredient.func_209357_a(Stream.of(Ingredient.func_199803_a((JsonObject)json)));
        }

        @Override
        public void write(PacketBuffer buffer, Ingredient ingredient) {
            ItemStack[] items = ingredient.func_193365_a();
            buffer.func_150787_b(items.length);
            for (ItemStack stack : items) {
                buffer.func_150788_a(stack);
            }
        }
    });

    public static IConditionSerializer register(ResourceLocation key, IConditionSerializer serializer) {
        if (conditions.containsKey(key)) {
            throw new IllegalStateException("Duplicate recipe condition serializer: " + key);
        }
        conditions.put(key, serializer);
        return serializer;
    }

    public static <T extends Ingredient> IIngredientSerializer<T> register(ResourceLocation key, IIngredientSerializer<T> serializer) {
        if (ingredients.containsKey((Object)key)) {
            throw new IllegalStateException("Duplicate recipe ingredient serializer: " + key);
        }
        if (ingredients.containsValue(serializer)) {
            throw new IllegalStateException("Duplicate recipe ingredient serializer: " + key + " " + serializer);
        }
        ingredients.put((Object)key, serializer);
        return serializer;
    }

    private static IConditionSerializer condition(String name, IConditionSerializer serializer) {
        return CraftingHelper.register(new ResourceLocation("forge", name), serializer);
    }

    public static <T extends Ingredient> void write(PacketBuffer buffer, T ingredient) {
        IIngredientSerializer serializer = ingredient.getSerializer();
        ResourceLocation key = (ResourceLocation)ingredients.inverse().get((Object)serializer);
        if (key == null) {
            throw new IllegalArgumentException("Tried to serialize unregistered Ingredient: " + ingredient + " " + serializer);
        }
        if (serializer != INGREDIENT_VANILLA) {
            buffer.func_150787_b(-1);
            buffer.func_192572_a(key);
        }
        serializer.write(buffer, ingredient);
    }

    public static Ingredient getIngredient(ResourceLocation type, PacketBuffer buffer) {
        IIngredientSerializer serializer = (IIngredientSerializer)ingredients.get((Object)type);
        if (serializer == null) {
            throw new IllegalArgumentException("Can not deserialize unknown Ingredient type: " + type);
        }
        return serializer.parse(buffer);
    }

    public static Ingredient getIngredient(JsonElement json) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Json cannot be null");
        }
        if (json.isJsonArray()) {
            ArrayList ingredients = Lists.newArrayList();
            ArrayList vanilla = Lists.newArrayList();
            json.getAsJsonArray().forEach(ele -> {
                Ingredient ing = CraftingHelper.getIngredient(ele);
                if (ing.getClass() == Ingredient.class) {
                    vanilla.add(ing);
                } else {
                    ingredients.add(ing);
                }
            });
            if (!vanilla.isEmpty()) {
                ingredients.add(Ingredient.merge((Collection)vanilla));
            }
            if (ingredients.size() == 0) {
                throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
            }
            if (ingredients.size() == 1) {
                return (Ingredient)ingredients.get(0);
            }
            return new CompoundIngredient(ingredients);
        }
        if (!json.isJsonObject()) {
            throw new JsonSyntaxException("Expcted ingredient to be a object or array of objects");
        }
        JsonObject obj = (JsonObject)json;
        String type = JSONUtils.func_151219_a((JsonObject)obj, (String)"type", (String)"minecraft:item");
        if (type.isEmpty()) {
            throw new JsonSyntaxException("Ingredient type can not be an empty string");
        }
        IIngredientSerializer serializer = (IIngredientSerializer)ingredients.get((Object)new ResourceLocation(type));
        if (serializer == null) {
            throw new JsonSyntaxException("Unknown ingredient type: " + type);
        }
        return serializer.parse(obj);
    }

    public static ItemStack getItemStack(JsonObject json, boolean readNBT) {
        String itemName = JSONUtils.func_151200_h((JsonObject)json, (String)"item");
        Item item = ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
        if (item == null) {
            throw new JsonSyntaxException("Unknown item '" + itemName + "'");
        }
        if (readNBT && json.has("nbt")) {
            try {
                JsonElement element = json.get("nbt");
                CompoundNBT nbt = element.isJsonObject() ? JsonToNBT.func_180713_a((String)GSON.toJson(element)) : JsonToNBT.func_180713_a((String)JSONUtils.func_151206_a((JsonElement)element, (String)"nbt"));
                CompoundNBT tmp = new CompoundNBT();
                if (nbt.func_74764_b("ForgeCaps")) {
                    tmp.func_218657_a("ForgeCaps", nbt.func_74781_a("ForgeCaps"));
                    nbt.func_82580_o("ForgeCaps");
                }
                tmp.func_218657_a("tag", (INBT)nbt);
                tmp.func_74778_a("id", itemName);
                tmp.func_74768_a("Count", JSONUtils.func_151208_a((JsonObject)json, (String)"count", (int)1));
                return ItemStack.func_199557_a((CompoundNBT)tmp);
            }
            catch (CommandSyntaxException e) {
                throw new JsonSyntaxException("Invalid NBT Entry: " + e.toString());
            }
        }
        return new ItemStack((IItemProvider)item, JSONUtils.func_151208_a((JsonObject)json, (String)"count", (int)1));
    }

    public static boolean processConditions(JsonObject json, String memberName) {
        return !json.has(memberName) || CraftingHelper.processConditions(JSONUtils.func_151214_t((JsonObject)json, (String)memberName));
    }

    public static boolean processConditions(JsonArray conditions) {
        for (int x = 0; x < conditions.size(); ++x) {
            if (!conditions.get(x).isJsonObject()) {
                throw new JsonSyntaxException("Conditions must be an array of JsonObjects");
            }
            JsonObject json = conditions.get(x).getAsJsonObject();
            BooleanSupplier cond = CraftingHelper.getCondition(json);
            if (cond.getAsBoolean()) continue;
            return false;
        }
        return true;
    }

    public static BooleanSupplier getCondition(JsonObject json) {
        ResourceLocation type = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"type"));
        IConditionSerializer serrializer = conditions.get(type);
        if (serrializer == null) {
            throw new JsonSyntaxException("Unknown condition type: " + type.toString());
        }
        return serrializer.parse(json);
    }

    @Nullable
    public static Ingredient.IItemList getConstant(ResourceLocation key) {
        return constants.get(key);
    }

    public static void reloadConstants(IResourceManager manager) {
        HashMap<ResourceLocation, Ingredient.IItemList> tmp = new HashMap<ResourceLocation, Ingredient.IItemList>();
        for (ResourceLocation key : manager.func_199003_a("recipes", filename -> filename.equals("_constants.json"))) {
            String path = key.func_110623_a();
            if (!path.equals("recipes/_constants.json")) continue;
            tmp.putAll(CraftingHelper.loadConstants(manager, key));
        }
        constants = tmp;
    }

    public static Map<ResourceLocation, Ingredient.IItemList> loadConstants(IResourceManager manager, ResourceLocation key) {
        HashMap<ResourceLocation, Ingredient.IItemList> tmp = new HashMap<ResourceLocation, Ingredient.IItemList>();
        try (IResource iresource = manager.func_199002_a(key);){
            JsonObject[] elements = (JsonObject[])JSONUtils.func_188178_a((Gson)GSON, (String)IOUtils.toString((InputStream)iresource.func_199027_b(), (Charset)StandardCharsets.UTF_8), JsonObject[].class);
            for (int x = 0; x < elements.length; ++x) {
                ResourceLocation name;
                JsonObject json = elements[x];
                ResourceLocation resourceLocation = name = json.has("name") ? new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"name")) : null;
                if (name != null) {
                    name = new ResourceLocation(key.func_110624_b(), name.func_110623_a());
                }
                if (json == null || json.size() == 0) {
                    LOGGER.error(CRAFTHELPER, "Couldn't load constant #{} from {} as it's null or empty", (Object)x, (Object)key);
                    continue;
                }
                if (!CraftingHelper.processConditions(json, "conditions")) {
                    LOGGER.info(CRAFTHELPER, "Skipping loading constant #{} from {} as it's conditions were not met", (Object)x, (Object)key);
                    continue;
                }
                if (name == null) {
                    LOGGER.error(CRAFTHELPER, "Couldn't load constant #{} from {} as it's missing `name`", (Object)x, (Object)key);
                    continue;
                }
                if (json.has("items")) {
                    ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                    for (JsonElement item : JSONUtils.func_151214_t((JsonObject)json, (String)"items")) {
                        if (item.isJsonObject()) {
                            items.add(CraftingHelper.getItemStack(item.getAsJsonObject(), true));
                            continue;
                        }
                        LOGGER.error(CRAFTHELPER, "Couldn't load constant #{} from {} as it's `items` entry is not a object", (Object)x, (Object)key);
                        items.clear();
                        break;
                    }
                    if (items.isEmpty()) continue;
                    tmp.put(name, new StackList(items));
                    continue;
                }
                if (json.has("tag")) {
                    tmp.put(name, Ingredient.func_199803_a((JsonObject)json));
                    continue;
                }
                if (json.has("item")) {
                    tmp.put(name, new StackList(Lists.newArrayList((Object[])new ItemStack[]{CraftingHelper.getItemStack(JSONUtils.func_152754_s((JsonObject)json, (String)"item"), true)})));
                    continue;
                }
                LOGGER.error(CRAFTHELPER, "Couldn't load constant #{} from {} as it's missing `item` or `items` element", (Object)x, (Object)key);
            }
        }
        catch (JsonParseException | IllegalArgumentException e) {
            LOGGER.error(CRAFTHELPER, "Parsing error loading constants {}", (Object)key, (Object)e);
        }
        catch (IOException e) {
            LOGGER.error(CRAFTHELPER, "Couldn't read constants from {}", (Object)key, (Object)e);
        }
        return tmp;
    }
}

