/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.SingularMatrixException;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.util.Direction;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.ITransformation;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public final class TRSRTransformation
implements IModelState,
ITransformation {
    private final Matrix4f matrix;
    private boolean full;
    private Vector3f translation;
    private Quat4f leftRot;
    private Vector3f scale;
    private Quat4f rightRot;
    private Matrix3f normalTransform;
    private static final TRSRTransformation identity;
    private static final float eps = 1.0E-6f;
    private static final float g;
    private static final float cs;
    private static final float ss;
    private static final float sq2;
    private static final EnumMap<Direction, TRSRTransformation> vanillaUvTransformLocalToGlobal;
    private static final EnumMap<Direction, TRSRTransformation> vanillaUvTransformGlobalToLocal;

    public TRSRTransformation(@Nullable Matrix4f matrix) {
        this.matrix = matrix == null ? TRSRTransformation.identity.matrix : matrix;
    }

    public TRSRTransformation(@Nullable Vector3f translation, @Nullable Quat4f leftRot, @Nullable Vector3f scale, @Nullable Quat4f rightRot) {
        this.matrix = TRSRTransformation.mul(translation, leftRot, scale, rightRot);
        this.translation = translation != null ? translation : new Vector3f();
        this.leftRot = leftRot != null ? leftRot : new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        this.scale = scale != null ? scale : new Vector3f(1.0f, 1.0f, 1.0f);
        this.rightRot = rightRot != null ? rightRot : new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        this.full = true;
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public static TRSRTransformation from(ItemTransformVec3f transform) {
        return transform.equals((Object)ItemTransformVec3f.field_178366_a) ? identity : new TRSRTransformation(TRSRTransformation.toVecmath(transform.field_178365_c), TRSRTransformation.quatFromXYZDegrees(TRSRTransformation.toVecmath(transform.field_178364_b)), TRSRTransformation.toVecmath(transform.field_178363_d), null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static TRSRTransformation from(ModelRotation rotation) {
        return Cache.get(rotation);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static TRSRTransformation from(Direction facing) {
        return Cache.get(TRSRTransformation.getRotation(facing));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Matrix4f getMatrix(Direction facing) {
        return TRSRTransformation.getRotation(facing).getMatrixVec();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ModelRotation getRotation(Direction facing) {
        switch (facing) {
            case DOWN: {
                return ModelRotation.X90_Y0;
            }
            case UP: {
                return ModelRotation.X270_Y0;
            }
            case NORTH: {
                return ModelRotation.X0_Y0;
            }
            case SOUTH: {
                return ModelRotation.X0_Y180;
            }
            case WEST: {
                return ModelRotation.X0_Y270;
            }
            case EAST: {
                return ModelRotation.X0_Y90;
            }
        }
        throw new IllegalArgumentException(String.valueOf(facing));
    }

    public static TRSRTransformation identity() {
        return identity;
    }

    public TRSRTransformation compose(TRSRTransformation b) {
        if (this.isIdentity()) {
            return b;
        }
        if (b.isIdentity()) {
            return this;
        }
        Matrix4f m = this.getMatrixVec();
        m.mul(b.getMatrixVec());
        return new TRSRTransformation(m);
    }

    public TRSRTransformation inverse() {
        if (this.isIdentity()) {
            return this;
        }
        Matrix4f m = this.getMatrixVec();
        m.invert();
        return new TRSRTransformation(m);
    }

    private void genCheck() {
        if (!this.full) {
            Pair<Matrix3f, Vector3f> pair = TRSRTransformation.toAffine(this.matrix);
            Triple<Quat4f, Vector3f, Quat4f> triple = TRSRTransformation.svdDecompose((Matrix3f)pair.getLeft());
            this.translation = (Vector3f)pair.getRight();
            this.leftRot = (Quat4f)triple.getLeft();
            this.scale = (Vector3f)triple.getMiddle();
            this.rightRot = (Quat4f)triple.getRight();
            this.full = true;
        }
    }

    public static Quat4f quatFromYXZ(float y, float x, float z) {
        Quat4f ret = new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        Quat4f t = new Quat4f();
        t.set(0.0f, (float)Math.sin(y / 2.0f), 0.0f, (float)Math.cos(y / 2.0f));
        ret.mul(t);
        t.set((float)Math.sin(x / 2.0f), 0.0f, 0.0f, (float)Math.cos(x / 2.0f));
        ret.mul(t);
        t.set(0.0f, 0.0f, (float)Math.sin(z / 2.0f), (float)Math.cos(z / 2.0f));
        ret.mul(t);
        return ret;
    }

    public static Quat4f quatFromXYZDegrees(Vector3f xyz) {
        return TRSRTransformation.quatFromXYZ((float)Math.toRadians(xyz.x), (float)Math.toRadians(xyz.y), (float)Math.toRadians(xyz.z));
    }

    public static Quat4f quatFromXYZ(Vector3f xyz) {
        return TRSRTransformation.quatFromXYZ(xyz.x, xyz.y, xyz.z);
    }

    public static Quat4f quatFromXYZ(float x, float y, float z) {
        Quat4f ret = new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        Quat4f t = new Quat4f();
        t.set((float)Math.sin(x / 2.0f), 0.0f, 0.0f, (float)Math.cos(x / 2.0f));
        ret.mul(t);
        t.set(0.0f, (float)Math.sin(y / 2.0f), 0.0f, (float)Math.cos(y / 2.0f));
        ret.mul(t);
        t.set(0.0f, 0.0f, (float)Math.sin(z / 2.0f), (float)Math.cos(z / 2.0f));
        ret.mul(t);
        return ret;
    }

    public static Vector3f toYXZDegrees(Quat4f q) {
        Vector3f yxz = TRSRTransformation.toYXZ(q);
        return new Vector3f((float)Math.toDegrees(yxz.x), (float)Math.toDegrees(yxz.y), (float)Math.toDegrees(yxz.z));
    }

    public static Vector3f toYXZ(Quat4f q) {
        float w2 = q.w * q.w;
        float x2 = q.x * q.x;
        float y2 = q.y * q.y;
        float z2 = q.z * q.z;
        float l = w2 + x2 + y2 + z2;
        float sx = 2.0f * q.w * q.x - 2.0f * q.y * q.z;
        float x = (float)Math.asin(sx / l);
        if (Math.abs(sx) > 0.999f * l) {
            return new Vector3f(x, 2.0f * (float)Math.atan2(q.y, q.w), 0.0f);
        }
        return new Vector3f(x, (float)Math.atan2(2.0f * q.x * q.z + 2.0f * q.y * q.w, w2 - x2 - y2 + z2), (float)Math.atan2(2.0f * q.x * q.y + 2.0f * q.w * q.z, w2 - x2 + y2 - z2));
    }

    public static Vector3f toXYZDegrees(Quat4f q) {
        Vector3f xyz = TRSRTransformation.toXYZ(q);
        return new Vector3f((float)Math.toDegrees(xyz.x), (float)Math.toDegrees(xyz.y), (float)Math.toDegrees(xyz.z));
    }

    public static Vector3f toXYZ(Quat4f q) {
        float w2 = q.w * q.w;
        float x2 = q.x * q.x;
        float y2 = q.y * q.y;
        float z2 = q.z * q.z;
        float l = w2 + x2 + y2 + z2;
        float sy = 2.0f * q.w * q.x - 2.0f * q.y * q.z;
        float y = (float)Math.asin(sy / l);
        if (Math.abs(sy) > 0.999f * l) {
            return new Vector3f(2.0f * (float)Math.atan2(q.x, q.w), y, 0.0f);
        }
        return new Vector3f((float)Math.atan2(2.0f * q.y * q.z + 2.0f * q.x * q.w, w2 - x2 - y2 + z2), y, (float)Math.atan2(2.0f * q.x * q.y + 2.0f * q.w * q.z, w2 + x2 - y2 - z2));
    }

    public static Matrix4f mul(@Nullable Vector3f translation, @Nullable Quat4f leftRot, @Nullable Vector3f scale, @Nullable Quat4f rightRot) {
        Matrix4f res = new Matrix4f();
        Matrix4f t = new Matrix4f();
        res.setIdentity();
        if (leftRot != null) {
            t.set(leftRot);
            res.mul(t);
        }
        if (scale != null) {
            t.setIdentity();
            t.m00 = scale.x;
            t.m11 = scale.y;
            t.m22 = scale.z;
            res.mul(t);
        }
        if (rightRot != null) {
            t.set(rightRot);
            res.mul(t);
        }
        if (translation != null) {
            res.setTranslation(translation);
        }
        return res;
    }

    public static Triple<Quat4f, Vector3f, Quat4f> svdDecompose(Matrix3f m) {
        Quat4f u = new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        Quat4f v = new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        Quat4f qt = new Quat4f();
        Matrix3f b = new Matrix3f(m);
        Matrix3f t = new Matrix3f();
        t.transpose(m);
        b.mul(t, b);
        for (int i = 0; i < 5; ++i) {
            v.mul(TRSRTransformation.stepJacobi(b));
        }
        v.normalize();
        t.set(v);
        b.set(m);
        b.mul(t);
        float ul = 1.0f;
        Pair<Float, Float> p = TRSRTransformation.qrGivensQuat(b.m00, b.m10);
        qt.set(0.0f, 0.0f, ((Float)p.getLeft()).floatValue(), ((Float)p.getRight()).floatValue());
        u.mul(qt);
        t.setIdentity();
        t.m11 = t.m00 = qt.w * qt.w - qt.z * qt.z;
        t.m10 = -2.0f * qt.z * qt.w;
        t.m01 = -t.m10;
        t.m22 = qt.w * qt.w + qt.z * qt.z;
        ul *= t.m22;
        b.mul(t, b);
        p = TRSRTransformation.qrGivensQuat(b.m00, b.m20);
        qt.set(0.0f, -((Float)p.getLeft()).floatValue(), 0.0f, ((Float)p.getRight()).floatValue());
        u.mul(qt);
        t.setIdentity();
        t.m22 = t.m00 = qt.w * qt.w - qt.y * qt.y;
        t.m20 = 2.0f * qt.y * qt.w;
        t.m02 = -t.m20;
        t.m11 = qt.w * qt.w + qt.y * qt.y;
        ul *= t.m11;
        b.mul(t, b);
        p = TRSRTransformation.qrGivensQuat(b.m11, b.m21);
        qt.set(((Float)p.getLeft()).floatValue(), 0.0f, 0.0f, ((Float)p.getRight()).floatValue());
        u.mul(qt);
        t.setIdentity();
        t.m22 = t.m11 = qt.w * qt.w - qt.x * qt.x;
        t.m21 = -2.0f * qt.x * qt.w;
        t.m12 = -t.m21;
        t.m00 = qt.w * qt.w + qt.x * qt.x;
        ul *= t.m00;
        b.mul(t, b);
        ul = 1.0f / ul;
        u.scale((float)Math.sqrt(ul));
        Vector3f s = new Vector3f(b.m00 * ul, b.m11 * ul, b.m22 * ul);
        return Triple.of((Object)u, (Object)s, (Object)v);
    }

    private static float rsqrt(float f) {
        float f2 = 0.5f * f;
        int i = Float.floatToIntBits(f);
        i = 1597463007 - (i >> 1);
        f = Float.intBitsToFloat(i);
        f *= 1.5f - f2 * f * f;
        return f;
    }

    private static Pair<Float, Float> approxGivensQuat(float a11, float a12, float a22) {
        float sh = a12;
        float ch = 2.0f * (a11 - a22);
        boolean b = g * sh * sh < ch * ch;
        float w = TRSRTransformation.rsqrt(sh * sh + ch * ch);
        ch = b ? w * ch : cs;
        sh = b ? w * sh : ss;
        return Pair.of((Object)Float.valueOf(sh), (Object)Float.valueOf(ch));
    }

    private static final void swapNeg(Matrix3f m, int i, int j) {
        float[] t = new float[3];
        m.getColumn(j, t);
        for (int k = 0; k < 3; ++k) {
            m.setElement(k, j, -m.getElement(k, i));
        }
        m.setColumn(i, t);
    }

    private static void sortSingularValues(Matrix3f b, Quat4f v) {
        float f;
        float p0 = b.m00 * b.m00 + b.m10 * b.m10 + b.m20 * b.m20;
        float p1 = b.m01 * b.m01 + b.m11 * b.m11 + b.m21 * b.m21;
        float p2 = b.m02 * b.m02 + b.m12 * b.m12 + b.m22 * b.m22;
        Quat4f t = new Quat4f();
        if (p0 < p1) {
            TRSRTransformation.swapNeg(b, 0, 1);
            t.set(0.0f, 0.0f, sq2, sq2);
            v.mul(t);
            f = p0;
            p0 = p1;
            p1 = f;
        }
        if (p0 < p2) {
            TRSRTransformation.swapNeg(b, 0, 2);
            t.set(0.0f, sq2, 0.0f, sq2);
            v.mul(t);
            f = p0;
            p0 = p2;
            p2 = f;
        }
        if (p1 < p2) {
            TRSRTransformation.swapNeg(b, 1, 2);
            t.set(sq2, 0.0f, 0.0f, sq2);
            v.mul(t);
        }
    }

    private static Pair<Float, Float> qrGivensQuat(float a1, float a2) {
        float p = (float)Math.sqrt(a1 * a1 + a2 * a2);
        float sh = p > 1.0E-6f ? a2 : 0.0f;
        float ch = Math.abs(a1) + Math.max(p, 1.0E-6f);
        if (a1 < 0.0f) {
            float f = sh;
            sh = ch;
            ch = f;
        }
        float w = TRSRTransformation.rsqrt(ch * ch + sh * sh);
        return Pair.of((Object)Float.valueOf(sh *= w), (Object)Float.valueOf(ch *= w));
    }

    private static Quat4f stepJacobi(Matrix3f m) {
        Pair<Float, Float> p;
        Matrix3f t = new Matrix3f();
        Quat4f qt = new Quat4f();
        Quat4f ret = new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
        if (m.m01 * m.m01 + m.m10 * m.m10 > 1.0E-6f) {
            p = TRSRTransformation.approxGivensQuat(m.m00, 0.5f * (m.m01 + m.m10), m.m11);
            qt.set(0.0f, 0.0f, ((Float)p.getLeft()).floatValue(), ((Float)p.getRight()).floatValue());
            ret.mul(qt);
            t.setIdentity();
            t.m11 = t.m00 = qt.w * qt.w - qt.z * qt.z;
            t.m10 = 2.0f * qt.z * qt.w;
            t.m01 = -t.m10;
            t.m22 = qt.w * qt.w + qt.z * qt.z;
            m.mul(m, t);
            t.transpose();
            m.mul(t, m);
        }
        if (m.m02 * m.m02 + m.m20 * m.m20 > 1.0E-6f) {
            p = TRSRTransformation.approxGivensQuat(m.m00, 0.5f * (m.m02 + m.m20), m.m22);
            qt.set(0.0f, -((Float)p.getLeft()).floatValue(), 0.0f, ((Float)p.getRight()).floatValue());
            ret.mul(qt);
            t.setIdentity();
            t.m22 = t.m00 = qt.w * qt.w - qt.y * qt.y;
            t.m20 = -2.0f * qt.y * qt.w;
            t.m02 = -t.m20;
            t.m11 = qt.w * qt.w + qt.y * qt.y;
            m.mul(m, t);
            t.transpose();
            m.mul(t, m);
        }
        if (m.m12 * m.m12 + m.m21 * m.m21 > 1.0E-6f) {
            p = TRSRTransformation.approxGivensQuat(m.m11, 0.5f * (m.m12 + m.m21), m.m22);
            qt.set(((Float)p.getLeft()).floatValue(), 0.0f, 0.0f, ((Float)p.getRight()).floatValue());
            ret.mul(qt);
            t.setIdentity();
            t.m22 = t.m11 = qt.w * qt.w - qt.x * qt.x;
            t.m21 = 2.0f * qt.x * qt.w;
            t.m12 = -t.m21;
            t.m00 = qt.w * qt.w + qt.x * qt.x;
            m.mul(m, t);
            t.transpose();
            m.mul(t, m);
        }
        return ret;
    }

    public static Pair<Matrix3f, Vector3f> toAffine(Matrix4f m) {
        m.mul(1.0f / m.m33);
        Vector3f trans = new Vector3f(m.m03, m.m13, m.m23);
        Matrix3f linear = new Matrix3f(m.m00, m.m01, m.m02, m.m10, m.m11, m.m12, m.m20, m.m21, m.m22);
        return Pair.of((Object)linear, (Object)trans);
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public ItemTransformVec3f toItemTransform() {
        return new ItemTransformVec3f(TRSRTransformation.toMojang(TRSRTransformation.toXYZDegrees(this.getLeftRot())), TRSRTransformation.toMojang(this.getTranslation()), TRSRTransformation.toMojang(this.getScale()));
    }

    public boolean isIdentity() {
        return this.equals(identity);
    }

    @Override
    public Matrix4f getMatrixVec() {
        return (Matrix4f)this.matrix.clone();
    }

    public Vector3f getTranslation() {
        this.genCheck();
        return (Vector3f)this.translation.clone();
    }

    public Quat4f getLeftRot() {
        this.genCheck();
        return (Quat4f)this.leftRot.clone();
    }

    public Vector3f getScale() {
        this.genCheck();
        return (Vector3f)this.scale.clone();
    }

    public Quat4f getRightRot() {
        this.genCheck();
        return (Quat4f)this.rightRot.clone();
    }

    @Override
    public Optional<TRSRTransformation> apply(Optional<? extends IModelPart> part) {
        if (part.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(this);
    }

    @Override
    public Direction rotate(Direction facing) {
        return TRSRTransformation.rotate(this.matrix, facing);
    }

    public static Direction rotate(Matrix4f matrix, Direction facing) {
        Vec3i dir = facing.func_176730_m();
        Vector4f vec = new Vector4f((float)dir.func_177958_n(), (float)dir.func_177956_o(), (float)dir.func_177952_p(), 0.0f);
        matrix.transform((Tuple4f)vec);
        return Direction.func_176737_a((float)vec.x, (float)vec.y, (float)vec.z);
    }

    public static boolean isInteger(Matrix4f matrix) {
        Matrix4f m = new Matrix4f();
        m.setIdentity();
        m.m32 = 1.0f;
        m.m31 = 1.0f;
        m.m30 = 1.0f;
        m.m33 = 0.0f;
        m.mul(matrix, m);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                float v = m.getElement(i, j) / m.getElement(3, j);
                if (!((double)Math.abs(v - (float)Math.round(v)) > 1.0E-5)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int rotate(Direction facing, int vertexIndex) {
        return vertexIndex;
    }

    public void transformPosition(Vector4f position) {
        this.matrix.transform((Tuple4f)position);
    }

    public void transformNormal(Vector3f normal) {
        this.checkNormalTransform();
        this.normalTransform.transform((Tuple3f)normal);
        normal.normalize();
    }

    private void checkNormalTransform() {
        if (this.normalTransform == null) {
            this.normalTransform = new Matrix3f();
            this.matrix.getRotationScale(this.normalTransform);
            this.normalTransform.invert();
            this.normalTransform.transpose();
        }
    }

    public String toString() {
        this.genCheck();
        return MoreObjects.toStringHelper(this.getClass()).add("matrix", (Object)this.matrix).add("translation", (Object)this.translation).add("leftRot", (Object)this.leftRot).add("scale", (Object)this.scale).add("rightRot", (Object)this.rightRot).toString();
    }

    public static TRSRTransformation blockCenterToCorner(TRSRTransformation transform) {
        if (transform.isIdentity()) {
            return transform;
        }
        Matrix4f ret = new Matrix4f(transform.getMatrixVec());
        Matrix4f tmp = new Matrix4f();
        tmp.setIdentity();
        tmp.m23 = 0.5f;
        tmp.m13 = 0.5f;
        tmp.m03 = 0.5f;
        ret.mul(tmp, ret);
        tmp.m23 = -0.5f;
        tmp.m13 = -0.5f;
        tmp.m03 = -0.5f;
        ret.mul(tmp);
        return new TRSRTransformation(ret);
    }

    public static TRSRTransformation blockCornerToCenter(TRSRTransformation transform) {
        if (transform.isIdentity()) {
            return transform;
        }
        Matrix4f ret = new Matrix4f(transform.getMatrixVec());
        Matrix4f tmp = new Matrix4f();
        tmp.setIdentity();
        tmp.m23 = -0.5f;
        tmp.m13 = -0.5f;
        tmp.m03 = -0.5f;
        ret.mul(tmp, ret);
        tmp.m23 = 0.5f;
        tmp.m13 = 0.5f;
        tmp.m03 = 0.5f;
        ret.mul(tmp);
        return new TRSRTransformation(ret);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.matrix);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TRSRTransformation other = (TRSRTransformation)obj;
        return Objects.equals(this.matrix, other.matrix);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Vector3f toVecmath(net.minecraft.client.renderer.Vector3f vec) {
        return new Vector3f(vec.func_195899_a(), vec.func_195900_b(), vec.func_195902_c());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Vector4f toVecmath(net.minecraft.client.renderer.Vector4f vec) {
        return new Vector4f(vec.func_195910_a(), vec.func_195913_b(), vec.func_195914_c(), vec.func_195915_d());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Matrix4f toVecmath(net.minecraft.client.renderer.Matrix4f m) {
        return new Matrix4f(m.get(0, 0), m.get(1, 0), m.get(2, 0), m.get(3, 0), m.get(0, 1), m.get(1, 1), m.get(2, 1), m.get(3, 1), m.get(0, 2), m.get(1, 2), m.get(2, 2), m.get(3, 2), m.get(0, 3), m.get(1, 3), m.get(2, 3), m.get(3, 3));
    }

    public static Quat4f toVecmath(Quaternion q) {
        return new Quat4f(q.func_195889_a(), q.func_195891_b(), q.func_195893_c(), q.func_195894_d());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static net.minecraft.client.renderer.Vector3f toMojang(Vector3f vec) {
        return new net.minecraft.client.renderer.Vector3f(vec.x, vec.y, vec.z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static net.minecraft.client.renderer.Vector4f toMojang(Vector4f vec) {
        return new net.minecraft.client.renderer.Vector4f(vec.x, vec.y, vec.z, vec.w);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static net.minecraft.client.renderer.Matrix4f toMojang(Matrix4f m) {
        net.minecraft.client.renderer.Matrix4f r = new net.minecraft.client.renderer.Matrix4f();
        float[] row = new float[4];
        for (int x = 0; x < 4; ++x) {
            m.getRow(x, row);
            for (int y = 0; y < 4; ++y) {
                r.func_195878_a(x, y, row[y]);
            }
        }
        return r;
    }

    public static Vector3f lerp(Tuple3f from, Tuple3f to, float progress) {
        Vector3f res = new Vector3f(from);
        res.interpolate(from, to, progress);
        return res;
    }

    public static Vector4f lerp(Tuple4f from, Tuple4f to, float progress) {
        Vector4f res = new Vector4f(from);
        res.interpolate(from, to, progress);
        return res;
    }

    public static Quat4f slerp(Quat4f from, Quat4f to, float progress) {
        Quat4f res = new Quat4f();
        res.interpolate(from, to, progress);
        return res;
    }

    public TRSRTransformation slerp(TRSRTransformation that, float progress) {
        return new TRSRTransformation(TRSRTransformation.lerp((Tuple3f)this.getTranslation(), (Tuple3f)that.getTranslation(), progress), TRSRTransformation.slerp(this.getLeftRot(), that.getLeftRot(), progress), TRSRTransformation.lerp((Tuple3f)this.getScale(), (Tuple3f)that.getScale(), progress), TRSRTransformation.slerp(this.getRightRot(), that.getRightRot(), progress));
    }

    public static TRSRTransformation getVanillaUvTransformLocalToGlobal(Direction side) {
        return vanillaUvTransformLocalToGlobal.get(side);
    }

    public static TRSRTransformation getVanillaUvTransformGlobalToLocal(Direction side) {
        return vanillaUvTransformGlobalToLocal.get(side);
    }

    public TRSRTransformation getUVLockTransform(Direction originalSide) {
        Direction newSide = this.rotate(originalSide);
        try {
            return TRSRTransformation.blockCenterToCorner(vanillaUvTransformGlobalToLocal.get(originalSide).compose(TRSRTransformation.blockCornerToCenter(this.inverse())).compose(vanillaUvTransformLocalToGlobal.get(newSide)));
        }
        catch (SingularMatrixException e) {
            return new TRSRTransformation(null, null, new Vector3f(0.0f, 0.0f, 0.0f), null);
        }
    }

    static {
        Matrix4f m = new Matrix4f();
        m.setIdentity();
        identity = new TRSRTransformation(m);
        identity.getLeftRot();
        g = 3.0f + 2.0f * (float)Math.sqrt(2.0);
        cs = (float)Math.cos(0.39269908169872414);
        ss = (float)Math.sin(0.39269908169872414);
        sq2 = 1.0f / (float)Math.sqrt(2.0);
        vanillaUvTransformLocalToGlobal = Maps.newEnumMap(Direction.class);
        vanillaUvTransformGlobalToLocal = Maps.newEnumMap(Direction.class);
        vanillaUvTransformLocalToGlobal.put(Direction.SOUTH, identity);
        Quat4f tmp = new Quat4f();
        tmp.set(new AxisAngle4f(0.0f, 1.0f, 0.0f, (float)Math.toRadians(90.0)));
        vanillaUvTransformLocalToGlobal.put(Direction.EAST, new TRSRTransformation(null, new Quat4f(tmp), null, null));
        tmp.set(new AxisAngle4f(0.0f, 1.0f, 0.0f, (float)Math.toRadians(-90.0)));
        vanillaUvTransformLocalToGlobal.put(Direction.WEST, new TRSRTransformation(null, new Quat4f(tmp), null, null));
        tmp.set(new AxisAngle4f(0.0f, 1.0f, 0.0f, (float)Math.toRadians(180.0)));
        vanillaUvTransformLocalToGlobal.put(Direction.NORTH, new TRSRTransformation(null, new Quat4f(tmp), null, null));
        tmp.set(new AxisAngle4f(1.0f, 0.0f, 0.0f, (float)Math.toRadians(-90.0)));
        vanillaUvTransformLocalToGlobal.put(Direction.UP, new TRSRTransformation(null, new Quat4f(tmp), null, null));
        tmp.set(new AxisAngle4f(1.0f, 0.0f, 0.0f, (float)Math.toRadians(90.0)));
        vanillaUvTransformLocalToGlobal.put(Direction.DOWN, new TRSRTransformation(null, new Quat4f(tmp), null, null));
        for (Direction side : Direction.values()) {
            vanillaUvTransformGlobalToLocal.put(side, vanillaUvTransformLocalToGlobal.get(side).inverse());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static final class Cache {
        private static final Map<ModelRotation, TRSRTransformation> rotations = new EnumMap<ModelRotation, TRSRTransformation>(ModelRotation.class);

        private Cache() {
        }

        static TRSRTransformation get(ModelRotation rotation) {
            return rotations.computeIfAbsent(rotation, r -> new TRSRTransformation(ForgeHooksClient.getMatrix(r)));
        }

        static {
            rotations.put(ModelRotation.X0_Y0, TRSRTransformation.identity());
        }
    }
}

