/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.LanguageMap;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Fluid {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int BUCKET_VOLUME = 1000;
    protected final String fluidName;
    protected String unlocalizedName;
    protected final ResourceLocation still;
    protected final ResourceLocation flowing;
    @Nullable
    protected final ResourceLocation overlay;
    private SoundEvent fillSound;
    private SoundEvent emptySound;
    protected int luminosity = 0;
    protected int density = 1000;
    protected int temperature = 300;
    protected int viscosity = 1000;
    protected boolean isGaseous;
    protected Rarity rarity = Rarity.COMMON;
    protected Block block = null;
    protected int color = -1;

    public Fluid(String fluidName, ResourceLocation still, ResourceLocation flowing, int color) {
        this(fluidName, still, flowing, null, color);
    }

    public Fluid(String fluidName, ResourceLocation still, ResourceLocation flowing, @Nullable ResourceLocation overlay, int color) {
        this(fluidName, still, flowing, overlay);
        this.setColor(color);
    }

    public Fluid(String fluidName, ResourceLocation still, ResourceLocation flowing) {
        this(fluidName, still, flowing, null);
    }

    public Fluid(String fluidName, ResourceLocation still, ResourceLocation flowing, @Nullable ResourceLocation overlay) {
        this.fluidName = fluidName.toLowerCase(Locale.ENGLISH);
        this.unlocalizedName = fluidName;
        this.still = still;
        this.flowing = flowing;
        this.overlay = overlay;
    }

    public Fluid setUnlocalizedName(String unlocalizedName) {
        this.unlocalizedName = unlocalizedName;
        return this;
    }

    public Fluid setBlock(Block block) {
        if (this.block == null || this.block == block) {
            this.block = block;
        } else {
            LOGGER.warn("A mod has attempted to assign Block {} to the Fluid '{}' but this Fluid has already been linked to the Block {}. You may have duplicate Fluid Blocks as a result. It *may* be possible to configure your mods to avoid this.", (Object)block, (Object)this.fluidName, (Object)this.block);
        }
        return this;
    }

    public Fluid setLuminosity(int luminosity) {
        this.luminosity = luminosity;
        return this;
    }

    public Fluid setDensity(int density) {
        this.density = density;
        return this;
    }

    public Fluid setTemperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public Fluid setViscosity(int viscosity) {
        this.viscosity = viscosity;
        return this;
    }

    public Fluid setGaseous(boolean isGaseous) {
        this.isGaseous = isGaseous;
        return this;
    }

    public Fluid setRarity(Rarity rarity) {
        this.rarity = rarity;
        return this;
    }

    public Fluid setFillSound(SoundEvent fillSound) {
        this.fillSound = fillSound;
        return this;
    }

    public Fluid setEmptySound(SoundEvent emptySound) {
        this.emptySound = emptySound;
        return this;
    }

    public Fluid setColor(int color) {
        this.color = color;
        return this;
    }

    public final String getName() {
        return this.fluidName;
    }

    public final Block getBlock() {
        return this.block;
    }

    public final boolean canBePlacedInWorld() {
        return this.block != null;
    }

    public final boolean isLighterThanAir() {
        return this.density <= 0;
    }

    public boolean doesVaporize(FluidStack fluidStack) {
        if (this.block == null) {
            return false;
        }
        return this.block.func_176223_P().func_185904_a() == Material.field_151586_h;
    }

    public void vaporize(@Nullable PlayerEntity player, World worldIn, BlockPos pos, FluidStack fluidStack) {
        worldIn.func_184133_a(player, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
        for (int l = 0; l < 8; ++l) {
            worldIn.func_195589_b((IParticleData)ParticleTypes.field_197594_E, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0);
        }
    }

    public String getLocalizedName(FluidStack stack) {
        String s = this.getUnlocalizedName();
        return s == null ? "" : LanguageMap.func_74808_a().func_74805_b(s);
    }

    public String getUnlocalizedName(FluidStack stack) {
        return this.getUnlocalizedName();
    }

    public String getUnlocalizedName() {
        return "fluid." + this.unlocalizedName;
    }

    public final int getLuminosity() {
        return this.luminosity;
    }

    public final int getDensity() {
        return this.density;
    }

    public final int getTemperature() {
        return this.temperature;
    }

    public final int getViscosity() {
        return this.viscosity;
    }

    public final boolean isGaseous() {
        return this.isGaseous;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public int getColor() {
        return this.color;
    }

    public ResourceLocation getStill() {
        return this.still;
    }

    public ResourceLocation getFlowing() {
        return this.flowing;
    }

    @Nullable
    public ResourceLocation getOverlay() {
        return this.overlay;
    }

    public SoundEvent getFillSound() {
        if (this.fillSound == null) {
            this.fillSound = this.getBlock() != null && this.getBlock().func_176223_P().func_185904_a() == Material.field_151587_i ? SoundEvents.field_187633_N : SoundEvents.field_187630_M;
        }
        return this.fillSound;
    }

    public SoundEvent getEmptySound() {
        if (this.emptySound == null) {
            this.emptySound = this.getBlock() != null && this.getBlock().func_176223_P().func_185904_a() == Material.field_151587_i ? SoundEvents.field_187627_L : SoundEvents.field_187624_K;
        }
        return this.emptySound;
    }

    public int getLuminosity(FluidStack stack) {
        return this.getLuminosity();
    }

    public int getDensity(FluidStack stack) {
        return this.getDensity();
    }

    public int getTemperature(FluidStack stack) {
        return this.getTemperature();
    }

    public int getViscosity(FluidStack stack) {
        return this.getViscosity();
    }

    public boolean isGaseous(FluidStack stack) {
        return this.isGaseous();
    }

    public Rarity getRarity(FluidStack stack) {
        return this.getRarity();
    }

    public int getColor(FluidStack stack) {
        return this.getColor();
    }

    public ResourceLocation getStill(FluidStack stack) {
        return this.getStill();
    }

    public ResourceLocation getFlowing(FluidStack stack) {
        return this.getFlowing();
    }

    public SoundEvent getFillSound(FluidStack stack) {
        return this.getFillSound();
    }

    public SoundEvent getEmptySound(FluidStack stack) {
        return this.getEmptySound();
    }

    public int getLuminosity(World world, BlockPos pos) {
        return this.getLuminosity();
    }

    public int getDensity(World world, BlockPos pos) {
        return this.getDensity();
    }

    public int getTemperature(World world, BlockPos pos) {
        return this.getTemperature();
    }

    public int getViscosity(World world, BlockPos pos) {
        return this.getViscosity();
    }

    public boolean isGaseous(World world, BlockPos pos) {
        return this.isGaseous();
    }

    public Rarity getRarity(World world, BlockPos pos) {
        return this.getRarity();
    }

    public int getColor(World world, BlockPos pos) {
        return this.getColor();
    }

    public ResourceLocation getStill(World world, BlockPos pos) {
        return this.getStill();
    }

    public ResourceLocation getFlowing(World world, BlockPos pos) {
        return this.getFlowing();
    }

    public SoundEvent getFillSound(World world, BlockPos pos) {
        return this.getFillSound();
    }

    public SoundEvent getEmptySound(World world, BlockPos pos) {
        return this.getEmptySound();
    }
}

