/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.translation.LanguageMap;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.DispenseFluidContainer;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.items.ItemHandlerHelper;

public class UniversalBucket
extends Item {
    private final int capacity;
    @Nonnull
    private final ItemStack empty;
    private final boolean nbtSensitive;

    public UniversalBucket(Item.Properties properties) {
        this(properties, 1000, new ItemStack((IItemProvider)Items.field_151133_ar), false);
    }

    public UniversalBucket(Item.Properties properties, int capacity, @Nonnull ItemStack empty, boolean nbtSensitive) {
        super(properties);
        this.capacity = capacity;
        this.empty = empty;
        this.nbtSensitive = nbtSensitive;
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)DispenseFluidContainer.getInstance());
    }

    public boolean hasContainerItem(@Nonnull ItemStack stack) {
        return !this.getEmpty().func_190926_b();
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack itemStack) {
        if (!this.getEmpty().func_190926_b()) {
            return this.getEmpty().func_77946_l();
        }
        return super.getContainerItem(itemStack);
    }

    public void func_150895_a(@Nullable ItemGroup tab, @Nonnull NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack == null) {
            if (!this.getEmpty().func_190926_b()) {
                return this.getEmpty().func_200301_q();
            }
            return super.func_200295_i(stack);
        }
        String unloc = this.func_77658_a();
        if (LanguageMap.func_74808_a().func_210813_b(unloc + "." + fluidStack.getFluid().getName())) {
            return new TranslationTextComponent(unloc + "." + fluidStack.getFluid().getName(), new Object[0]);
        }
        return new TranslationTextComponent(unloc + ".name", new Object[]{fluidStack.getLocalizedName()});
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull PlayerEntity player, @Nonnull Hand hand) {
        FluidActionResult result;
        BlockPos targetPos;
        ItemStack itemstack = player.func_184586_b(hand);
        FluidStack fluidStack = this.getFluid(itemstack);
        if (fluidStack == null) {
            return new ActionResult(ActionResultType.PASS, (Object)itemstack);
        }
        RayTraceResult rt = UniversalBucket.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
        ActionResult<ItemStack> ret = ForgeEventFactory.onBucketUse(player, world, itemstack, rt);
        if (ret != null) {
            return ret;
        }
        if (rt == null || rt.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return new ActionResult(ActionResultType.PASS, (Object)itemstack);
        }
        BlockRayTraceResult brt = (BlockRayTraceResult)rt;
        BlockPos clickPos = brt.func_216350_a();
        if (world.func_175660_a(player, clickPos) && player.func_175151_a(targetPos = clickPos.func_177972_a(brt.func_216354_b()), brt.func_216354_b(), itemstack) && (result = FluidUtil.tryPlaceFluid(player, world, hand, targetPos, itemstack, fluidStack)).isSuccess() && !player.field_71075_bZ.field_75098_d) {
            ItemStack emptyStack;
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            itemstack.func_190918_g(1);
            ItemStack drained = result.getResult();
            ItemStack itemStack = emptyStack = !drained.func_190926_b() ? drained.func_77946_l() : new ItemStack((IItemProvider)this);
            if (itemstack.func_190926_b()) {
                return new ActionResult(ActionResultType.SUCCESS, (Object)emptyStack);
            }
            ItemHandlerHelper.giveItemToPlayer(player, emptyStack);
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)itemstack);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onFillBucket(FillBucketEvent event) {
        if (event.getResult() != Event.Result.DEFAULT) {
            return;
        }
        ItemStack emptyBucket = event.getEmptyBucket();
        if (emptyBucket.func_190926_b() || !emptyBucket.func_77969_a(this.getEmpty()) || this.isNbtSensitive() && ItemStack.func_77970_a((ItemStack)emptyBucket, (ItemStack)this.getEmpty())) {
            return;
        }
        RayTraceResult target = event.getTarget();
        if (target == null || target.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        World world = event.getWorld();
        BlockPos pos = ((BlockRayTraceResult)target).func_216350_a();
        ItemStack singleBucket = emptyBucket.func_77946_l();
        singleBucket.func_190920_e(1);
        FluidActionResult filledResult = FluidUtil.tryPickUpFluid(singleBucket, event.getEntityPlayer(), world, pos, ((BlockRayTraceResult)target).func_216354_b());
        if (filledResult.isSuccess()) {
            event.setResult(Event.Result.ALLOW);
            event.setFilledBucket(filledResult.getResult());
        } else {
            event.setCanceled(true);
        }
    }

    @Nullable
    public FluidStack getFluid(@Nonnull ItemStack container) {
        return FluidStack.loadFluidStackFromNBT(container.func_77978_p());
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Nonnull
    public ItemStack getEmpty() {
        return this.empty;
    }

    public boolean isNbtSensitive() {
        return this.nbtSensitive;
    }

    @Nullable
    public String getCreatorModId(@Nonnull ItemStack itemStack) {
        FluidStack fluidStack = this.getFluid(itemStack);
        String modId = null;
        return modId != null ? modId : super.getCreatorModId(itemStack);
    }

    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, CompoundNBT nbt) {
        return new FluidBucketWrapper(stack);
    }
}

