/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import java.util.concurrent.Callable;
import java.util.function.Supplier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;

public final class DistExecutor {
    private DistExecutor() {
    }

    public static <T> T callWhenOn(Dist dist, Supplier<Callable<T>> toRun) {
        if (dist == FMLEnvironment.dist) {
            try {
                return toRun.get().call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static void runWhenOn(Dist dist, Supplier<Runnable> toRun) {
        if (dist == FMLEnvironment.dist) {
            toRun.get().run();
        }
    }

    public static <T> T runForDist(Supplier<Supplier<T>> clientTarget, Supplier<Supplier<T>> serverTarget) {
        switch (FMLEnvironment.dist) {
            case CLIENT: {
                return clientTarget.get().get();
            }
            case DEDICATED_SERVER: {
                return serverTarget.get().get();
            }
        }
        throw new IllegalArgumentException("UNSIDED?");
    }
}

