/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;

public final class RegistryObject<T extends ForgeRegistryEntry<? super T>> {
    private final String name;
    private final IForgeRegistry<?> owningRegistry;
    private T value;
    private boolean searched;
    private static RegistryObject<?> EMPTY = new RegistryObject();

    public static <T extends ForgeRegistryEntry<T>, U extends T> RegistryObject<U> of(String name, Supplier<Class<? super T>> registryType) {
        return new RegistryObject<T>(name, registryType);
    }

    private static <T extends ForgeRegistryEntry<? super T>> RegistryObject<T> empty() {
        RegistryObject<?> t = EMPTY;
        return t;
    }

    private RegistryObject() {
        this.searched = true;
        this.name = "";
        this.owningRegistry = null;
    }

    private <V extends ForgeRegistryEntry<V>> RegistryObject(String name, Supplier<Class<? super V>> registryType) {
        IForgeRegistry<? super V> registry;
        this.name = name;
        try {
            registry = RegistryManager.ACTIVE.getRegistry(registryType.get());
        }
        catch (Throwable t) {
            registry = null;
        }
        this.owningRegistry = registry;
    }

    private T getValue() {
        if (!this.searched) {
            if (this.owningRegistry != null) {
                this.value = (ForgeRegistryEntry)this.owningRegistry.getValue(new ResourceLocation(this.name));
            }
            this.searched = true;
        }
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public Stream<T> stream() {
        return this.isPresent() ? Stream.of(this.getValue()) : Stream.of(new ForgeRegistryEntry[0]);
    }

    public boolean isPresent() {
        return this.getValue() != null;
    }

    public void ifPresent(Consumer<? super T> consumer) {
        if (this.getValue() != null) {
            consumer.accept(this.getValue());
        }
    }

    public RegistryObject<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (!this.isPresent()) {
            return this;
        }
        return predicate.test(this.getValue()) ? this : RegistryObject.empty();
    }

    public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isPresent()) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(this.getValue()));
    }

    public <U> Optional<U> flatMap(Function<? super T, Optional<U>> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isPresent()) {
            return Optional.empty();
        }
        return Objects.requireNonNull(mapper.apply(this.getValue()));
    }

    public T orElse(T other) {
        return this.getValue() != null ? this.getValue() : other;
    }

    public T orElseGet(Supplier<? extends T> other) {
        return (T)(this.getValue() != null ? this.getValue() : (ForgeRegistryEntry)other.get());
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.getValue() != null) {
            return this.getValue();
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RegistryObject) {
            return Objects.equals(((RegistryObject)obj).name, this.name);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.name);
    }
}

