/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockModelDefinition;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.BlockPartRotation;
import net.minecraft.client.renderer.model.BuiltInModel;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemModelGenerator;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.model.Variant;
import net.minecraft.client.renderer.model.VariantList;
import net.minecraft.client.renderer.model.WeightedBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.Item;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.BasicState;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.MultiModelState;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.animation.AnimationItemOverrideList;
import net.minecraftforge.client.model.animation.ModelBlockAnimation;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.Models;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.model.animation.IClip;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.logging.ModelLoaderErrorMessage;
import net.minecraftforge.registries.IRegistryDelegate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ModelLoader
extends ModelBakery {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<ModelResourceLocation, IUnbakedModel> stateModels = Maps.newHashMap();
    private final Map<ModelResourceLocation, BlockModelDefinition> multipartDefinitions = Maps.newHashMap();
    private final Map<BlockModelDefinition, IUnbakedModel> multipartModels = Maps.newHashMap();
    private final Set<ModelResourceLocation> missingVariants = Sets.newHashSet();
    private final Map<ResourceLocation, Exception> loadingExceptions = Maps.newHashMap();
    private IUnbakedModel missingModel = null;
    private boolean isLoading = false;
    private static Set<ResourceLocation> specialModels = new HashSet<ResourceLocation>();
    private static final Map<Pair<IRegistryDelegate<Item>, Integer>, ModelResourceLocation> customModels = Maps.newHashMap();
    private static final Function<ResourceLocation, IUnbakedModel> DEFAULT_MODEL_GETTER = ModelLoaderRegistry::getModelOrMissing;

    public boolean isLoading() {
        return this.isLoading;
    }

    public ModelLoader(IResourceManager manager, AtlasTexture map, BlockColors colours, IProfiler profiler) {
        super(manager, map, colours, profiler);
        VanillaLoader.INSTANCE.setLoader(this);
        VariantLoader.INSTANCE.setLoader(this);
        ModelLoaderRegistry.clearModelCache(manager);
    }

    public static void addSpecialModel(ResourceLocation rl) {
        specialModels.add(rl);
    }

    public Set<ResourceLocation> getSpecialModels() {
        return specialModels;
    }

    public static ModelResourceLocation getInventoryVariant(String s) {
        if (s.contains("#")) {
            return new ModelResourceLocation(s);
        }
        return new ModelResourceLocation(s, "inventory");
    }

    protected ResourceLocation getModelLocation(ResourceLocation model) {
        return new ResourceLocation(model.func_110624_b(), model.func_110623_a() + ".json");
    }

    protected IUnbakedModel getMissingModel() {
        if (this.missingModel == null) {
            try {
                this.missingModel = VanillaLoader.INSTANCE.loadModel(new ResourceLocation(field_177604_a.func_110624_b(), field_177604_a.func_110623_a()));
            }
            catch (Exception e) {
                throw new RuntimeException("Missing the missing model, this should never happen");
            }
        }
        return this.missingModel;
    }

    public void onPostBakeEvent(Map<ResourceLocation, IBakedModel> modelRegistry) {
        IBakedModel missingModel = modelRegistry.get(field_177604_a);
        for (Map.Entry<ResourceLocation, Exception> entry : this.loadingExceptions.entrySet()) {
            if (!(entry.getKey() instanceof ModelResourceLocation)) continue;
            LOGGER.debug(Logging.MODELLOADING, () -> new ModelLoaderErrorMessage((ModelResourceLocation)entry.getKey(), (Exception)entry.getValue()));
            ModelResourceLocation location = (ModelResourceLocation)entry.getKey();
            IBakedModel model = modelRegistry.get(location);
            if (model != null) continue;
            modelRegistry.put((ResourceLocation)location, missingModel);
        }
        for (ModelResourceLocation missing : this.missingVariants) {
            IBakedModel model = modelRegistry.get(missing);
            if (model == null || model == missingModel) {
                LOGGER.debug(Logging.MODELLOADING, () -> new ModelLoaderErrorMessage(missing, null));
            }
            if (model != null) continue;
            modelRegistry.put((ResourceLocation)missing, missingModel);
        }
        this.loadingExceptions.clear();
        this.missingVariants.clear();
        this.isLoading = false;
    }

    public static void onRegisterItems(ItemModelMesher mesher) {
        for (Map.Entry<Pair<IRegistryDelegate<Item>, Integer>, ModelResourceLocation> e : customModels.entrySet()) {
            mesher.func_199311_a((Item)((IRegistryDelegate)e.getKey().getLeft()).get(), e.getValue());
        }
    }

    public static Function<ResourceLocation, TextureAtlasSprite> defaultTextureGetter() {
        return DefaultTextureGetter.INSTANCE;
    }

    public static Function<ResourceLocation, IUnbakedModel> defaultModelGetter() {
        return DEFAULT_MODEL_GETTER;
    }

    protected static enum VariantLoader implements ICustomModelLoader
    {
        INSTANCE;

        private ModelLoader loader;

        void setLoader(ModelLoader loader) {
            this.loader = loader;
        }

        @Override
        public void func_195410_a(IResourceManager resourceManager) {
        }

        @Override
        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation instanceof ModelResourceLocation;
        }

        @Override
        public IUnbakedModel loadModel(ResourceLocation modelLocation) throws Exception {
            return this.loader.func_209597_a(modelLocation);
        }

        public String toString() {
            return "VariantLoader.INSTANCE";
        }
    }

    private static enum DefaultTextureGetter implements Function<ResourceLocation, TextureAtlasSprite>
    {
        INSTANCE;


        @Override
        public TextureAtlasSprite apply(ResourceLocation location) {
            return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
        }
    }

    public static class ItemLoadingException
    extends ModelLoaderRegistry.LoaderException {
        private final Exception normalException;
        private final Exception blockstateException;

        public ItemLoadingException(String message, Exception normalException, Exception blockstateException) {
            super(message);
            this.normalException = normalException;
            this.blockstateException = blockstateException;
        }
    }

    public static final class White {
        public static final ResourceLocation LOCATION = new ResourceLocation("white");
        public static final TextureAtlasSprite INSTANCE = MissingTextureSprite.func_217790_a();
    }

    protected static enum VanillaLoader implements ICustomModelLoader
    {
        INSTANCE;

        @Nullable
        private ModelLoader loader;
        private LoadingCache<BakedModelCacheKey, IBakedModel> modelCache = CacheBuilder.newBuilder().maximumSize(50L).expireAfterWrite(100L, TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<BakedModelCacheKey, IBakedModel>(){

            public IBakedModel load(BakedModelCacheKey key) throws Exception {
                return key.model.bakeImpl(key.bakery, key.bakedTextureGetter, key.state, key.uvlock, key.format);
            }
        });

        void setLoader(ModelLoader loader) {
            this.loader = loader;
        }

        @Nullable
        ModelLoader getLoader() {
            return this.loader;
        }

        @Override
        public void func_195410_a(IResourceManager resourceManager) {
        }

        @Override
        public boolean accepts(ResourceLocation modelLocation) {
            return true;
        }

        @Override
        public IUnbakedModel loadModel(ResourceLocation modelLocation) throws Exception {
            if (modelLocation.equals((Object)ModelBakery.field_177604_a) && this.loader.missingModel != null) {
                return this.loader.getMissingModel();
            }
            String modelPath = modelLocation.func_110623_a();
            if (modelLocation.func_110623_a().startsWith("models/")) {
                modelPath = modelPath.substring("models/".length());
            }
            ResourceLocation armatureLocation = new ResourceLocation(modelLocation.func_110624_b(), "armatures/" + modelPath + ".json");
            ModelBlockAnimation animation = ModelBlockAnimation.loadVanillaAnimation(this.loader.field_177598_f, armatureLocation);
            BlockModel model = this.loader.func_177594_c(modelLocation);
            ModelLoader modelLoader = this.loader;
            ((Object)((Object)modelLoader)).getClass();
            VanillaModelWrapper iModel = modelLoader.new VanillaModelWrapper(modelLocation, model, false, animation);
            if (this.loader.missingModel == null && modelLocation.equals((Object)ModelBakery.field_177604_a)) {
                this.loader.missingModel = iModel;
            }
            return iModel;
        }

        public String toString() {
            return "VanillaLoader.INSTANCE";
        }
    }

    protected final class BakedModelCacheKey {
        private final VanillaModelWrapper model;
        private final ModelBakery bakery;
        private final Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter;
        private final IModelState state;
        private final boolean uvlock;
        private final VertexFormat format;

        public BakedModelCacheKey(VanillaModelWrapper model, ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, IModelState state, boolean uvlock, VertexFormat format) {
            this.model = model;
            this.bakery = bakery;
            this.bakedTextureGetter = bakedTextureGetter;
            this.state = state;
            this.uvlock = uvlock;
            this.format = format;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BakedModelCacheKey that = (BakedModelCacheKey)o;
            return Objects.equal((Object)this.model, (Object)that.model) && Objects.equal((Object)this.bakery, (Object)that.bakery) && Objects.equal(this.bakedTextureGetter, that.bakedTextureGetter) && Objects.equal((Object)this.state, (Object)that.state) && this.uvlock == that.uvlock && Objects.equal((Object)this.format, (Object)that.format);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.model, this.state, this.format, this.bakedTextureGetter});
        }
    }

    private static final class WeightedRandomModel
    implements IUnbakedModel {
        private final List<Variant> variants;
        private final List<ResourceLocation> locations;
        private final Set<ResourceLocation> textures;
        private final List<IUnbakedModel> models;
        private final IModelState defaultState;

        public WeightedRandomModel(ResourceLocation parent, VariantList variants) throws Exception {
            this.variants = variants.func_188114_a();
            this.locations = new ArrayList<ResourceLocation>();
            this.textures = Sets.newHashSet();
            this.models = new ArrayList<IUnbakedModel>();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Variant v : this.variants) {
                ResourceLocation loc = v.func_188046_a();
                this.locations.add(loc);
                IUnbakedModel model = loc.equals((Object)ModelBakery.field_177604_a) ? ModelLoaderRegistry.getMissingModel() : ModelLoaderRegistry.getModel(loc);
                model = v.process(model);
                for (ResourceLocation location : model.func_187965_e()) {
                    ModelLoaderRegistry.getModelOrMissing(location);
                }
                this.textures.addAll(model.func_209559_a(ModelLoader.defaultModelGetter(), new HashSet()));
                this.models.add(model);
                IModelState modelDefaultState = model.getDefaultState();
                Preconditions.checkNotNull((Object)modelDefaultState, (String)"Model %s returned null as default state", (Object)loc);
                builder.add((Object)Pair.of((Object)model, (Object)new ModelStateComposition(v.getState(), modelDefaultState, v.func_188049_c())));
            }
            if (this.models.size() == 0) {
                IUnbakedModel missing = ModelLoaderRegistry.getMissingModel();
                this.models.add(missing);
                builder.add((Object)Pair.of((Object)missing, (Object)TRSRTransformation.identity()));
            }
            this.defaultState = new MultiModelState(builder.build());
        }

        private WeightedRandomModel(List<Variant> variants, List<ResourceLocation> locations, Set<ResourceLocation> textures, List<IUnbakedModel> models, IModelState defaultState) {
            this.variants = variants;
            this.locations = locations;
            this.textures = textures;
            this.models = models;
            this.defaultState = defaultState;
        }

        public Collection<ResourceLocation> func_187965_e() {
            return ImmutableList.copyOf(this.locations);
        }

        public Collection<ResourceLocation> func_209559_a(Function<ResourceLocation, IUnbakedModel> modelGetter, Set<String> missingTextureErrors) {
            return ImmutableSet.copyOf(this.textures);
        }

        @Nullable
        public IBakedModel bake(ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, VertexFormat format) {
            if (!Attributes.moreSpecific(format, Attributes.DEFAULT_BAKED_FORMAT)) {
                throw new IllegalArgumentException("can't bake vanilla weighted models to the format that doesn't fit into the default one: " + format);
            }
            if (this.variants.size() == 1) {
                IUnbakedModel model = this.models.get(0);
                return model.bake(bakery, spriteGetter, (ISprite)new BasicState(MultiModelState.getPartState(sprite.getState(), (IModel)model, 0), sprite.func_188049_c()), format);
            }
            WeightedBakedModel.Builder builder = new WeightedBakedModel.Builder();
            for (int i = 0; i < this.variants.size(); ++i) {
                IUnbakedModel model = this.models.get(i);
                builder.func_177677_a(model.bake(bakery, spriteGetter, (ISprite)new BasicState(MultiModelState.getPartState(sprite.getState(), (IModel)model, i), sprite.func_188049_c()), format), this.variants.get(i).func_188047_d());
            }
            return builder.func_209614_a();
        }

        public IModelState getDefaultState() {
            return this.defaultState;
        }

        public WeightedRandomModel retexture(ImmutableMap<String, String> textures) {
            if (textures.isEmpty()) {
                return this;
            }
            HashSet modelTextures = Sets.newHashSet();
            ImmutableList.Builder builder = ImmutableList.builder();
            ArrayList retexturedModels = Lists.newArrayList();
            for (int i = 0; i < this.variants.size(); ++i) {
                IUnbakedModel retextured = (IUnbakedModel)this.models.get(i).retexture(textures);
                modelTextures.addAll(retextured.func_209559_a(ModelLoader.defaultModelGetter(), new HashSet()));
                retexturedModels.add(retextured);
                builder.add((Object)Pair.of((Object)retextured, (Object)this.variants.get(i).getState()));
            }
            return new WeightedRandomModel(this.variants, this.locations, modelTextures, retexturedModels, new MultiModelState(builder.build()));
        }
    }

    private final class VanillaModelWrapper
    implements IUnbakedModel {
        private final FaceBakery faceBakery = new FaceBakery();
        private final ResourceLocation location;
        private final BlockModel model;
        private final boolean uvlock;
        private final ModelBlockAnimation animation;

        public VanillaModelWrapper(ResourceLocation location, BlockModel model, boolean uvlock, ModelBlockAnimation animation) {
            this.location = location;
            this.model = model;
            this.uvlock = uvlock;
            this.animation = animation;
        }

        public Collection<ResourceLocation> func_187965_e() {
            HashSet set = Sets.newHashSet();
            for (ResourceLocation dep : this.model.func_187965_e()) {
                if (this.location.equals((Object)dep)) continue;
                set.add(dep);
                ModelLoader.this.stateModels.put(ModelLoader.getInventoryVariant(dep.toString()), ModelLoaderRegistry.getModelOrLogError(dep, "Could not load override model " + dep + " for model " + this.location));
            }
            if (this.model.getParentLocation() != null && !this.model.getParentLocation().func_110623_a().startsWith("builtin/")) {
                set.add(this.model.getParentLocation());
            }
            return ImmutableSet.copyOf((Collection)set);
        }

        public Collection<ResourceLocation> func_209559_a(Function<ResourceLocation, IUnbakedModel> modelGetter, Set<String> missingTextureErrors) {
            if (this.model.getParentLocation() != null) {
                if (this.model.getParentLocation().func_110623_a().equals("builtin/generated")) {
                    this.model.field_178315_d = field_177606_o;
                } else {
                    IUnbakedModel parent = ModelLoaderRegistry.getModelOrLogError(this.model.getParentLocation(), "Could not load vanilla model parent '" + this.model.getParentLocation() + "' for '" + this.model);
                    if (parent instanceof VanillaModelWrapper) {
                        this.model.field_178315_d = ((VanillaModelWrapper)parent).model;
                    } else {
                        throw new IllegalStateException("vanilla model '" + this.model + "' can't have non-vanilla parent");
                    }
                }
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (this.model == field_177606_o) {
                for (String s : ItemModelGenerator.field_178398_a) {
                    String r = this.model.func_178308_c(s);
                    ResourceLocation loc = new ResourceLocation(r);
                    if (r.equals(s)) continue;
                    builder.add((Object)loc);
                }
            }
            for (String s : this.model.field_178318_c.values()) {
                if (s.startsWith("#")) continue;
                builder.add((Object)new ResourceLocation(s));
            }
            return builder.build();
        }

        @Nullable
        public IBakedModel bake(ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, VertexFormat format) {
            return (IBakedModel)VanillaLoader.INSTANCE.modelCache.getUnchecked((Object)new BakedModelCacheKey(this, bakery, spriteGetter, sprite.getState(), this.uvlock, format));
        }

        public IBakedModel bakeImpl(ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, IModelState state, boolean uvlock, VertexFormat format) {
            if (!Attributes.moreSpecific(format, Attributes.DEFAULT_BAKED_FORMAT)) {
                throw new IllegalArgumentException("can't bake vanilla models to the format that doesn't fit into the default one: " + format);
            }
            BlockModel model = this.model;
            if (model == null) {
                return ModelLoader.this.getMissingModel().bake(bakery, bakedTextureGetter, (ISprite)new BasicState(ModelLoader.this.getMissingModel().getDefaultState(), uvlock), format);
            }
            ArrayList newTransforms = Lists.newArrayList();
            for (int i = 0; i < model.func_178298_a().size(); ++i) {
                BlockPart part = (BlockPart)model.func_178298_a().get(i);
                newTransforms.add(this.animation.getPartTransform(state, part, i));
            }
            ItemCameraTransforms transforms = model.func_181682_g();
            EnumMap tMap = Maps.newEnumMap(ItemCameraTransforms.TransformType.class);
            tMap.putAll(PerspectiveMapWrapper.getTransforms(transforms));
            tMap.putAll(PerspectiveMapWrapper.getTransforms(state));
            SimpleModelState perState = new SimpleModelState((ImmutableMap<? extends IModelPart, TRSRTransformation>)ImmutableMap.copyOf((Map)tMap), state.apply(Optional.empty()));
            if (model == field_177606_o) {
                return new ItemLayerModel(bakery, model, format).bake(bakery, bakedTextureGetter, new BasicState(perState, uvlock), format);
            }
            TextureAtlasSprite textureatlassprite = bakedTextureGetter.apply(new ResourceLocation(model.func_178308_c("particle")));
            if (model == field_177616_r) {
                return new BuiltInModel(transforms, model.getOverrides(bakery, model, bakedTextureGetter, format), textureatlassprite);
            }
            return this.bakeNormal(bakery, model, perState, state, newTransforms, format, bakedTextureGetter, uvlock);
        }

        private IBakedModel bakeNormal(final ModelBakery bakery, BlockModel model, IModelState perState, final IModelState modelState, List<TRSRTransformation> newTransforms, final VertexFormat format, final Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, boolean uvLocked) {
            TRSRTransformation baseState = modelState.apply(Optional.empty()).orElse(TRSRTransformation.identity());
            TextureAtlasSprite particle = bakedTextureGetter.apply(new ResourceLocation(model.func_178308_c("particle")));
            SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(model, model.getOverrides(bakery, model, bakedTextureGetter, format)).func_177646_a(particle);
            for (int i = 0; i < model.func_178298_a().size(); ++i) {
                if (modelState.apply(Optional.of(Models.getHiddenModelPart((ImmutableList<String>)ImmutableList.of((Object)Integer.toString(i))))).isPresent()) continue;
                BlockPart part = (BlockPart)model.func_178298_a().get(i);
                TRSRTransformation transformation = baseState;
                if (newTransforms.get(i) != null) {
                    transformation = transformation.compose(newTransforms.get(i));
                    BlockPartRotation rot = part.field_178237_d;
                    if (rot == null) {
                        rot = new BlockPartRotation(new Vector3f(), Direction.Axis.Y, 0.0f, false);
                    }
                    part = new BlockPart(part.field_178241_a, part.field_178239_b, part.field_178240_c, rot, part.field_178238_e);
                }
                for (Map.Entry e : part.field_178240_c.entrySet()) {
                    TextureAtlasSprite textureatlassprite1 = bakedTextureGetter.apply(new ResourceLocation(model.func_178308_c(((BlockPartFace)e.getValue()).field_178242_d)));
                    if (((BlockPartFace)e.getValue()).field_178244_b == null || !TRSRTransformation.isInteger(transformation.getMatrixVec())) {
                        builder.func_177648_a(BlockModel.makeBakedQuad((BlockPart)part, (BlockPartFace)((BlockPartFace)e.getValue()), (TextureAtlasSprite)textureatlassprite1, (Direction)((Direction)e.getKey()), (ISprite)new BasicState(transformation, uvLocked)));
                        continue;
                    }
                    builder.func_177650_a(baseState.rotate(((BlockPartFace)e.getValue()).field_178244_b), BlockModel.makeBakedQuad((BlockPart)part, (BlockPartFace)((BlockPartFace)e.getValue()), (TextureAtlasSprite)textureatlassprite1, (Direction)((Direction)e.getKey()), (ISprite)new BasicState(transformation, uvLocked)));
                }
            }
            return new PerspectiveMapWrapper(builder.func_177645_b(), perState){
                private final ItemOverrideList overrides;
                {
                    super(parent, state);
                    this.overrides = new AnimationItemOverrideList(bakery, (IUnbakedModel)VanillaModelWrapper.this, modelState, format, (Function<ResourceLocation, TextureAtlasSprite>)bakedTextureGetter, super.func_188617_f());
                }

                public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData modelData) {
                    IModelState newState = modelData.getData(Properties.AnimationProperty);
                    if (newState != null) {
                        return VanillaModelWrapper.this.bake(bakery, bakedTextureGetter, new ModelStateComposition(modelState, newState, VanillaModelWrapper.this.uvlock), format).getQuads(state, side, rand, modelData);
                    }
                    return super.func_200117_a(state, side, rand);
                }

                @Override
                public ItemOverrideList func_188617_f() {
                    return this.overrides;
                }
            };
        }

        public VanillaModelWrapper retexture(ImmutableMap<String, String> textures) {
            if (textures.isEmpty()) {
                return this;
            }
            ArrayList elements = Lists.newArrayList();
            for (BlockPart part : this.model.func_178298_a()) {
                elements.add(new BlockPart(part.field_178241_a, part.field_178239_b, (Map)Maps.newHashMap((Map)part.field_178240_c), part.field_178237_d, part.field_178238_e));
            }
            BlockModel newModel = new BlockModel(this.model.getParentLocation(), (List)elements, (Map)Maps.newHashMap((Map)this.model.field_178318_c), this.model.func_178309_b(), this.model.func_178311_c(), this.model.func_181682_g(), (List)Lists.newArrayList((Iterable)this.model.func_187966_f()));
            newModel.field_178317_b = this.model.field_178317_b;
            newModel.field_178315_d = this.model.field_178315_d;
            HashSet removed = Sets.newHashSet();
            for (Map.Entry e : textures.entrySet()) {
                if ("".equals(e.getValue())) {
                    removed.add(e.getKey());
                    newModel.field_178318_c.remove(e.getKey());
                    continue;
                }
                newModel.field_178318_c.put(e.getKey(), e.getValue());
            }
            HashMap remapped = Maps.newHashMap();
            for (Map.Entry e : newModel.field_178318_c.entrySet()) {
                String key;
                if (!((String)e.getValue()).startsWith("#") || !newModel.field_178318_c.containsKey(key = ((String)e.getValue()).substring(1))) continue;
                remapped.put(e.getKey(), newModel.field_178318_c.get(key));
            }
            newModel.field_178318_c.putAll(remapped);
            for (BlockPart part : newModel.func_178298_a()) {
                part.field_178240_c.entrySet().removeIf(entry -> removed.contains(((BlockPartFace)entry.getValue()).field_178242_d));
            }
            return new VanillaModelWrapper(this.location, newModel, this.uvlock, this.animation);
        }

        public Optional<? extends IClip> getClip(String name) {
            if (this.animation.getClips().containsKey((Object)name)) {
                return Optional.ofNullable(this.animation.getClips().get((Object)name));
            }
            return Optional.empty();
        }

        public VanillaModelWrapper smoothLighting(boolean value) {
            if (this.model.field_178322_i == value) {
                return this;
            }
            BlockModel newModel = new BlockModel(this.model.getParentLocation(), this.model.func_178298_a(), this.model.field_178318_c, value, this.model.func_178311_c(), this.model.func_181682_g(), (List)Lists.newArrayList((Iterable)this.model.func_187966_f()));
            newModel.field_178315_d = this.model.field_178315_d;
            newModel.field_178317_b = this.model.field_178317_b;
            return new VanillaModelWrapper(this.location, newModel, this.uvlock, this.animation);
        }

        public VanillaModelWrapper gui3d(boolean value) {
            if (this.model.func_178311_c() == value) {
                return this;
            }
            BlockModel newModel = new BlockModel(this.model.getParentLocation(), this.model.func_178298_a(), this.model.field_178318_c, this.model.field_178322_i, value, this.model.func_181682_g(), (List)Lists.newArrayList((Iterable)this.model.func_187966_f()));
            newModel.field_178315_d = this.model.field_178315_d;
            newModel.field_178317_b = this.model.field_178317_b;
            return new VanillaModelWrapper(this.location, newModel, this.uvlock, this.animation);
        }
    }
}

