/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class CompoundIngredient
extends Ingredient {
    private List<Ingredient> children;
    private ItemStack[] stacks;
    private IntList itemIds;
    private final boolean isSimple;

    protected CompoundIngredient(List<Ingredient> children) {
        super(Stream.of(new Ingredient.IItemList[0]));
        this.children = Collections.unmodifiableList(children);
        this.isSimple = children.stream().allMatch(Ingredient::isSimple);
    }

    @Nonnull
    public ItemStack[] func_193365_a() {
        if (this.stacks == null) {
            ArrayList tmp = Lists.newArrayList();
            for (Ingredient child : this.children) {
                Collections.addAll(tmp, child.func_193365_a());
            }
            this.stacks = tmp.toArray(new ItemStack[tmp.size()]);
        }
        return this.stacks;
    }

    @Nonnull
    public IntList func_194139_b() {
        if (this.itemIds == null) {
            this.itemIds = new IntArrayList();
            for (Ingredient child : this.children) {
                this.itemIds.addAll(child.func_194139_b());
            }
            this.itemIds.sort((Comparator)IntComparators.NATURAL_COMPARATOR);
        }
        return this.itemIds;
    }

    public boolean test(@Nullable ItemStack target) {
        if (target == null) {
            return false;
        }
        return this.children.stream().anyMatch(c -> c.test(target));
    }

    protected void invalidate() {
        this.itemIds = null;
        this.stacks = null;
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    @Nonnull
    public Collection<Ingredient> getChildren() {
        return this.children;
    }

    public JsonElement func_200304_c() {
        if (this.children.size() == 1) {
            return this.children.get(0).func_200304_c();
        }
        JsonArray json = new JsonArray();
        this.children.stream().forEach(e -> json.add(e.func_200304_c()));
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<CompoundIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public CompoundIngredient parse(PacketBuffer buffer) {
            return new CompoundIngredient(Stream.generate(() -> Ingredient.func_199566_b((PacketBuffer)buffer)).limit(buffer.func_150792_a()).collect(Collectors.toList()));
        }

        @Override
        public CompoundIngredient parse(JsonObject json) {
            throw new JsonSyntaxException("CompoundIngredient should not be directly referenced in json, just use an array of ingredients.");
        }

        @Override
        public void write(PacketBuffer buffer, CompoundIngredient ingredient) {
            buffer.func_150787_b(ingredient.children.size());
            ingredient.children.forEach(c -> c.func_199564_a(buffer));
        }
    }
}

