/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.VanillaIngredientSerializer;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class CraftingHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker CRAFTHELPER = MarkerManager.getMarker((String)"CRAFTHELPER");
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<ResourceLocation, IConditionSerializer<?>> conditions = new HashMap();
    private static final BiMap<ResourceLocation, IIngredientSerializer<?>> ingredients = HashBiMap.create();

    public static IConditionSerializer<?> register(IConditionSerializer<?> serializer) {
        ResourceLocation key = serializer.getID();
        if (conditions.containsKey(key)) {
            throw new IllegalStateException("Duplicate recipe condition serializer: " + key);
        }
        conditions.put(key, serializer);
        return serializer;
    }

    public static <T extends Ingredient> IIngredientSerializer<T> register(ResourceLocation key, IIngredientSerializer<T> serializer) {
        if (ingredients.containsKey((Object)key)) {
            throw new IllegalStateException("Duplicate recipe ingredient serializer: " + key);
        }
        if (ingredients.containsValue(serializer)) {
            throw new IllegalStateException("Duplicate recipe ingredient serializer: " + key + " " + serializer);
        }
        ingredients.put((Object)key, serializer);
        return serializer;
    }

    @Nullable
    public static ResourceLocation getID(IIngredientSerializer<?> serializer) {
        return (ResourceLocation)ingredients.inverse().get(serializer);
    }

    public static <T extends Ingredient> void write(PacketBuffer buffer, T ingredient) {
        IIngredientSerializer serializer = ingredient.getSerializer();
        ResourceLocation key = (ResourceLocation)ingredients.inverse().get((Object)serializer);
        if (key == null) {
            throw new IllegalArgumentException("Tried to serialize unregistered Ingredient: " + ingredient + " " + serializer);
        }
        if (serializer != VanillaIngredientSerializer.INSTANCE) {
            buffer.func_150787_b(-1);
            buffer.func_192572_a(key);
        }
        serializer.write(buffer, ingredient);
    }

    public static Ingredient getIngredient(ResourceLocation type, PacketBuffer buffer) {
        IIngredientSerializer serializer = (IIngredientSerializer)ingredients.get((Object)type);
        if (serializer == null) {
            throw new IllegalArgumentException("Can not deserialize unknown Ingredient type: " + type);
        }
        return serializer.parse(buffer);
    }

    public static Ingredient getIngredient(JsonElement json) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Json cannot be null");
        }
        if (json.isJsonArray()) {
            ArrayList ingredients = Lists.newArrayList();
            ArrayList vanilla = Lists.newArrayList();
            json.getAsJsonArray().forEach(ele -> {
                Ingredient ing = CraftingHelper.getIngredient(ele);
                if (ing.getClass() == Ingredient.class) {
                    vanilla.add(ing);
                } else {
                    ingredients.add(ing);
                }
            });
            if (!vanilla.isEmpty()) {
                ingredients.add(Ingredient.merge((Collection)vanilla));
            }
            if (ingredients.size() == 0) {
                throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
            }
            if (ingredients.size() == 1) {
                return (Ingredient)ingredients.get(0);
            }
            return new CompoundIngredient(ingredients);
        }
        if (!json.isJsonObject()) {
            throw new JsonSyntaxException("Expcted ingredient to be a object or array of objects");
        }
        JsonObject obj = (JsonObject)json;
        String type = JSONUtils.func_151219_a((JsonObject)obj, (String)"type", (String)"minecraft:item");
        if (type.isEmpty()) {
            throw new JsonSyntaxException("Ingredient type can not be an empty string");
        }
        IIngredientSerializer serializer = (IIngredientSerializer)ingredients.get((Object)new ResourceLocation(type));
        if (serializer == null) {
            throw new JsonSyntaxException("Unknown ingredient type: " + type);
        }
        return serializer.parse(obj);
    }

    public static ItemStack getItemStack(JsonObject json, boolean readNBT) {
        String itemName = JSONUtils.func_151200_h((JsonObject)json, (String)"item");
        Item item = ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
        if (item == null) {
            throw new JsonSyntaxException("Unknown item '" + itemName + "'");
        }
        if (readNBT && json.has("nbt")) {
            try {
                JsonElement element = json.get("nbt");
                CompoundNBT nbt = element.isJsonObject() ? JsonToNBT.func_180713_a((String)GSON.toJson(element)) : JsonToNBT.func_180713_a((String)JSONUtils.func_151206_a((JsonElement)element, (String)"nbt"));
                CompoundNBT tmp = new CompoundNBT();
                if (nbt.func_74764_b("ForgeCaps")) {
                    tmp.func_218657_a("ForgeCaps", nbt.func_74781_a("ForgeCaps"));
                    nbt.func_82580_o("ForgeCaps");
                }
                tmp.func_218657_a("tag", (INBT)nbt);
                tmp.func_74778_a("id", itemName);
                tmp.func_74768_a("Count", JSONUtils.func_151208_a((JsonObject)json, (String)"count", (int)1));
                return ItemStack.func_199557_a((CompoundNBT)tmp);
            }
            catch (CommandSyntaxException e) {
                throw new JsonSyntaxException("Invalid NBT Entry: " + e.toString());
            }
        }
        return new ItemStack((IItemProvider)item, JSONUtils.func_151208_a((JsonObject)json, (String)"count", (int)1));
    }

    public static boolean processConditions(JsonObject json, String memberName) {
        return !json.has(memberName) || CraftingHelper.processConditions(JSONUtils.func_151214_t((JsonObject)json, (String)memberName));
    }

    public static boolean processConditions(JsonArray conditions) {
        for (int x = 0; x < conditions.size(); ++x) {
            if (!conditions.get(x).isJsonObject()) {
                throw new JsonSyntaxException("Conditions must be an array of JsonObjects");
            }
            JsonObject json = conditions.get(x).getAsJsonObject();
            if (CraftingHelper.getCondition(json).test()) continue;
            return false;
        }
        return true;
    }

    public static ICondition getCondition(JsonObject json) {
        ResourceLocation type = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"type"));
        IConditionSerializer<?> serializer = conditions.get(type);
        if (serializer == null) {
            throw new JsonSyntaxException("Unknown condition type: " + type.toString());
        }
        return serializer.read(json);
    }

    public static <T extends ICondition> JsonObject serialize(T condition) {
        IConditionSerializer<?> serializer = conditions.get(condition.getID());
        if (serializer == null) {
            throw new JsonSyntaxException("Unknown condition type: " + condition.getID().toString());
        }
        return serializer.getJson(condition);
    }
}

