/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import javax.annotation.Nonnull;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class DispenseFluidContainer
extends DefaultDispenseItemBehavior {
    private static final DispenseFluidContainer INSTANCE = new DispenseFluidContainer();
    private final DefaultDispenseItemBehavior dispenseBehavior = new DefaultDispenseItemBehavior();

    public static DispenseFluidContainer getInstance() {
        return INSTANCE;
    }

    private DispenseFluidContainer() {
    }

    @Nonnull
    public ItemStack func_82487_b(@Nonnull IBlockSource source, @Nonnull ItemStack stack) {
        if (FluidUtil.getFluidContained(stack) != null) {
            return this.dumpContainer(source, stack);
        }
        return this.fillContainer(source, stack);
    }

    @Nonnull
    private ItemStack fillContainer(@Nonnull IBlockSource source, @Nonnull ItemStack stack) {
        World world = source.func_197524_h();
        Direction dispenserFacing = (Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a);
        BlockPos blockpos = source.func_180699_d().func_177972_a(dispenserFacing);
        FluidActionResult actionResult = FluidUtil.tryPickUpFluid(stack, null, world, blockpos, dispenserFacing.func_176734_d());
        ItemStack resultStack = actionResult.getResult();
        if (!actionResult.isSuccess() || resultStack.func_190926_b()) {
            return super.func_82487_b(source, stack);
        }
        if (stack.func_190916_E() == 1) {
            return resultStack;
        }
        if (((DispenserTileEntity)source.func_150835_j()).func_146019_a(resultStack) < 0) {
            this.dispenseBehavior.dispense(source, resultStack);
        }
        ItemStack stackCopy = stack.func_77946_l();
        stackCopy.func_190918_g(1);
        return stackCopy;
    }

    @Nonnull
    private ItemStack dumpContainer(IBlockSource source, @Nonnull ItemStack stack) {
        ItemStack singleStack = stack.func_77946_l();
        singleStack.func_190920_e(1);
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler(singleStack).orElse(null);
        if (fluidHandler == null) {
            return super.func_82487_b(source, stack);
        }
        FluidStack fluidStack = fluidHandler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
        Direction dispenserFacing = (Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a);
        BlockPos blockpos = source.func_180699_d().func_177972_a(dispenserFacing);
        FluidActionResult result = FluidUtil.tryPlaceFluid(null, source.func_197524_h(), Hand.MAIN_HAND, blockpos, stack, fluidStack);
        if (result.isSuccess()) {
            ItemStack drainedStack = result.getResult();
            if (drainedStack.func_190916_E() == 1) {
                return drainedStack;
            }
            if (!drainedStack.func_190926_b() && ((DispenserTileEntity)source.func_150835_j()).func_146019_a(drainedStack) < 0) {
                this.dispenseBehavior.dispense(source, drainedStack);
            }
            ItemStack stackCopy = drainedStack.func_77946_l();
            stackCopy.func_190918_g(1);
            return stackCopy;
        }
        return this.dispenseBehavior.dispense(source, stack);
    }
}

