/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class FluidAttributes {
    public static final int BUCKET_VOLUME = 1000;
    private final String fluidName;
    private String translationKey;
    private final ResourceLocation stillTexture;
    private final ResourceLocation flowingTexture;
    @Nullable
    private final ResourceLocation overlayTexture;
    private final SoundEvent fillSound;
    private final SoundEvent emptySound;
    private final int luminosity;
    private final int density;
    private final int temperature;
    private final int viscosity;
    private final boolean isGaseous;
    private final Rarity rarity;
    private final Supplier<Block> blockSupplier;
    private final Supplier<Item> bucketSupplier;
    private final int color;

    protected FluidAttributes(Builder builder) {
        this.fluidName = builder.name;
        this.translationKey = builder.translationKey;
        this.stillTexture = builder.stillTexture;
        this.flowingTexture = builder.flowingTexture;
        this.overlayTexture = builder.overlayTexture;
        this.blockSupplier = builder.blockSupplier;
        this.color = builder.color;
        this.fillSound = builder.fillSound;
        this.emptySound = builder.emptySound;
        this.luminosity = builder.luminosity;
        this.temperature = builder.temperature;
        this.viscosity = builder.viscosity;
        this.density = builder.density;
        this.isGaseous = builder.isGaseous;
        this.rarity = builder.rarity;
        this.bucketSupplier = builder.bucketSupplier;
    }

    public final String getName() {
        return this.fluidName;
    }

    public ItemStack getBucket(FluidStack stack) {
        return this.bucketSupplier != null ? new ItemStack((IItemProvider)this.bucketSupplier.get()) : ItemStack.field_190927_a;
    }

    public BlockState getBlock(IEnviromentBlockReader reader, BlockPos pos, IFluidState state) {
        return (this.blockSupplier != null ? this.blockSupplier.get() : Blocks.field_150350_a).func_176223_P();
    }

    public IFluidState getStateForPlacement(IEnviromentBlockReader reader, BlockPos pos, FluidStack state) {
        return state.getFluid().func_207188_f();
    }

    public final boolean canBePlacedInWorld(IEnviromentBlockReader reader, BlockPos pos, IFluidState state) {
        return this.getBlock(reader, pos, state) != null;
    }

    public final boolean canBePlacedInWorld(IEnviromentBlockReader reader, BlockPos pos, FluidStack state) {
        return this.getBlock(reader, pos, this.getStateForPlacement(reader, pos, state)) != null;
    }

    public final boolean isLighterThanAir() {
        return this.density <= 0;
    }

    public boolean doesVaporize(IEnviromentBlockReader reader, BlockPos pos, FluidStack fluidStack) {
        BlockState blockstate = this.getBlock(reader, pos, this.getStateForPlacement(reader, pos, fluidStack));
        if (blockstate == null) {
            return false;
        }
        return blockstate.func_185904_a() == Material.field_151586_h;
    }

    public void vaporize(@Nullable PlayerEntity player, World worldIn, BlockPos pos, FluidStack fluidStack) {
        worldIn.func_184133_a(player, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
        for (int l = 0; l < 8; ++l) {
            worldIn.func_195589_b((IParticleData)ParticleTypes.field_197594_E, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0);
        }
    }

    public ITextComponent getDisplayName(FluidStack stack) {
        return new TranslationTextComponent(this.getTranslationKey(), new Object[0]);
    }

    public String getTranslationKey(FluidStack stack) {
        return this.getTranslationKey();
    }

    public String getTranslationKey() {
        return "fluid." + this.translationKey;
    }

    public final int getLuminosity() {
        return this.luminosity;
    }

    public final int getDensity() {
        return this.density;
    }

    public final int getTemperature() {
        return this.temperature;
    }

    public final int getViscosity() {
        return this.viscosity;
    }

    public final boolean isGaseous() {
        return this.isGaseous;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public int getColor() {
        return this.color;
    }

    public ResourceLocation getStillTexture() {
        return this.stillTexture;
    }

    public ResourceLocation getFlowingTexture() {
        return this.flowingTexture;
    }

    @Nullable
    public ResourceLocation getOverlayTexture() {
        return this.overlayTexture;
    }

    public SoundEvent getFillSound() {
        return this.fillSound;
    }

    public SoundEvent getEmptySound() {
        return this.emptySound;
    }

    public int getLuminosity(FluidStack stack) {
        return this.getLuminosity();
    }

    public int getDensity(FluidStack stack) {
        return this.getDensity();
    }

    public int getTemperature(FluidStack stack) {
        return this.getTemperature();
    }

    public int getViscosity(FluidStack stack) {
        return this.getViscosity();
    }

    public boolean isGaseous(FluidStack stack) {
        return this.isGaseous();
    }

    public Rarity getRarity(FluidStack stack) {
        return this.getRarity();
    }

    public int getColor(FluidStack stack) {
        return this.getColor();
    }

    public ResourceLocation getStill(FluidStack stack) {
        return this.getStillTexture();
    }

    public ResourceLocation getFlowing(FluidStack stack) {
        return this.getFlowingTexture();
    }

    public SoundEvent getFillSound(FluidStack stack) {
        return this.getFillSound();
    }

    public SoundEvent getEmptySound(FluidStack stack) {
        return this.getEmptySound();
    }

    public int getLuminosity(IEnviromentBlockReader world, BlockPos pos) {
        return this.getLuminosity();
    }

    public int getDensity(IEnviromentBlockReader world, BlockPos pos) {
        return this.getDensity();
    }

    public int getTemperature(IEnviromentBlockReader world, BlockPos pos) {
        return this.getTemperature();
    }

    public int getViscosity(IEnviromentBlockReader world, BlockPos pos) {
        return this.getViscosity();
    }

    public boolean isGaseous(IEnviromentBlockReader world, BlockPos pos) {
        return this.isGaseous();
    }

    public Rarity getRarity(IEnviromentBlockReader world, BlockPos pos) {
        return this.getRarity();
    }

    public int getColor(IEnviromentBlockReader world, BlockPos pos) {
        return this.getColor();
    }

    public ResourceLocation getStill(IEnviromentBlockReader world, BlockPos pos) {
        return this.getStillTexture();
    }

    public ResourceLocation getFlowing(IEnviromentBlockReader world, BlockPos pos) {
        return this.getFlowingTexture();
    }

    public SoundEvent getFillSound(IEnviromentBlockReader world, BlockPos pos) {
        return this.getFillSound();
    }

    public SoundEvent getEmptySound(IEnviromentBlockReader world, BlockPos pos) {
        return this.getEmptySound();
    }

    public static Builder builder(String name, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
        return new Builder(name, stillTexture, flowingTexture);
    }

    public static class Builder {
        private final String name;
        private final ResourceLocation stillTexture;
        private final ResourceLocation flowingTexture;
        private ResourceLocation overlayTexture;
        private int color = 0xFFFFFF;
        private String translationKey;
        private SoundEvent fillSound;
        private SoundEvent emptySound;
        private Supplier<Block> blockSupplier;
        private Supplier<Item> bucketSupplier;
        private int luminosity = 0;
        private int density = 1000;
        private int temperature = 300;
        private int viscosity = 1000;
        private boolean isGaseous;
        private Rarity rarity = Rarity.COMMON;

        protected Builder(String name, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            this.name = name.toLowerCase(Locale.ENGLISH);
            this.stillTexture = stillTexture;
            this.flowingTexture = flowingTexture;
            this.translationKey = "fluid." + this.name + ".name";
        }

        public final Builder translationKey(String translationKey) {
            this.translationKey = translationKey;
            return this;
        }

        public final Builder color(int color) {
            this.color = color;
            return this;
        }

        public final Builder vanillaColor() {
            this.color = -1;
            return this;
        }

        public final Builder overlay(ResourceLocation texture) {
            this.overlayTexture = texture;
            return this;
        }

        public final Builder block(Supplier<Block> supplier) {
            this.blockSupplier = supplier;
            return this;
        }

        public final Builder bucket(Supplier<Item> supplier) {
            this.bucketSupplier = supplier;
            return this;
        }

        public final Builder luminosity(int luminosity) {
            this.luminosity = luminosity;
            return this;
        }

        public final Builder density(int density) {
            this.density = density;
            return this;
        }

        public final Builder temperature(int temperature) {
            this.temperature = temperature;
            return this;
        }

        public final Builder viscosity(int viscosity) {
            this.viscosity = viscosity;
            return this;
        }

        public final Builder gaseous() {
            this.isGaseous = true;
            return this;
        }

        public final Builder rarity(Rarity rarity) {
            this.rarity = rarity;
            return this;
        }

        public final Builder sound(SoundEvent sound) {
            this.fillSound = this.emptySound = sound;
            return this;
        }

        public final Builder sound(SoundEvent fillSound, SoundEvent emptySound) {
            this.fillSound = fillSound;
            this.emptySound = emptySound;
            return this;
        }

        public FluidAttributes build() {
            return new FluidAttributes(this);
        }
    }
}

