/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IRegistryDelegate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FluidStack {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final FluidStack EMPTY = new FluidStack(Fluids.field_204541_a, 0);
    private boolean isEmpty;
    private int amount;
    private CompoundNBT tag;
    private IRegistryDelegate<Fluid> fluidDelegate;

    public FluidStack(Fluid fluid, int amount) {
        if (fluid == null) {
            LOGGER.fatal("Null fluid supplied to fluidstack. Did you try and create a stack for an unregistered fluid?");
            throw new IllegalArgumentException("Cannot create a fluidstack from a null fluid");
        }
        if (ForgeRegistries.FLUIDS.getKey(fluid) == null) {
            LOGGER.fatal("Failed attempt to create a FluidStack for an unregistered Fluid {} (type {})", (Object)fluid.getRegistryName(), (Object)fluid.getClass().getName());
            throw new IllegalArgumentException("Cannot create a fluidstack from an unregistered fluid");
        }
        this.fluidDelegate = fluid.delegate;
        this.amount = amount;
    }

    public FluidStack(Fluid fluid, int amount, CompoundNBT nbt) {
        this(fluid, amount);
        if (nbt != null) {
            this.tag = nbt.func_74737_b();
        }
    }

    public FluidStack(FluidStack stack, int amount) {
        this(stack.getFluid(), amount, stack.tag);
    }

    public static FluidStack loadFluidStackFromNBT(CompoundNBT nbt) {
        if (nbt == null) {
            return EMPTY;
        }
        if (!nbt.func_150297_b("FluidName", 8)) {
            return EMPTY;
        }
        ResourceLocation fluidName = new ResourceLocation(nbt.func_74779_i("FluidName"));
        Fluid fluid = ForgeRegistries.FLUIDS.getValue(fluidName);
        if (fluid == null) {
            return EMPTY;
        }
        FluidStack stack = new FluidStack(fluid, nbt.func_74762_e("Amount"));
        if (nbt.func_150297_b("Tag", 10)) {
            stack.tag = nbt.func_74775_l("Tag");
        }
        return stack;
    }

    public CompoundNBT writeToNBT(CompoundNBT nbt) {
        nbt.func_74778_a("FluidName", this.getFluid().getRegistryName().toString());
        nbt.func_74768_a("Amount", this.amount);
        if (this.tag != null) {
            nbt.func_218657_a("Tag", (INBT)this.tag);
        }
        return nbt;
    }

    public void writeToPacket(PacketBuffer buf) {
        buf.writeRegistryId((IForgeRegistryEntry)this.getFluid());
        buf.func_150787_b(this.getAmount());
        buf.func_150786_a(this.tag);
    }

    public static FluidStack readFromPacket(PacketBuffer buf) {
        Fluid fluid = (Fluid)buf.readRegistryId();
        int amount = buf.func_150792_a();
        CompoundNBT tag = buf.func_150793_b();
        if (fluid == Fluids.field_204541_a) {
            return EMPTY;
        }
        return new FluidStack(fluid, amount, tag);
    }

    public final Fluid getFluid() {
        return this.isEmpty ? Fluids.field_204541_a : this.fluidDelegate.get();
    }

    public final Fluid getRawFluid() {
        return this.fluidDelegate.get();
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    protected void updateEmpty() {
        this.isEmpty = this.getRawFluid() == Fluids.field_204541_a || this.amount == 0;
    }

    public int getAmount() {
        return this.isEmpty ? 0 : this.amount;
    }

    public void setAmount(int amount) {
        if (this.getRawFluid() == Fluids.field_204541_a) {
            throw new IllegalStateException("Can't modify the empty stack.");
        }
        if (amount < 0) {
            throw new IllegalStateException("The amount can't be negative.");
        }
        this.amount = amount;
        this.updateEmpty();
    }

    public void grow(int amount) {
        this.setAmount(this.amount + amount);
    }

    public void shrink(int amount) {
        this.setAmount(this.amount - amount);
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    public CompoundNBT getTag() {
        return this.tag;
    }

    public void setTag(CompoundNBT tag) {
        if (this.getRawFluid() == Fluids.field_204541_a) {
            throw new IllegalStateException("Can't modify the empty stack.");
        }
        this.tag = tag;
    }

    public CompoundNBT getOrCreateTag() {
        if (this.tag == null) {
            this.setTag(new CompoundNBT());
        }
        return this.tag;
    }

    public CompoundNBT getChildTag(String childName) {
        if (this.tag == null) {
            return null;
        }
        return this.tag.func_74775_l(childName);
    }

    public CompoundNBT getOrCreateChildTag(String childName) {
        this.getOrCreateTag();
        CompoundNBT child = this.tag.func_74775_l(childName);
        if (child == null) {
            child = new CompoundNBT();
            this.tag.func_218657_a(childName, (INBT)child);
        }
        return child;
    }

    public void removeChildTag(String childName) {
        if (this.tag != null) {
            this.tag.func_82580_o(childName);
        }
    }

    public ITextComponent getDisplayName() {
        return this.getFluid().getAttributes().getDisplayName(this);
    }

    public String getTranslationKey() {
        return this.getFluid().getAttributes().getTranslationKey(this);
    }

    public FluidStack copy() {
        return new FluidStack(this.getFluid(), this.amount, this.tag);
    }

    public boolean isFluidEqual(@Nonnull FluidStack other) {
        return this.getFluid() == other.getFluid() && this.isFluidStackTagEqual(other);
    }

    private boolean isFluidStackTagEqual(FluidStack other) {
        return this.tag == null ? other.tag == null : other.tag != null && this.tag.equals((Object)other.tag);
    }

    public static boolean areFluidStackTagsEqual(@Nonnull FluidStack stack1, @Nonnull FluidStack stack2) {
        return stack1.isFluidStackTagEqual(stack2);
    }

    public boolean containsFluid(@Nonnull FluidStack other) {
        return this.isFluidEqual(other) && this.amount >= other.amount;
    }

    public boolean isFluidStackIdentical(FluidStack other) {
        return this.isFluidEqual(other) && this.amount == other.amount;
    }

    public boolean isFluidEqual(ItemStack other) {
        if (other == null) {
            return false;
        }
        return FluidUtil.getFluidContained(other).map(this::isFluidEqual).orElse(false);
    }

    public final int hashCode() {
        int code = 1;
        code = 31 * code + this.getFluid().hashCode();
        code = 31 * code + this.amount;
        if (this.tag != null) {
            code = 31 * code + this.tag.hashCode();
        }
        return code;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof FluidStack)) {
            return false;
        }
        return this.isFluidEqual((FluidStack)o);
    }
}

