/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client;

import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.WorldSelectionScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.ServerStatusResponse;
import net.minecraft.resources.FallbackResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePack;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.world.storage.WorldSummary;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ForgeI18n;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.StartupQuery;
import net.minecraftforge.fml.client.ExtendedServerListData;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.packs.ModFileResourcePack;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.GameData;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class ClientHooks {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker CLIENTHOOKS = MarkerManager.getMarker((String)"CLIENTHOOKS");
    private static final String ALLOWED_CHARS = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000";
    private static final CharMatcher DISALLOWED_CHAR_MATCHER = CharMatcher.anyOf((CharSequence)"\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000").negate();
    private static final ResourceLocation iconSheet = new ResourceLocation("forge", "textures/gui/icons.png");
    private static SetMultimap<String, ResourceLocation> missingTextures = HashMultimap.create();
    private static Set<String> badTextureDomains = Sets.newHashSet();
    private static Table<String, String, Set<ResourceLocation>> brokenTextures = HashBasedTable.create();

    @Nullable
    public static void processForgeListPingData(ServerStatusResponse packet, ServerData target) {
        if (packet.getForgeData() != null) {
            Map<String, String> mods = packet.getForgeData().getRemoteModData();
            Map<ResourceLocation, Pair<String, Boolean>> remoteChannels = packet.getForgeData().getRemoteChannels();
            int fmlver = packet.getForgeData().getFMLNetworkVersion();
            boolean fmlNetMatches = fmlver == 2;
            boolean channelsMatch = NetworkRegistry.checkListPingCompatibilityForClient(remoteChannels);
            AtomicBoolean result = new AtomicBoolean(true);
            ModList.get().forEachModContainer((modid, mc) -> mc.getCustomExtension(ExtensionPoint.DISPLAYTEST).ifPresent(ext -> result.compareAndSet(true, ((BiPredicate)ext.getRight()).test(mods.get(modid), true))));
            boolean modsMatch = result.get();
            Map<String, String> extraServerMods = mods.entrySet().stream().filter(e -> !Objects.equals("OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", e.getValue())).filter(e -> !ModList.get().isLoaded((String)e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            LOGGER.debug(CLIENTHOOKS, "Received FML ping data from server at {}: FMLNETVER={}, mod list is compatible : {}, channel list is compatible: {}, extra server mods: {}", (Object)target.field_78845_b, (Object)fmlver, (Object)modsMatch, (Object)channelsMatch, extraServerMods);
            String extraReason = null;
            if (!extraServerMods.isEmpty()) {
                extraReason = "fml.menu.multiplayer.extraservermods";
            }
            if (!modsMatch) {
                extraReason = "fml.menu.multiplayer.modsincompatible";
            }
            if (!channelsMatch) {
                extraReason = "fml.menu.multiplayer.networkincompatible";
            }
            if (fmlver < 2) {
                extraReason = "fml.menu.multiplayer.serveroutdated";
            }
            if (fmlver > 2) {
                extraReason = "fml.menu.multiplayer.clientoutdated";
            }
            target.forgeData = new ExtendedServerListData("FML", extraServerMods.isEmpty() && fmlNetMatches && channelsMatch && modsMatch, mods.size(), extraReason);
        } else {
            target.forgeData = new ExtendedServerListData("VANILLA", NetworkRegistry.canConnectToVanillaServer(), 0, null);
        }
    }

    public static void drawForgePingInfo(MultiplayerScreen gui, ServerData target, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        String tooltip;
        int idx;
        if (target.forgeData == null) {
            return;
        }
        switch (target.forgeData.type) {
            case "FML": {
                if (target.forgeData.isCompatible) {
                    idx = 0;
                    tooltip = ForgeI18n.parseMessage("fml.menu.multiplayer.compatible", target.forgeData.numberOfMods);
                    break;
                }
                idx = 16;
                if (target.forgeData.extraReason != null) {
                    String extraReason = ForgeI18n.parseMessage(target.forgeData.extraReason, new Object[0]);
                    tooltip = ForgeI18n.parseMessage("fml.menu.multiplayer.incompatible.extra", extraReason);
                    break;
                }
                tooltip = ForgeI18n.parseMessage("fml.menu.multiplayer.incompatible", new Object[0]);
                break;
            }
            case "VANILLA": {
                if (target.forgeData.isCompatible) {
                    idx = 48;
                    tooltip = ForgeI18n.parseMessage("fml.menu.multiplayer.vanilla", new Object[0]);
                    break;
                }
                idx = 80;
                tooltip = ForgeI18n.parseMessage("fml.menu.multiplayer.vanilla.incompatible", new Object[0]);
                break;
            }
            default: {
                idx = 64;
                tooltip = ForgeI18n.parseMessage("fml.menu.multiplayer.unknown", target.forgeData.type);
            }
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(iconSheet);
        AbstractGui.blit((int)(x + width - 18), (int)(y + 10), (int)16, (int)16, (float)0.0f, (float)idx, (int)16, (int)16, (int)256, (int)256);
        if (relativeMouseX > width - 15 && relativeMouseX < width && relativeMouseY > 10 && relativeMouseY < 26) {
            gui.func_146793_a(tooltip);
        }
    }

    public static String fixDescription(String description) {
        return description.endsWith(":NOFML\u00a7r") ? description.substring(0, description.length() - 8) + "\u00a7r" : description;
    }

    static File getSavesDir() {
        return new File(Minecraft.func_71410_x().field_71412_D, "saves");
    }

    public static void tryLoadExistingWorld(WorldSelectionScreen selectWorldGUI, WorldSummary comparator) {
        try {
            Minecraft.func_71410_x().func_71371_a(comparator.func_75786_a(), comparator.func_75788_b(), null);
        }
        catch (StartupQuery.AbortedException abortedException) {
            // empty catch block
        }
    }

    private static NetworkManager getClientToServerNetworkManager() {
        return Minecraft.func_71410_x().func_147114_u() != null ? Minecraft.func_71410_x().func_147114_u().func_147298_b() : null;
    }

    public static void handleClientWorldClosing(ClientWorld world) {
        NetworkManager client = ClientHooks.getClientToServerNetworkManager();
        if (client != null && !client.func_150731_c()) {
            GameData.revertToFrozen();
        }
    }

    public static String stripSpecialChars(String message) {
        return DISALLOWED_CHAR_MATCHER.removeFrom((CharSequence)StringUtils.func_76338_a((String)message));
    }

    public static void trackMissingTexture(ResourceLocation resourceLocation) {
        badTextureDomains.add(resourceLocation.func_110624_b());
        missingTextures.put((Object)resourceLocation.func_110624_b(), (Object)resourceLocation);
    }

    public static void trackBrokenTexture(ResourceLocation resourceLocation, String error) {
        badTextureDomains.add(resourceLocation.func_110624_b());
        Set badType = (Set)brokenTextures.get((Object)resourceLocation.func_110624_b(), (Object)error);
        if (badType == null) {
            badType = Sets.newHashSet();
            brokenTextures.put((Object)resourceLocation.func_110624_b(), MoreObjects.firstNonNull((Object)error, (Object)"Unknown error"), (Object)badType);
        }
        badType.add(resourceLocation);
    }

    public static void logMissingTextureErrors() {
        if (missingTextures.isEmpty() && brokenTextures.isEmpty()) {
            return;
        }
        Logger logger = LogManager.getLogger((String)"FML.TEXTURE_ERRORS");
        logger.error(Strings.repeat((String)"+=", (int)25));
        logger.error("The following texture errors were found.");
        Map resManagers = (Map)ObfuscationReflectionHelper.getPrivateValue(SimpleReloadableResourceManager.class, (SimpleReloadableResourceManager)Minecraft.func_71410_x().func_195551_G(), "field_199014_c");
        for (String resourceDomain : badTextureDomains) {
            Set missing = missingTextures.get((Object)resourceDomain);
            logger.error(Strings.repeat((String)"=", (int)50));
            logger.error("  DOMAIN {}", (Object)resourceDomain);
            logger.error(Strings.repeat((String)"-", (int)50));
            logger.error("  domain {} is missing {} texture{}", (Object)resourceDomain, (Object)missing.size(), (Object)(missing.size() != 1 ? "s" : ""));
            FallbackResourceManager fallbackResourceManager = (FallbackResourceManager)resManagers.get(resourceDomain);
            if (fallbackResourceManager == null) {
                logger.error("    domain {} is missing a resource manager - it is probably a side-effect of automatic texture processing", (Object)resourceDomain);
            } else {
                List resPacks = fallbackResourceManager.field_199023_a;
                logger.error("    domain {} has {} location{}:", (Object)resourceDomain, (Object)resPacks.size(), (Object)(resPacks.size() != 1 ? "s" : ""));
                Iterator<Object> iterator = resPacks.iterator();
                while (iterator.hasNext()) {
                    IResourcePack resPack = (IResourcePack)iterator.next();
                    if (resPack instanceof ModFileResourcePack) {
                        ModFileResourcePack modRP = (ModFileResourcePack)resPack;
                        List mods = modRP.getModFile().getModInfos();
                        logger.error("      mod(s) {} resources at {}", mods.stream().map(IModInfo::getDisplayName).collect(Collectors.toList()), (Object)modRP.getModFile().getFilePath());
                        continue;
                    }
                    if (resPack instanceof ResourcePack) {
                        logger.error("      resource pack at path {}", (Object)((ResourcePack)resPack).field_195771_a.getPath());
                        continue;
                    }
                    logger.error("      unknown resourcepack type {} : {}", (Object)resPack.getClass().getName(), (Object)resPack.func_195762_a());
                }
            }
            logger.error(Strings.repeat((String)"-", (int)25));
            if (missingTextures.containsKey((Object)resourceDomain)) {
                logger.error("    The missing resources for domain {} are:", (Object)resourceDomain);
                for (ResourceLocation rl : missing) {
                    logger.error("      {}", (Object)rl.func_110623_a());
                }
                logger.error(Strings.repeat((String)"-", (int)25));
            }
            if (!brokenTextures.containsRow((Object)resourceDomain)) {
                logger.error("    No other errors exist for domain {}", (Object)resourceDomain);
            } else {
                logger.error("    The following other errors were reported for domain {}:", (Object)resourceDomain);
                Map resourceErrs = brokenTextures.row((Object)resourceDomain);
                for (String error : resourceErrs.keySet()) {
                    logger.error(Strings.repeat((String)"-", (int)25));
                    logger.error("    Problem: {}", (Object)error);
                    for (ResourceLocation rl : (Set)resourceErrs.get(error)) {
                        logger.error("      {}", (Object)rl.func_110623_a());
                    }
                }
            }
            logger.error(Strings.repeat((String)"=", (int)50));
        }
        logger.error(Strings.repeat((String)"+=", (int)25));
    }
}

