/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.RenderComponentsUtil;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.gui.ScrollPanel;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.Size2i;
import net.minecraftforge.fml.ForgeI18n;
import net.minecraftforge.fml.MavenVersionStringHelper;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.client.ConfigGuiHandler;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.client.gui.GuiSlotModList;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.fml.packs.ModFileResourcePack;
import net.minecraftforge.fml.packs.ResourcePackLoader;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class GuiModList
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private Screen mainMenu;
    private GuiSlotModList modList;
    private InfoPanel modInfo;
    private GuiSlotModList.ModEntry selected = null;
    private int listWidth;
    private List<ModInfo> mods;
    private final List<ModInfo> unsortedMods;
    private Button configButton;
    private Button openModsFolderButton;
    private int buttonMargin = 1;
    private int numButtons = SortType.values().length;
    private String lastFilterText = "";
    private TextFieldWidget search;
    private boolean sorted = false;
    private SortType sortType = SortType.NORMAL;

    public GuiModList(Screen mainMenu) {
        super((ITextComponent)new TranslationTextComponent("fml.menu.mods.title", new Object[0]));
        this.mainMenu = mainMenu;
        this.mods = Collections.unmodifiableList(ModList.get().getMods());
        this.unsortedMods = Collections.unmodifiableList(this.mods);
    }

    public void init() {
        for (ModInfo mod : this.mods) {
            this.listWidth = Math.max(this.listWidth, this.getFontRenderer().func_78256_a(mod.getDisplayName()) + 10);
            this.listWidth = Math.max(this.listWidth, this.getFontRenderer().func_78256_a(MavenVersionStringHelper.artifactVersionToString(mod.getVersion())) + 5);
        }
        this.listWidth = Math.max(Math.min(this.listWidth, this.width / 3), 100);
        this.listWidth += this.listWidth % this.numButtons != 0 ? this.numButtons - this.listWidth % this.numButtons : 0;
        this.modList = new GuiSlotModList(this, this.listWidth);
        this.modList.setLeftPos(6);
        int modInfoWidth = this.width - this.listWidth - 20;
        this.modInfo = new InfoPanel(this.minecraft, modInfoWidth, this.height - 30, 10);
        int doneButtonWidth = Math.min(modInfoWidth, 200);
        this.addButton((Widget)new Button((this.modList.getWidth() + 8 + this.width - doneButtonWidth) / 2, this.height - 24, doneButtonWidth, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), b -> this.minecraft.func_147108_a(this.mainMenu)));
        this.openModsFolderButton = new Button(6, this.height - 24, this.listWidth, 20, I18n.func_135052_a((String)"fml.menu.mods.openmodsfolder", (Object[])new Object[0]), b -> Util.func_110647_a().func_195641_a(FMLPaths.MODSDIR.get().toFile()));
        this.addButton((Widget)this.openModsFolderButton);
        this.configButton = new Button(6, this.height - 48, this.listWidth, 20, I18n.func_135052_a((String)"fml.menu.mods.config", (Object[])new Object[0]), b -> this.displayModConfig());
        this.addButton((Widget)this.configButton);
        this.configButton.active = false;
        this.search = new TextFieldWidget(this.getFontRenderer(), 8, this.modList.getBottom() + 17, this.listWidth - 4, 14, I18n.func_135052_a((String)"fml.menu.mods.search", (Object[])new Object[0]));
        this.children.add(this.search);
        this.children.add(this.modList);
        this.children.add(this.modInfo);
        this.search.func_146195_b(false);
        this.search.func_146205_d(true);
        int width = this.listWidth / this.numButtons;
        int x = 6;
        int y = 10;
        SortType.NORMAL.button = new Button(x, y, width - this.buttonMargin, 20, SortType.NORMAL.getButtonText(), b -> this.resortMods(SortType.NORMAL));
        this.addButton((Widget)SortType.NORMAL.button);
        SortType.A_TO_Z.button = new Button(x += width + this.buttonMargin, y, width - this.buttonMargin, 20, SortType.A_TO_Z.getButtonText(), b -> this.resortMods(SortType.A_TO_Z));
        this.addButton((Widget)SortType.A_TO_Z.button);
        SortType.Z_TO_A.button = new Button(x += width + this.buttonMargin, y, width - this.buttonMargin, 20, SortType.Z_TO_A.getButtonText(), b -> this.resortMods(SortType.Z_TO_A));
        this.addButton((Widget)SortType.Z_TO_A.button);
        this.resortMods(SortType.NORMAL);
        this.updateCache();
    }

    private void displayModConfig() {
        if (this.selected == null) {
            return;
        }
        try {
            ConfigGuiHandler.getGuiFactoryFor(this.selected.getInfo()).map(f -> (Screen)f.apply(this.minecraft, this)).ifPresent(newScreen -> this.minecraft.func_147108_a(newScreen));
        }
        catch (Exception e) {
            LOGGER.error("There was a critical issue trying to build the config GUI for {}", (Object)this.selected.getInfo().getModId(), (Object)e);
        }
    }

    public void tick() {
        this.search.func_146178_a();
        this.modList.setSelected((AbstractList.AbstractListEntry)this.selected);
        if (!this.search.func_146179_b().equals(this.lastFilterText)) {
            this.reloadMods();
            this.sorted = false;
        }
        if (!this.sorted) {
            this.reloadMods();
            this.mods.sort(this.sortType);
            this.modList.refreshList();
            if (this.selected != null) {
                this.selected = this.modList.children().stream().filter(e -> e.getInfo() == this.selected.getInfo()).findFirst().orElse(null);
                this.updateCache();
            }
            this.sorted = true;
        }
    }

    public <T extends ExtendedList.AbstractListEntry<T>> void buildModList(Consumer<T> modListViewConsumer, Function<ModInfo, T> newEntry) {
        this.mods.forEach(mod -> modListViewConsumer.accept(newEntry.apply((ModInfo)mod)));
    }

    private void reloadMods() {
        this.mods = this.unsortedMods.stream().filter(mi -> net.minecraftforge.fml.loading.StringUtils.toLowerCase((String)StringUtils.func_76338_a((String)mi.getDisplayName())).contains(net.minecraftforge.fml.loading.StringUtils.toLowerCase((String)this.search.func_146179_b()))).collect(Collectors.toList());
        this.lastFilterText = this.search.func_146179_b();
    }

    private void resortMods(SortType newSort) {
        this.sortType = newSort;
        for (SortType sort : SortType.values()) {
            if (sort.button == null) continue;
            sort.button.active = this.sortType != sort;
        }
        this.sorted = false;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.modList.render(mouseX, mouseY, partialTicks);
        if (this.modInfo != null) {
            this.modInfo.render(mouseX, mouseY, partialTicks);
        }
        String text = I18n.func_135052_a((String)"fml.menu.mods.search", (Object[])new Object[0]);
        int x = this.modList.getLeft() / 2 - this.getFontRenderer().func_78256_a(text) / 2;
        this.getFontRenderer().func_211126_b(text, (float)x, (float)(this.modList.getBottom() + 5), 0xFFFFFF);
        this.search.render(mouseX, mouseY, partialTicks);
        super.render(mouseX, mouseY, partialTicks);
    }

    Minecraft getMinecraftInstance() {
        return this.minecraft;
    }

    FontRenderer getFontRenderer() {
        return this.font;
    }

    public void setSelected(GuiSlotModList.ModEntry entry) {
        this.selected = entry == this.selected ? null : entry;
        this.updateCache();
    }

    private void updateCache() {
        if (this.selected == null) {
            this.configButton.active = false;
            this.modInfo.clearInfo();
            return;
        }
        ModInfo selectedMod = this.selected.getInfo();
        this.configButton.active = selectedMod.hasConfigUI();
        ArrayList<String> lines = new ArrayList<String>();
        VersionChecker.CheckResult vercheck = VersionChecker.getResult((IModInfo)selectedMod);
        Pair logoData = selectedMod.getLogoFile().map(logoFile -> {
            TextureManager tm = this.minecraft.func_110434_K();
            ModFileResourcePack resourcePack = ResourcePackLoader.getResourcePackFor(selectedMod.getModId()).orElse(ResourcePackLoader.getResourcePackFor("forge").orElseThrow(() -> new RuntimeException("Can't find forge, WHAT!")));
            try {
                NativeImage logo = null;
                InputStream logoResource = resourcePack.func_195763_b((String)logoFile);
                if (logoResource != null) {
                    logo = NativeImage.func_195713_a((InputStream)logoResource);
                }
                if (logo != null) {
                    return Pair.of((Object)tm.func_110578_a("modlogo", new DynamicTexture(logo)), (Object)new Size2i(logo.func_195702_a(), logo.func_195714_b()));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return Pair.of(null, (Object)new Size2i(0, 0));
        }).orElse(Pair.of(null, (Object)new Size2i(0, 0)));
        lines.add(selectedMod.getDisplayName());
        lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.version", MavenVersionStringHelper.artifactVersionToString(selectedMod.getVersion())));
        lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.idstate", selectedMod.getModId(), ModList.get().getModContainerById(selectedMod.getModId()).map(ModContainer::getCurrentState).map(Object::toString).orElse("NONE")));
        selectedMod.getModConfig().getOptional("credits").ifPresent(credits -> lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.credits", credits)));
        selectedMod.getModConfig().getOptional("authors").ifPresent(authors -> lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.authors", authors)));
        selectedMod.getModConfig().getOptional("displayURL").ifPresent(displayURL -> lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.displayurl", displayURL)));
        if (selectedMod.getOwningFile() == null || selectedMod.getOwningFile().getMods().size() == 1) {
            lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.nochildmods", new Object[0]));
        } else {
            lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.childmods", selectedMod.getOwningFile().getMods().stream().map(IModInfo::getDisplayName).collect(Collectors.joining(","))));
        }
        if (vercheck.status == VersionChecker.Status.OUTDATED || vercheck.status == VersionChecker.Status.BETA_OUTDATED) {
            lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.updateavailable", vercheck.url == null ? "" : vercheck.url));
        }
        lines.add(null);
        lines.add(selectedMod.getDescription());
        if ((vercheck.status == VersionChecker.Status.OUTDATED || vercheck.status == VersionChecker.Status.BETA_OUTDATED) && vercheck.changes.size() > 0) {
            lines.add(null);
            lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.changelogheader", new Object[0]));
            for (Map.Entry<ComparableVersion, String> entry : vercheck.changes.entrySet()) {
                lines.add("  " + entry.getKey() + ":");
                lines.add(entry.getValue());
                lines.add(null);
            }
        }
        this.modInfo.setInfo(lines, (ResourceLocation)logoData.getLeft(), (Size2i)logoData.getRight());
    }

    public void resize(Minecraft mc, int width, int height) {
        String s = this.search.func_146179_b();
        SortType sort = this.sortType;
        GuiSlotModList.ModEntry selected = this.selected;
        this.init(mc, width, height);
        this.search.func_146180_a(s);
        this.selected = selected;
        if (!this.search.func_146179_b().isEmpty()) {
            this.reloadMods();
        }
        if (sort != SortType.NORMAL) {
            this.resortMods(sort);
        }
        this.updateCache();
    }

    class InfoPanel
    extends ScrollPanel {
        private ResourceLocation logoPath;
        private Size2i logoDims;
        private List<ITextComponent> lines;

        InfoPanel(Minecraft mcIn, int widthIn, int heightIn, int topIn) {
            super(mcIn, widthIn, heightIn, topIn, GuiModList.this.modList.getLeft() + 10);
            this.logoDims = new Size2i(0, 0);
            this.lines = Collections.emptyList();
        }

        void setInfo(List<String> lines, ResourceLocation logoPath, Size2i logoDims) {
            this.logoPath = logoPath;
            this.logoDims = logoDims;
            this.lines = this.resizeContent(lines);
        }

        void clearInfo() {
            this.logoPath = null;
            this.logoDims = new Size2i(0, 0);
            this.lines = Collections.emptyList();
        }

        private List<ITextComponent> resizeContent(List<String> lines) {
            ArrayList<ITextComponent> ret = new ArrayList<ITextComponent>();
            for (String line : lines) {
                if (line == null) {
                    ret.add(null);
                    continue;
                }
                ITextComponent chat = ForgeHooks.newChatWithLinks(line, false);
                int maxTextLength = this.width - 12;
                if (maxTextLength < 0) continue;
                ret.addAll(RenderComponentsUtil.func_178908_a((ITextComponent)chat, (int)maxTextLength, (FontRenderer)GuiModList.this.font, (boolean)false, (boolean)true));
            }
            return ret;
        }

        @Override
        public int getContentHeight() {
            int height = 50;
            int n = this.lines.size();
            GuiModList.this.font.getClass();
            if ((height += n * 9) < this.bottom - this.top - 8) {
                height = this.bottom - this.top - 8;
            }
            return height;
        }

        @Override
        protected int getScrollAmount() {
            GuiModList.this.font.getClass();
            return 9 * 3;
        }

        @Override
        protected void drawPanel(int entryRight, int relativeY, Tessellator tess, int mouseX, int mouseY) {
            if (this.logoPath != null) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.logoPath);
                GlStateManager.enableBlend();
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int headerHeight = 50;
                GuiUtils.drawInscribedRect(this.left, relativeY, this.width - 5, headerHeight, this.logoDims.width, this.logoDims.height, false, true);
                relativeY += headerHeight;
            }
            for (ITextComponent line : this.lines) {
                if (line != null) {
                    GlStateManager.enableBlend();
                    GuiModList.this.font.func_175063_a(line.func_150254_d(), (float)(this.left + 4), (float)relativeY, 0xFFFFFF);
                    GlStateManager.disableAlphaTest();
                    GlStateManager.disableBlend();
                }
                GuiModList.this.font.getClass();
                relativeY += 9;
            }
            ITextComponent component = this.findTextLine(mouseX, mouseY);
            if (component != null) {
                GuiModList.this.renderComponentHoverEffect(component, mouseX, mouseY);
            }
        }

        private ITextComponent findTextLine(int mouseX, int mouseY) {
            double offset = (float)(mouseY - this.top + 4) + this.scrollDistance + 1.0f;
            if (this.logoPath != null) {
                offset -= 50.0;
            }
            if (offset <= 0.0) {
                return null;
            }
            GuiModList.this.font.getClass();
            int lineIdx = (int)(offset / 9.0);
            if (lineIdx >= this.lines.size() || lineIdx < 1) {
                return null;
            }
            ITextComponent line = this.lines.get(lineIdx - 1);
            if (line != null) {
                int k = this.left + 4;
                for (ITextComponent part : line) {
                    if (!(part instanceof StringTextComponent) || (k += GuiModList.this.font.func_78256_a(((StringTextComponent)part).func_150265_g())) < mouseX) continue;
                    return part;
                }
            }
            return null;
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            ITextComponent component = this.findTextLine((int)mouseX, (int)mouseY);
            if (component != null) {
                GuiModList.this.handleComponentClicked(component);
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }

        @Override
        protected void drawBackground() {
        }
    }

    private static enum SortType implements Comparator<ModInfo>
    {
        NORMAL,
        A_TO_Z{

            @Override
            protected int compare(String name1, String name2) {
                return name1.compareTo(name2);
            }
        }
        ,
        Z_TO_A{

            @Override
            protected int compare(String name1, String name2) {
                return name2.compareTo(name1);
            }
        };

        Button button;

        @Override
        protected int compare(String name1, String name2) {
            return 0;
        }

        @Override
        public int compare(ModInfo o1, ModInfo o2) {
            String name1 = net.minecraftforge.fml.loading.StringUtils.toLowerCase((String)StringUtils.func_76338_a((String)o1.getDisplayName()));
            String name2 = net.minecraftforge.fml.loading.StringUtils.toLowerCase((String)StringUtils.func_76338_a((String)o2.getDisplayName()));
            return this.compare(name1, name2);
        }

        String getButtonText() {
            return I18n.func_135052_a((String)("fml.menu.mods." + net.minecraftforge.fml.loading.StringUtils.toLowerCase((String)this.name())), (Object[])new Object[0]);
        }
    }
}

