/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.network;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.network.NetworkManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.loading.AdvancedLogMessageAdapter;
import net.minecraftforge.fml.network.ConnectionType;
import net.minecraftforge.fml.network.FMLHandshakeMessages;
import net.minecraftforge.fml.network.FMLLoginWrapper;
import net.minecraftforge.fml.network.FMLNetworkConstants;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.GameData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.util.Supplier;

public class FMLHandshakeHandler {
    static final Marker FMLHSMARKER = MarkerManager.getMarker((String)"FMLHANDSHAKE").setParents(new Marker[]{FMLNetworkConstants.NETWORK});
    private static final Logger LOGGER = LogManager.getLogger();
    private static final FMLLoginWrapper loginWrapper = new FMLLoginWrapper();
    private List<NetworkRegistry.LoginPayload> messageList;
    private List<Integer> sentMessages = new ArrayList<Integer>();
    private final NetworkDirection direction;
    private final NetworkManager manager;
    private int packetPosition;
    private Map<ResourceLocation, ForgeRegistry.Snapshot> registrySnapshots;
    private Set<ResourceLocation> registriesToReceive;
    private Map<ResourceLocation, String> registryHashes;

    static void registerHandshake(NetworkManager manager, NetworkDirection direction) {
        manager.channel().attr(FMLNetworkConstants.FML_HANDSHAKE_HANDLER).compareAndSet(null, (Object)new FMLHandshakeHandler(manager, direction));
    }

    static boolean tickLogin(NetworkManager networkManager) {
        return ((FMLHandshakeHandler)networkManager.channel().attr(FMLNetworkConstants.FML_HANDSHAKE_HANDLER).get()).tickServer();
    }

    private FMLHandshakeHandler(NetworkManager networkManager, NetworkDirection side) {
        this.direction = side;
        this.manager = networkManager;
        if (networkManager.func_150731_c()) {
            this.messageList = NetworkRegistry.gatherLoginPayloads(this.direction, true);
            LOGGER.debug(FMLHSMARKER, "Starting local connection.");
        } else if (NetworkHooks.getConnectionType(() -> this.manager) == ConnectionType.VANILLA) {
            this.messageList = Collections.emptyList();
            LOGGER.debug(FMLHSMARKER, "Starting new vanilla network connection.");
        } else {
            this.messageList = NetworkRegistry.gatherLoginPayloads(this.direction, false);
            LOGGER.debug(FMLHSMARKER, "Starting new modded network connection. Found {} messages to dispatch.", (Object)this.messageList.size());
        }
    }

    void handleServerModListOnClient(FMLHandshakeMessages.S2CModList serverModList, java.util.function.Supplier<NetworkEvent.Context> c) {
        LOGGER.debug(FMLHSMARKER, "Logging into server with mod list [{}]", (Object)String.join((CharSequence)", ", serverModList.getModList()));
        boolean accepted = NetworkRegistry.validateClientChannels(serverModList.getChannels());
        c.get().setPacketHandled(true);
        if (!accepted) {
            LOGGER.error(FMLHSMARKER, "Terminating connection with server, mismatched mod list");
            c.get().getNetworkManager().func_150718_a((ITextComponent)new StringTextComponent("Connection closed - mismatched mod channel list"));
            return;
        }
        FMLNetworkConstants.handshakeChannel.reply(new FMLHandshakeMessages.C2SModListReply(), c.get());
        LOGGER.debug(FMLHSMARKER, "Accepted server connection");
        c.get().getNetworkManager().channel().attr(FMLNetworkConstants.FML_NETVERSION).set((Object)"FML2");
        this.registriesToReceive = new HashSet<ResourceLocation>(serverModList.getRegistries());
        this.registrySnapshots = Maps.newHashMap();
        LOGGER.debug(ForgeRegistry.REGISTRIES, "Expecting {} registries: {}", new Supplier[]{() -> this.registriesToReceive.size(), () -> this.registriesToReceive});
    }

    <MSG extends FMLHandshakeMessages.LoginIndexedMessage> void handleIndexedMessage(MSG message, java.util.function.Supplier<NetworkEvent.Context> c) {
        LOGGER.debug(FMLHSMARKER, "Received client indexed reply {} of type {}", (Object)message.getLoginIndex(), (Object)message.getClass().getName());
        boolean removed = this.sentMessages.removeIf(i -> i.intValue() == message.getLoginIndex());
        if (!removed) {
            LOGGER.error(FMLHSMARKER, "Recieved unexpected index {} in client reply", (Object)message.getLoginIndex());
        }
    }

    void handleClientModListOnServer(FMLHandshakeMessages.C2SModListReply clientModList, java.util.function.Supplier<NetworkEvent.Context> c) {
        LOGGER.debug(FMLHSMARKER, "Received client connection with modlist [{}]", (Object)String.join((CharSequence)", ", clientModList.getModList()));
        boolean accepted = NetworkRegistry.validateServerChannels(clientModList.getChannels());
        c.get().setPacketHandled(true);
        if (!accepted) {
            LOGGER.error(FMLHSMARKER, "Terminating connection with client, mismatched mod list");
            c.get().getNetworkManager().func_150718_a((ITextComponent)new StringTextComponent("Connection closed - mismatched mod channel list"));
            return;
        }
        LOGGER.debug(FMLHSMARKER, "Accepted client connection mod list");
    }

    void handleRegistryMessage(FMLHandshakeMessages.S2CRegistry registryPacket, java.util.function.Supplier<NetworkEvent.Context> contextSupplier) {
        LOGGER.debug(FMLHSMARKER, "Received registry packet for {}", (Object)registryPacket.getRegistryName());
        this.registriesToReceive.remove(registryPacket.getRegistryName());
        this.registrySnapshots.put(registryPacket.getRegistryName(), registryPacket.getSnapshot());
        boolean continueHandshake = true;
        if (this.registriesToReceive.isEmpty()) {
            continueHandshake = this.handleRegistryLoading(contextSupplier);
        }
        contextSupplier.get().setPacketHandled(true);
        if (!continueHandshake) {
            LOGGER.error(FMLHSMARKER, "Connection closed, not continuing handshake");
        } else {
            FMLNetworkConstants.handshakeChannel.reply(new FMLHandshakeMessages.C2SAcknowledge(), contextSupplier.get());
        }
    }

    private boolean handleRegistryLoading(java.util.function.Supplier<NetworkEvent.Context> contextSupplier) {
        AtomicBoolean successfulConnection = new AtomicBoolean(false);
        CountDownLatch block = new CountDownLatch(1);
        contextSupplier.get().enqueueWork(() -> {
            LOGGER.debug(FMLHSMARKER, "Injecting registry snapshot from server.");
            Multimap<ResourceLocation, ResourceLocation> missingData = GameData.injectSnapshot(this.registrySnapshots, false, false);
            LOGGER.debug(FMLHSMARKER, "Snapshot injected.");
            if (!missingData.isEmpty()) {
                LOGGER.error(FMLHSMARKER, "Missing registry data for network connection:\n{}", (Object)new AdvancedLogMessageAdapter(sb -> missingData.forEach((reg, entry) -> sb.append("\t").append(reg).append(": ").append(entry).append('\n'))));
            }
            successfulConnection.set(missingData.isEmpty());
            block.countDown();
        });
        LOGGER.debug(FMLHSMARKER, "Waiting for registries to load.");
        try {
            block.await();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        if (successfulConnection.get()) {
            LOGGER.debug(FMLHSMARKER, "Registry load complete, continuing handshake.");
        } else {
            LOGGER.error(FMLHSMARKER, "Failed to load registry, closing connection.");
            this.manager.func_150718_a((ITextComponent)new StringTextComponent("Failed to synchronize registry data from server, closing connection"));
        }
        return successfulConnection.get();
    }

    void handleClientAck(FMLHandshakeMessages.C2SAcknowledge msg, java.util.function.Supplier<NetworkEvent.Context> contextSupplier) {
        LOGGER.debug(FMLHSMARKER, "Received acknowledgement from client");
        contextSupplier.get().setPacketHandled(true);
    }

    void handleConfigSync(FMLHandshakeMessages.S2CConfigData msg, java.util.function.Supplier<NetworkEvent.Context> contextSupplier) {
        LOGGER.debug(FMLHSMARKER, "Received config sync from server");
        ConfigTracker.INSTANCE.receiveSyncedConfig(msg, contextSupplier);
        contextSupplier.get().setPacketHandled(true);
        FMLNetworkConstants.handshakeChannel.reply(new FMLHandshakeMessages.C2SAcknowledge(), contextSupplier.get());
    }

    public boolean tickServer() {
        if (this.packetPosition < this.messageList.size()) {
            NetworkRegistry.LoginPayload message = this.messageList.get(this.packetPosition);
            LOGGER.debug(FMLHSMARKER, "Sending ticking packet info '{}' to '{}' sequence {}", (Object)message.getMessageContext(), (Object)message.getChannelName(), (Object)this.packetPosition);
            this.sentMessages.add(this.packetPosition);
            loginWrapper.sendServerToClientLoginPacket(message.getChannelName(), message.getData(), this.packetPosition, this.manager);
            ++this.packetPosition;
        }
        if (this.sentMessages.isEmpty() && this.packetPosition >= this.messageList.size() - 1) {
            this.manager.channel().attr(FMLNetworkConstants.FML_HANDSHAKE_HANDLER).set(null);
            LOGGER.debug(FMLHSMARKER, "Handshake complete!");
            return true;
        }
        return false;
    }
}

