/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.packs;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.packs.ModFileResourcePack;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourcePackLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Map<ModFile, ModFileResourcePack> modResourcePacks;
    private static ResourcePackList<?> resourcePackList;

    public static Optional<ModFileResourcePack> getResourcePackFor(String modId) {
        return Optional.ofNullable(ModList.get().getModFileById(modId)).map(ModFileInfo::getFile).map(mf -> modResourcePacks.get(mf));
    }

    public static <T extends ResourcePackInfo> void loadResourcePacks(ResourcePackList<T> resourcePacks) {
        resourcePackList = resourcePacks;
        modResourcePacks = ModList.get().getModFiles().stream().filter(mf -> !Objects.equals(mf.getModLoader(), "minecraft")).map(mf -> new ModFileResourcePack(mf.getFile())).collect(Collectors.toMap(ModFileResourcePack::getModFile, Function.identity()));
        resourcePacks.func_198982_a((IPackFinder)new ModPackFinder());
    }

    private static class ModPackFinder
    implements IPackFinder {
        private ModPackFinder() {
        }

        public <T extends ResourcePackInfo> void func_195730_a(Map<String, T> packList, ResourcePackInfo.IFactory<T> factory) {
            for (Map.Entry e : modResourcePacks.entrySet()) {
                IModInfo mod = (IModInfo)((ModFile)e.getKey()).getModInfos().get(0);
                if (Objects.equals(mod.getModId(), "minecraft")) continue;
                String name = "mod:" + mod.getModId();
                ResourcePackInfo packInfo = ResourcePackInfo.func_195793_a((String)name, (boolean)true, e::getValue, factory, (ResourcePackInfo.Priority)ResourcePackInfo.Priority.BOTTOM);
                if (packInfo == null) {
                    ModLoader.get().addWarning(new ModLoadingWarning(mod, ModLoadingStage.ERROR, "fml.modloading.brokenresources", e.getKey()));
                    continue;
                }
                ((ModFileResourcePack)((Object)e.getValue())).setPackInfo(packInfo);
                LOGGER.debug(Logging.CORE, "Generating PackInfo named {} for mod file {}", (Object)name, (Object)((ModFile)e.getKey()).getFilePath());
                packList.put(name, packInfo);
            }
        }
    }
}

